/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;
import jxl.read.biff.BiffException;

public final class CompoundFile
extends BaseCompoundFile {
    private static Logger logger = Logger.getLogger(CompoundFile.class);
    private byte[] data;
    private int numBigBlockDepotBlocks;
    private int sbdStartBlock;
    private int rootStartBlock;
    private int extensionBlock;
    private int numExtensionBlocks;
    private byte[] rootEntry;
    private int[] bigBlockChain;
    private int[] smallBlockChain;
    private int[] bigBlockDepotBlocks;
    private ArrayList propertySets;
    private WorkbookSettings settings;
    private BaseCompoundFile.PropertyStorage rootEntryPropertyStorage;

    public CompoundFile(byte[] byArray, WorkbookSettings workbookSettings) throws BiffException {
        int n;
        int n2;
        this.data = byArray;
        this.settings = workbookSettings;
        for (n2 = 0; n2 < IDENTIFIER.length; ++n2) {
            if (this.data[n2] == IDENTIFIER[n2]) continue;
            throw new BiffException(BiffException.unrecognizedOLEFile);
        }
        this.propertySets = new ArrayList();
        this.numBigBlockDepotBlocks = IntegerHelper.getInt(this.data[44], this.data[45], this.data[46], this.data[47]);
        this.sbdStartBlock = IntegerHelper.getInt(this.data[60], this.data[61], this.data[62], this.data[63]);
        this.rootStartBlock = IntegerHelper.getInt(this.data[48], this.data[49], this.data[50], this.data[51]);
        this.extensionBlock = IntegerHelper.getInt(this.data[68], this.data[69], this.data[70], this.data[71]);
        this.numExtensionBlocks = IntegerHelper.getInt(this.data[72], this.data[73], this.data[74], this.data[75]);
        this.bigBlockDepotBlocks = new int[this.numBigBlockDepotBlocks];
        n2 = 76;
        int n3 = this.numBigBlockDepotBlocks;
        if (this.numExtensionBlocks != 0) {
            n3 = 109;
        }
        for (n = 0; n < n3; ++n) {
            this.bigBlockDepotBlocks[n] = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
            n2 += 4;
        }
        for (n = 0; n < this.numExtensionBlocks; ++n) {
            n2 = (this.extensionBlock + 1) * 512;
            int n4 = Math.min(this.numBigBlockDepotBlocks - n3, 127);
            for (int i = n3; i < n3 + n4; ++i) {
                this.bigBlockDepotBlocks[i] = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
                n2 += 4;
            }
            if ((n3 += n4) >= this.numBigBlockDepotBlocks) continue;
            this.extensionBlock = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
        }
        this.readBigBlockDepot();
        this.readSmallBlockDepot();
        this.rootEntry = this.readData(this.rootStartBlock);
        this.readPropertySets();
    }

    private void readBigBlockDepot() {
        int n = 0;
        int n2 = 0;
        this.bigBlockChain = new int[this.numBigBlockDepotBlocks * 512 / 4];
        for (int i = 0; i < this.numBigBlockDepotBlocks; ++i) {
            n = (this.bigBlockDepotBlocks[i] + 1) * 512;
            for (int j = 0; j < 128; ++j) {
                this.bigBlockChain[n2] = IntegerHelper.getInt(this.data[n], this.data[n + 1], this.data[n + 2], this.data[n + 3]);
                n += 4;
                ++n2;
            }
        }
    }

    private void readSmallBlockDepot() {
        int n = 0;
        int n2 = 0;
        int n3 = this.sbdStartBlock;
        this.smallBlockChain = new int[0];
        if (n3 == -1) {
            logger.warn("invalid small block depot number");
            return;
        }
        while (n3 != -2) {
            int[] nArray = this.smallBlockChain;
            this.smallBlockChain = new int[this.smallBlockChain.length + 128];
            System.arraycopy(nArray, 0, this.smallBlockChain, 0, nArray.length);
            n = (n3 + 1) * 512;
            for (int i = 0; i < 128; ++i) {
                this.smallBlockChain[n2] = IntegerHelper.getInt(this.data[n], this.data[n + 1], this.data[n + 2], this.data[n + 3]);
                n += 4;
                ++n2;
            }
            n3 = this.bigBlockChain[n3];
        }
    }

    private void readPropertySets() {
        byte[] byArray = null;
        for (int i = 0; i < this.rootEntry.length; i += 128) {
            byArray = new byte[128];
            System.arraycopy(this.rootEntry, i, byArray, 0, byArray.length);
            BaseCompoundFile.PropertyStorage propertyStorage = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage(byArray);
            if (propertyStorage.name == null || propertyStorage.name.length() == 0) {
                if (propertyStorage.type == 5) {
                    propertyStorage.name = "Root Entry";
                    logger.warn("Property storage name for " + propertyStorage.type + " is empty - setting to " + "Root Entry");
                } else if (propertyStorage.size != 0) {
                    logger.warn("Property storage type " + propertyStorage.type + " is non-empty and has no associated name");
                }
            }
            this.propertySets.add(propertyStorage);
            if (!propertyStorage.name.equalsIgnoreCase("Root Entry")) continue;
            this.rootEntryPropertyStorage = propertyStorage;
        }
        if (this.rootEntryPropertyStorage == null) {
            this.rootEntryPropertyStorage = (BaseCompoundFile.PropertyStorage)this.propertySets.get(0);
        }
    }

    public byte[] getStream(String string) throws BiffException {
        BaseCompoundFile.PropertyStorage propertyStorage = this.findPropertyStorage(string, this.rootEntryPropertyStorage);
        if (propertyStorage == null) {
            propertyStorage = this.getPropertyStorage(string);
        }
        if (propertyStorage.size >= 4096 || string.equalsIgnoreCase("Root Entry")) {
            return this.getBigBlockStream(propertyStorage);
        }
        return this.getSmallBlockStream(propertyStorage);
    }

    public byte[] getStream(int n) throws BiffException {
        BaseCompoundFile.PropertyStorage propertyStorage = this.getPropertyStorage(n);
        if (propertyStorage.size >= 4096 || propertyStorage.name.equalsIgnoreCase("Root Entry")) {
            return this.getBigBlockStream(propertyStorage);
        }
        return this.getSmallBlockStream(propertyStorage);
    }

    public BaseCompoundFile.PropertyStorage findPropertyStorage(String string) {
        return this.findPropertyStorage(string, this.rootEntryPropertyStorage);
    }

    private BaseCompoundFile.PropertyStorage findPropertyStorage(String string, BaseCompoundFile.PropertyStorage propertyStorage) {
        if (propertyStorage.child == -1) {
            return null;
        }
        BaseCompoundFile.PropertyStorage propertyStorage2 = this.getPropertyStorage(propertyStorage.child);
        if (propertyStorage2.name.equalsIgnoreCase(string)) {
            return propertyStorage2;
        }
        BaseCompoundFile.PropertyStorage propertyStorage3 = propertyStorage2;
        while (propertyStorage3.previous != -1) {
            propertyStorage3 = this.getPropertyStorage(propertyStorage3.previous);
            if (!propertyStorage3.name.equalsIgnoreCase(string)) continue;
            return propertyStorage3;
        }
        BaseCompoundFile.PropertyStorage propertyStorage4 = propertyStorage2;
        while (propertyStorage4.next != -1) {
            propertyStorage4 = this.getPropertyStorage(propertyStorage4.next);
            if (!propertyStorage4.name.equalsIgnoreCase(string)) continue;
            return propertyStorage4;
        }
        return this.findPropertyStorage(string, propertyStorage2);
    }

    private BaseCompoundFile.PropertyStorage getPropertyStorage(String string) throws BiffException {
        Iterator iterator = this.propertySets.iterator();
        boolean bl = false;
        boolean bl2 = false;
        BaseCompoundFile.PropertyStorage propertyStorage = null;
        while (iterator.hasNext()) {
            BaseCompoundFile.PropertyStorage propertyStorage2 = (BaseCompoundFile.PropertyStorage)iterator.next();
            if (!propertyStorage2.name.equalsIgnoreCase(string)) continue;
            bl2 = bl;
            bl = true;
            propertyStorage = propertyStorage2;
        }
        if (bl2) {
            logger.warn("found multiple copies of property set " + string);
        }
        if (!bl) {
            throw new BiffException(BiffException.streamNotFound);
        }
        return propertyStorage;
    }

    private BaseCompoundFile.PropertyStorage getPropertyStorage(int n) {
        return (BaseCompoundFile.PropertyStorage)this.propertySets.get(n);
    }

    private byte[] getBigBlockStream(BaseCompoundFile.PropertyStorage propertyStorage) {
        int n;
        int n2 = propertyStorage.size / 512;
        if (propertyStorage.size % 512 != 0) {
            ++n2;
        }
        byte[] byArray = new byte[n2 * 512];
        int n3 = propertyStorage.startBlock;
        int n4 = 0;
        for (n = 0; n3 != -2 && n < n2; ++n) {
            n4 = (n3 + 1) * 512;
            System.arraycopy(this.data, n4, byArray, n * 512, 512);
            n3 = this.bigBlockChain[n3];
        }
        if (n3 != -2 && n == n2) {
            logger.warn("Property storage size inconsistent with block chain.");
        }
        return byArray;
    }

    private byte[] getSmallBlockStream(BaseCompoundFile.PropertyStorage propertyStorage) throws BiffException {
        byte[] byArray = this.readData(this.rootEntryPropertyStorage.startBlock);
        byte[] byArray2 = new byte[]{};
        int n = propertyStorage.startBlock;
        int n2 = 0;
        while (n != -2) {
            byte[] byArray3 = byArray2;
            byArray2 = new byte[byArray3.length + 64];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            n2 = n * 64;
            System.arraycopy(byArray, n2, byArray2, byArray3.length, 64);
            if ((n = this.smallBlockChain[n]) != -1) continue;
            logger.warn("Incorrect terminator for small block stream " + propertyStorage.name);
            n = -2;
        }
        return byArray2;
    }

    private byte[] readData(int n) throws BiffException {
        int n2 = n;
        int n3 = 0;
        byte[] byArray = new byte[]{};
        while (n2 != -2) {
            byte[] byArray2 = byArray;
            byArray = new byte[byArray2.length + 512];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            n3 = (n2 + 1) * 512;
            System.arraycopy(this.data, n3, byArray, byArray2.length, 512);
            if (this.bigBlockChain[n2] == n2) {
                throw new BiffException(BiffException.corruptFileFormat);
            }
            n2 = this.bigBlockChain[n2];
        }
        return byArray;
    }

    public int getNumberOfPropertySets() {
        return this.propertySets.size();
    }

    public BaseCompoundFile.PropertyStorage getPropertySet(int n) {
        return this.getPropertyStorage(n);
    }
}

