/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

public class ExternalSheetRecord
extends RecordData {
    private static Logger logger = Logger.getLogger(ExternalSheetRecord.class);
    public static Biff7 biff7 = new Biff7();
    private XTI[] xtiArray;

    ExternalSheetRecord(Record record, WorkbookSettings workbookSettings) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        int n = IntegerHelper.getInt(byArray[0], byArray[1]);
        if (byArray.length < n * 6 + 2) {
            this.xtiArray = new XTI[0];
            logger.warn("Could not process external sheets.  Formulas may be compromised.");
            return;
        }
        this.xtiArray = new XTI[n];
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            int n3 = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
            int n4 = IntegerHelper.getInt(byArray[n2 + 2], byArray[n2 + 3]);
            int n5 = IntegerHelper.getInt(byArray[n2 + 4], byArray[n2 + 5]);
            this.xtiArray[i] = new XTI(n3, n4, n5);
            n2 += 6;
        }
    }

    ExternalSheetRecord(Record record, WorkbookSettings workbookSettings, Biff7 biff7) {
        super(record);
        logger.warn("External sheet record for Biff 7 not supported");
    }

    public int getNumRecords() {
        return this.xtiArray != null ? this.xtiArray.length : 0;
    }

    public int getSupbookIndex(int n) {
        return this.xtiArray[n].supbookIndex;
    }

    public int getFirstTabIndex(int n) {
        return this.xtiArray[n].firstTab;
    }

    public int getLastTabIndex(int n) {
        return this.xtiArray[n].lastTab;
    }

    public byte[] getData() {
        return this.getRecord().getData();
    }

    private static class XTI {
        int supbookIndex;
        int firstTab;
        int lastTab;

        XTI(int n, int n2, int n3) {
            this.supbookIndex = n;
            this.firstTab = n2;
            this.lastTab = n3;
        }
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

