/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import jxl.CellReferenceHelper;
import jxl.Hyperlink;
import jxl.Range;
import jxl.Sheet;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.SheetRangeImpl;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;

public class HyperlinkRecord
extends RecordData
implements Hyperlink {
    private static Logger logger = Logger.getLogger(HyperlinkRecord.class);
    private int firstRow;
    private int lastRow;
    private int firstColumn;
    private int lastColumn;
    private URL url;
    private File file;
    private String location;
    private SheetRangeImpl range;
    private LinkType linkType = unknown;
    private static final LinkType urlLink = new LinkType();
    private static final LinkType fileLink = new LinkType();
    private static final LinkType workbookLink = new LinkType();
    private static final LinkType unknown = new LinkType();

    HyperlinkRecord(Record record, Sheet sheet, WorkbookSettings workbookSettings) {
        super(record);
        int n;
        int n2;
        byte[] byArray = this.getRecord().getData();
        this.firstRow = IntegerHelper.getInt(byArray[0], byArray[1]);
        this.lastRow = IntegerHelper.getInt(byArray[2], byArray[3]);
        this.firstColumn = IntegerHelper.getInt(byArray[4], byArray[5]);
        this.lastColumn = IntegerHelper.getInt(byArray[6], byArray[7]);
        this.range = new SheetRangeImpl(sheet, this.firstColumn, this.firstRow, this.lastColumn, this.lastRow);
        int n3 = IntegerHelper.getInt(byArray[28], byArray[29], byArray[30], byArray[31]);
        boolean bl = (n3 & 0x14) != 0;
        int n4 = 32;
        int n5 = 0;
        if (bl) {
            n2 = IntegerHelper.getInt(byArray[n4], byArray[n4 + 1], byArray[n4 + 2], byArray[n4 + 3]);
            n5 = n2 * 2 + 4;
        }
        n4 += n5;
        n2 = (n3 & 0x80) != 0 ? 1 : 0;
        int n6 = 0;
        if (n2 != 0) {
            n = IntegerHelper.getInt(byArray[n4], byArray[n4 + 1], byArray[n4 + 2], byArray[n4 + 3]);
            n6 = n * 2 + 4;
        }
        n4 += n6;
        if ((n3 & 3) == 3) {
            this.linkType = urlLink;
            if (byArray[n4] == 3) {
                this.linkType = fileLink;
            }
        } else if ((n3 & 1) != 0) {
            this.linkType = fileLink;
            if (byArray[n4] == -32) {
                this.linkType = urlLink;
            }
        } else if ((n3 & 8) != 0) {
            this.linkType = workbookLink;
        }
        if (this.linkType == urlLink) {
            String string = null;
            try {
                int n7 = IntegerHelper.getInt(byArray[n4 += 16], byArray[n4 + 1], byArray[n4 + 2], byArray[n4 + 3]);
                string = StringHelper.getUnicodeString(byArray, n7 / 2 - 1, n4 + 4);
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                logger.warn("URL " + string + " is malformed.  Trying a file");
                try {
                    this.linkType = fileLink;
                    this.file = new File(string);
                }
                catch (Exception exception) {
                    logger.warn("Cannot set to file.  Setting a default URL");
                    try {
                        this.linkType = urlLink;
                        this.url = new URL("http://www.andykhan.com/jexcelapi/index.html");
                    }
                    catch (MalformedURLException malformedURLException2) {
                    }
                }
            }
            catch (Throwable throwable) {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                CellReferenceHelper.getCellReference(this.firstColumn, this.firstRow, stringBuffer);
                CellReferenceHelper.getCellReference(this.lastColumn, this.lastRow, stringBuffer2);
                stringBuffer.insert(0, "Exception when parsing URL ");
                stringBuffer.append('\"').append(stringBuffer2.toString()).append("\".  Using default.");
                logger.warn(stringBuffer, throwable);
                try {
                    this.url = new URL("http://www.andykhan.com/jexcelapi/index.html");
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else if (this.linkType == fileLink) {
            try {
                n = IntegerHelper.getInt(byArray[n4 += 16], byArray[n4 + 1]);
                int n8 = IntegerHelper.getInt(byArray[n4 + 2], byArray[n4 + 3], byArray[n4 + 4], byArray[n4 + 5]);
                String string = StringHelper.getString(byArray, n8 - 1, n4 + 6, workbookSettings);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("..\\");
                }
                stringBuffer.append(string);
                this.file = new File(stringBuffer.toString());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                logger.warn("Exception when parsing file " + throwable.getClass().getName() + ".");
                this.file = new File(".");
            }
        } else if (this.linkType == workbookLink) {
            n = IntegerHelper.getInt(byArray[32], byArray[33], byArray[34], byArray[35]);
            this.location = StringHelper.getUnicodeString(byArray, n - 1, 36);
        } else {
            logger.warn("Cannot determine link type");
            return;
        }
    }

    public boolean isFile() {
        return this.linkType == fileLink;
    }

    public boolean isURL() {
        return this.linkType == urlLink;
    }

    public boolean isLocation() {
        return this.linkType == workbookLink;
    }

    public int getRow() {
        return this.firstRow;
    }

    public int getColumn() {
        return this.firstColumn;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public int getLastColumn() {
        return this.lastColumn;
    }

    public URL getURL() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public Record getRecord() {
        return super.getRecord();
    }

    public Range getRange() {
        return this.range;
    }

    public String getLocation() {
        return this.location;
    }

    private static class LinkType {
        private LinkType() {
        }
    }
}

