/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.read.biff.CellValue;
import jxl.read.biff.RKHelper;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

class RKRecord
extends CellValue
implements NumberCell {
    private static Logger logger = Logger.getLogger(RKRecord.class);
    private double value;
    private NumberFormat format;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public RKRecord(Record record, FormattingRecords formattingRecords, SheetImpl sheetImpl) {
        super(record, formattingRecords, sheetImpl);
        byte[] byArray = this.getRecord().getData();
        int n = IntegerHelper.getInt(byArray[6], byArray[7], byArray[8], byArray[9]);
        this.value = RKHelper.getDouble(n);
        this.format = formattingRecords.getNumberFormat(this.getXFIndex());
        if (this.format == null) {
            this.format = defaultFormat;
        }
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return this.format.format(this.value);
    }

    public CellType getType() {
        return CellType.NUMBER;
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }
}

