/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.util.ArrayList;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.read.biff.File;

public final class Record {
    private static final Logger logger = Logger.getLogger(Record.class);
    private int code;
    private Type type;
    private int length;
    private int dataPos;
    private File file;
    private byte[] data;
    private ArrayList continueRecords;

    Record(byte[] byArray, int n, File file) {
        this.code = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        this.length = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3]);
        this.file = file;
        this.file.skip(4);
        this.dataPos = file.getPos();
        this.file.skip(this.length);
        this.type = Type.getType(this.code);
    }

    public Type getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        if (this.data == null) {
            this.data = this.file.read(this.dataPos, this.length);
        }
        if (this.continueRecords != null) {
            int n = 0;
            byte[][] byArrayArray = new byte[this.continueRecords.size()][];
            for (int i = 0; i < this.continueRecords.size(); ++i) {
                Record record = (Record)this.continueRecords.get(i);
                byArrayArray[i] = record.getData();
                byte[] byArray = byArrayArray[i];
                n += byArray.length;
            }
            byte[] byArray = new byte[this.data.length + n];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            int n2 = this.data.length;
            for (int i = 0; i < byArrayArray.length; ++i) {
                byte[] byArray2 = byArrayArray[i];
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
            }
            this.data = byArray;
        }
        return this.data;
    }

    public int getCode() {
        return this.code;
    }

    void setType(Type type) {
        this.type = type;
    }

    public void addContinueRecord(Record record) {
        if (this.continueRecords == null) {
            this.continueRecords = new ArrayList();
        }
        this.continueRecords.add(record);
    }
}

