/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;

class SSTRecord
extends RecordData {
    private int totalStrings;
    private int uniqueStrings;
    private String[] strings;
    private int[] continuationBreaks;

    public SSTRecord(Record record, Record[] recordArray, WorkbookSettings workbookSettings) {
        super(record);
        int n = 0;
        for (int i = 0; i < recordArray.length; ++i) {
            n += recordArray[i].getLength();
        }
        byte[] byArray = new byte[n += this.getRecord().getLength()];
        int n2 = 0;
        System.arraycopy(this.getRecord().getData(), 0, byArray, 0, this.getRecord().getLength());
        n2 += this.getRecord().getLength();
        this.continuationBreaks = new int[recordArray.length];
        Record record2 = null;
        for (int i = 0; i < recordArray.length; ++i) {
            record2 = recordArray[i];
            System.arraycopy(record2.getData(), 0, byArray, n2, record2.getLength());
            this.continuationBreaks[i] = n2;
            n2 += record2.getLength();
        }
        this.totalStrings = IntegerHelper.getInt(byArray[0], byArray[1], byArray[2], byArray[3]);
        this.uniqueStrings = IntegerHelper.getInt(byArray[4], byArray[5], byArray[6], byArray[7]);
        this.strings = new String[this.uniqueStrings];
        this.readStrings(byArray, 8, workbookSettings);
    }

    private void readStrings(byte[] byArray, int n, WorkbookSettings workbookSettings) {
        int n2 = n;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.uniqueStrings; ++i) {
            int n5 = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
            byte by = byArray[n2 += 2];
            ++n2;
            bl3 = (by & 4) != 0;
            boolean bl4 = bl2 = (by & 8) != 0;
            if (bl2) {
                n3 = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1]);
                n2 += 2;
            }
            if (bl3) {
                n4 = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
                n2 += 4;
            }
            bl = (by & 1) == 0;
            ByteArrayHolder byteArrayHolder = new ByteArrayHolder();
            BooleanHolder booleanHolder = new BooleanHolder();
            booleanHolder.value = bl;
            n2 += this.getChars(byArray, byteArrayHolder, n2, booleanHolder, n5);
            bl = booleanHolder.value;
            string = bl ? StringHelper.getString(byteArrayHolder.bytes, n5, 0, workbookSettings) : StringHelper.getUnicodeString(byteArrayHolder.bytes, n5, 0);
            this.strings[i] = string;
            if (bl2) {
                n2 += 4 * n3;
            }
            if (bl3) {
                n2 += n4;
            }
            if (n2 <= byArray.length) continue;
            Assert.verify(false, "pos exceeds record length");
        }
    }

    private int getChars(byte[] byArray, ByteArrayHolder byteArrayHolder, int n, BooleanHolder booleanHolder, int n2) {
        int n3 = 0;
        boolean bl = false;
        byteArrayHolder.bytes = booleanHolder.value ? new byte[n2] : new byte[n2 * 2];
        while (n3 < this.continuationBreaks.length && !bl) {
            bl = n <= this.continuationBreaks[n3] && n + byteArrayHolder.bytes.length > this.continuationBreaks[n3];
            if (bl) continue;
            ++n3;
        }
        if (!bl) {
            System.arraycopy(byArray, n, byteArrayHolder.bytes, 0, byteArrayHolder.bytes.length);
            return byteArrayHolder.bytes.length;
        }
        int n4 = this.continuationBreaks[n3];
        System.arraycopy(byArray, n, byteArrayHolder.bytes, 0, n4 - n);
        int n5 = n4 - n;
        int n6 = booleanHolder.value ? n5 : n5 / 2;
        n5 += this.getContinuedString(byArray, byteArrayHolder, n5, n3, booleanHolder, n2 - n6);
        return n5;
    }

    private int getContinuedString(byte[] byArray, ByteArrayHolder byteArrayHolder, int n, int n2, BooleanHolder booleanHolder, int n3) {
        int n4 = this.continuationBreaks[n2];
        int n5 = 0;
        while (n3 > 0) {
            int n6;
            Assert.verify(n2 < this.continuationBreaks.length, "continuation break index");
            if (booleanHolder.value && byArray[n4] == 0) {
                int n7 = n2 == this.continuationBreaks.length - 1 ? n3 : Math.min(n3, this.continuationBreaks[n2 + 1] - n4 - 1);
                System.arraycopy(byArray, n4 + 1, byteArrayHolder.bytes, n, n7);
                n += n7;
                n5 += n7 + 1;
                n3 -= n7;
                booleanHolder.value = true;
            } else if (!booleanHolder.value && byArray[n4] != 0) {
                int n8 = n2 == this.continuationBreaks.length - 1 ? n3 * 2 : Math.min(n3 * 2, this.continuationBreaks[n2 + 1] - n4 - 1);
                System.arraycopy(byArray, n4 + 1, byteArrayHolder.bytes, n, n8);
                n += n8;
                n5 += n8 + 1;
                n3 -= n8 / 2;
                booleanHolder.value = false;
            } else if (!booleanHolder.value && byArray[n4] == 0) {
                int n9 = n2 == this.continuationBreaks.length - 1 ? n3 : Math.min(n3, this.continuationBreaks[n2 + 1] - n4 - 1);
                for (n6 = 0; n6 < n9; ++n6) {
                    byteArrayHolder.bytes[n] = byArray[n4 + n6 + 1];
                    n += 2;
                }
                n5 += n9 + 1;
                n3 -= n9;
                booleanHolder.value = false;
            } else {
                byte[] byArray2 = byteArrayHolder.bytes;
                byteArrayHolder.bytes = new byte[n * 2 + n3 * 2];
                for (n6 = 0; n6 < n; ++n6) {
                    byteArrayHolder.bytes[n6 * 2] = byArray2[n6];
                }
                n6 = n2 == this.continuationBreaks.length - 1 ? n3 * 2 : Math.min(n3 * 2, this.continuationBreaks[n2 + 1] - n4 - 1);
                System.arraycopy(byArray, n4 + 1, byteArrayHolder.bytes, n *= 2, n6);
                n += n6;
                n5 += n6 + 1;
                n3 -= n6 / 2;
                booleanHolder.value = false;
            }
            if (++n2 >= this.continuationBreaks.length) continue;
            n4 = this.continuationBreaks[n2];
        }
        return n5;
    }

    public String getString(int n) {
        Assert.verify(n < this.uniqueStrings);
        return this.strings[n];
    }

    private static class BooleanHolder {
        public boolean value;

        private BooleanHolder() {
        }
    }

    private static class ByteArrayHolder {
        public byte[] bytes;

        private ByteArrayHolder() {
        }
    }
}

