/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.Hyperlink;
import jxl.Image;
import jxl.LabelCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.AutoFilter;
import jxl.biff.BuiltInName;
import jxl.biff.CellReferenceHelper;
import jxl.biff.ConditionalFormat;
import jxl.biff.DataValidation;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.Type;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.format.CellFormat;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BiffException;
import jxl.read.biff.ButtonPropertySetRecord;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.File;
import jxl.read.biff.NameRecord;
import jxl.read.biff.PLSRecord;
import jxl.read.biff.Record;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SheetReader;
import jxl.read.biff.WorkbookParser;

public class SheetImpl
implements Sheet {
    private static Logger logger = Logger.getLogger(SheetImpl.class);
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord sheetBof;
    private BOFRecord workbookBof;
    private FormattingRecords formattingRecords;
    private String name;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;
    private ColumnInfoRecord[] columnInfos;
    private RowRecord[] rowRecords;
    private ArrayList rowProperties;
    private ArrayList columnInfosArray;
    private ArrayList sharedFormulas;
    private ArrayList hyperlinks;
    private ArrayList charts;
    private ArrayList drawings;
    private ArrayList images;
    private DataValidation dataValidation;
    private Range[] mergedCells;
    private boolean columnInfosInitialized;
    private boolean rowRecordsInitialized;
    private boolean nineteenFour;
    private WorkspaceInformationRecord workspaceOptions;
    private boolean hidden;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private SheetSettings settings;
    private int[] rowBreaks;
    private int[] columnBreaks;
    private ArrayList localNames;
    private ArrayList conditionalFormats;
    private AutoFilter autoFilter;
    private WorkbookParser workbook;
    private WorkbookSettings workbookSettings;

    SheetImpl(File file, SSTRecord sSTRecord, FormattingRecords formattingRecords, BOFRecord bOFRecord, BOFRecord bOFRecord2, boolean bl, WorkbookParser workbookParser) throws BiffException {
        this.excelFile = file;
        this.sharedStrings = sSTRecord;
        this.formattingRecords = formattingRecords;
        this.sheetBof = bOFRecord;
        this.workbookBof = bOFRecord2;
        this.columnInfosArray = new ArrayList();
        this.sharedFormulas = new ArrayList();
        this.hyperlinks = new ArrayList();
        this.rowProperties = new ArrayList(10);
        this.columnInfosInitialized = false;
        this.rowRecordsInitialized = false;
        this.nineteenFour = bl;
        this.workbook = workbookParser;
        this.workbookSettings = this.workbook.getSettings();
        this.startPosition = file.getPos();
        if (this.sheetBof.isChart()) {
            this.startPosition -= this.sheetBof.getLength() + 4;
        }
        Record record = null;
        int n = 1;
        while (n >= 1) {
            record = file.next();
            if (record.getCode() == Type.EOF.value) {
                --n;
            }
            if (record.getCode() != Type.BOF.value) continue;
            ++n;
        }
    }

    public Cell getCell(String string) {
        return this.getCell(CellReferenceHelper.getColumn(string), CellReferenceHelper.getRow(string));
    }

    public Cell getCell(int n, int n2) {
        Cell cell;
        if (this.cells == null) {
            this.readSheet();
        }
        if ((cell = this.cells[n2][n]) == null) {
            this.cells[n2][n] = cell = new EmptyCell(n, n2);
        }
        return cell;
    }

    public Cell findCell(String string) {
        Cell cell = null;
        boolean bl = false;
        for (int i = 0; i < this.getRows() && !bl; ++i) {
            Cell[] cellArray = this.getRow(i);
            for (int j = 0; j < cellArray.length && !bl; ++j) {
                if (!cellArray[j].getContents().equals(string)) continue;
                cell = cellArray[j];
                bl = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String string) {
        LabelCell labelCell = null;
        boolean bl = false;
        for (int i = 0; i < this.getRows() && !bl; ++i) {
            Cell[] cellArray = this.getRow(i);
            for (int j = 0; j < cellArray.length && !bl; ++j) {
                if (cellArray[j].getType() != CellType.LABEL && cellArray[j].getType() != CellType.STRING_FORMULA || !cellArray[j].getContents().equals(string)) continue;
                labelCell = (LabelCell)cellArray[j];
                bl = true;
            }
        }
        return labelCell;
    }

    public int getRows() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numRows;
    }

    public int getColumns() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numCols;
    }

    public Cell[] getRow(int n) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean bl = false;
        int n2 = this.numCols - 1;
        while (n2 >= 0 && !bl) {
            if (this.cells[n][n2] != null) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i = 0; i <= n2; ++i) {
            cellArray[i] = this.getCell(i, n);
        }
        return cellArray;
    }

    public Cell[] getColumn(int n) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean bl = false;
        int n2 = this.numRows - 1;
        while (n2 >= 0 && !bl) {
            if (this.cells[n2][n] != null) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i = 0; i <= n2; ++i) {
            cellArray[i] = this.getCell(n, i);
        }
        return cellArray;
    }

    public String getName() {
        return this.name;
    }

    final void setName(String string) {
        this.name = string;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnInfoRecord getColumnInfo(int n) {
        if (!this.columnInfosInitialized) {
            Iterator iterator = this.columnInfosArray.iterator();
            ColumnInfoRecord columnInfoRecord = null;
            while (iterator.hasNext()) {
                columnInfoRecord = (ColumnInfoRecord)iterator.next();
                int n2 = Math.max(0, columnInfoRecord.getStartColumn());
                int n3 = Math.min(this.columnInfos.length - 1, columnInfoRecord.getEndColumn());
                for (int i = n2; i <= n3; ++i) {
                    this.columnInfos[i] = columnInfoRecord;
                }
                if (n3 >= n2) continue;
                this.columnInfos[n2] = columnInfoRecord;
            }
            this.columnInfosInitialized = true;
        }
        return n < this.columnInfos.length ? this.columnInfos[n] : null;
    }

    public ColumnInfoRecord[] getColumnInfos() {
        ColumnInfoRecord[] columnInfoRecordArray = new ColumnInfoRecord[this.columnInfosArray.size()];
        for (int i = 0; i < this.columnInfosArray.size(); ++i) {
            columnInfoRecordArray[i] = (ColumnInfoRecord)this.columnInfosArray.get(i);
        }
        return columnInfoRecordArray;
    }

    final void setHidden(boolean bl) {
        this.hidden = bl;
    }

    final void clear() {
        this.cells = null;
        this.mergedCells = null;
        this.columnInfosArray.clear();
        this.sharedFormulas.clear();
        this.hyperlinks.clear();
        this.columnInfosInitialized = false;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    final void readSheet() {
        if (!this.sheetBof.isWorksheet()) {
            this.numRows = 0;
            this.numCols = 0;
            this.cells = new Cell[0][0];
        }
        SheetReader sheetReader = new SheetReader(this.excelFile, this.sharedStrings, this.formattingRecords, this.sheetBof, this.workbookBof, this.nineteenFour, this.workbook, this.startPosition, this);
        sheetReader.read();
        this.numRows = sheetReader.getNumRows();
        this.numCols = sheetReader.getNumCols();
        this.cells = sheetReader.getCells();
        this.rowProperties = sheetReader.getRowProperties();
        this.columnInfosArray = sheetReader.getColumnInfosArray();
        this.hyperlinks = sheetReader.getHyperlinks();
        this.conditionalFormats = sheetReader.getConditionalFormats();
        this.autoFilter = sheetReader.getAutoFilter();
        this.charts = sheetReader.getCharts();
        this.drawings = sheetReader.getDrawings();
        this.dataValidation = sheetReader.getDataValidation();
        this.mergedCells = sheetReader.getMergedCells();
        this.settings = sheetReader.getSettings();
        this.settings.setHidden(this.hidden);
        this.rowBreaks = sheetReader.getRowBreaks();
        this.columnBreaks = sheetReader.getColumnBreaks();
        this.workspaceOptions = sheetReader.getWorkspaceOptions();
        this.plsRecord = sheetReader.getPLS();
        this.buttonPropertySet = sheetReader.getButtonPropertySet();
        sheetReader = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
        if (this.columnInfosArray.size() > 0) {
            ColumnInfoRecord columnInfoRecord = (ColumnInfoRecord)this.columnInfosArray.get(this.columnInfosArray.size() - 1);
            this.columnInfos = new ColumnInfoRecord[columnInfoRecord.getEndColumn() + 1];
        } else {
            this.columnInfos = new ColumnInfoRecord[0];
        }
        if (this.localNames != null) {
            for (NameRecord nameRecord : this.localNames) {
                if (nameRecord.getBuiltInName() != BuiltInName.PRINT_AREA) continue;
                NameRecord.NameRange nameRange = nameRecord.getRanges()[0];
                this.settings.setPrintArea(nameRange.getFirstColumn(), nameRange.getFirstRow(), nameRange.getLastColumn(), nameRange.getLastRow());
            }
        }
    }

    public Hyperlink[] getHyperlinks() {
        Hyperlink[] hyperlinkArray = new Hyperlink[this.hyperlinks.size()];
        for (int i = 0; i < this.hyperlinks.size(); ++i) {
            hyperlinkArray[i] = (Hyperlink)this.hyperlinks.get(i);
        }
        return hyperlinkArray;
    }

    public Range[] getMergedCells() {
        if (this.mergedCells == null) {
            return new Range[0];
        }
        return this.mergedCells;
    }

    public RowRecord[] getRowProperties() {
        RowRecord[] rowRecordArray = new RowRecord[this.rowProperties.size()];
        for (int i = 0; i < rowRecordArray.length; ++i) {
            rowRecordArray[i] = (RowRecord)this.rowProperties.get(i);
        }
        return rowRecordArray;
    }

    public DataValidation getDataValidation() {
        return this.dataValidation;
    }

    RowRecord getRowInfo(int n) {
        if (!this.rowRecordsInitialized) {
            this.rowRecords = new RowRecord[this.getRows()];
            Iterator iterator = this.rowProperties.iterator();
            int n2 = 0;
            RowRecord rowRecord = null;
            while (iterator.hasNext()) {
                rowRecord = (RowRecord)iterator.next();
                n2 = rowRecord.getRowNumber();
                if (n2 >= this.rowRecords.length) continue;
                this.rowRecords[n2] = rowRecord;
            }
            this.rowRecordsInitialized = true;
        }
        return n < this.rowRecords.length ? this.rowRecords[n] : null;
    }

    public final int[] getRowPageBreaks() {
        return this.rowBreaks;
    }

    public final int[] getColumnPageBreaks() {
        return this.columnBreaks;
    }

    public final Chart[] getCharts() {
        Chart[] chartArray = new Chart[this.charts.size()];
        for (int i = 0; i < chartArray.length; ++i) {
            chartArray[i] = (Chart)this.charts.get(i);
        }
        return chartArray;
    }

    public final DrawingGroupObject[] getDrawings() {
        DrawingGroupObject[] drawingGroupObjectArray = new DrawingGroupObject[this.drawings.size()];
        drawingGroupObjectArray = this.drawings.toArray(drawingGroupObjectArray);
        return drawingGroupObjectArray;
    }

    public boolean isProtected() {
        return this.settings.isProtected();
    }

    public WorkspaceInformationRecord getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    public SheetSettings getSettings() {
        return this.settings;
    }

    public WorkbookParser getWorkbook() {
        return this.workbook;
    }

    public CellFormat getColumnFormat(int n) {
        CellView cellView = this.getColumnView(n);
        return cellView.getFormat();
    }

    public int getColumnWidth(int n) {
        return this.getColumnView(n).getSize() / 256;
    }

    public CellView getColumnView(int n) {
        ColumnInfoRecord columnInfoRecord = this.getColumnInfo(n);
        CellView cellView = new CellView();
        if (columnInfoRecord != null) {
            cellView.setDimension(columnInfoRecord.getWidth() / 256);
            cellView.setSize(columnInfoRecord.getWidth());
            cellView.setHidden(columnInfoRecord.getHidden());
            cellView.setFormat(this.formattingRecords.getXFRecord(columnInfoRecord.getXFIndex()));
        } else {
            cellView.setDimension(this.settings.getDefaultColumnWidth());
            cellView.setSize(this.settings.getDefaultColumnWidth() * 256);
        }
        return cellView;
    }

    public int getRowHeight(int n) {
        return this.getRowView(n).getDimension();
    }

    public CellView getRowView(int n) {
        RowRecord rowRecord = this.getRowInfo(n);
        CellView cellView = new CellView();
        if (rowRecord != null) {
            cellView.setDimension(rowRecord.getRowHeight());
            cellView.setSize(rowRecord.getRowHeight());
            cellView.setHidden(rowRecord.isCollapsed());
            if (rowRecord.hasDefaultFormat()) {
                cellView.setFormat(this.formattingRecords.getXFRecord(rowRecord.getXFIndex()));
            }
        } else {
            cellView.setDimension(this.settings.getDefaultRowHeight());
            cellView.setSize(this.settings.getDefaultRowHeight());
        }
        return cellView;
    }

    public BOFRecord getSheetBof() {
        return this.sheetBof;
    }

    public BOFRecord getWorkbookBof() {
        return this.workbookBof;
    }

    public PLSRecord getPLS() {
        return this.plsRecord;
    }

    public ButtonPropertySetRecord getButtonPropertySet() {
        return this.buttonPropertySet;
    }

    public int getNumberOfImages() {
        if (this.images == null) {
            this.initializeImages();
        }
        return this.images.size();
    }

    public Image getDrawing(int n) {
        if (this.images == null) {
            this.initializeImages();
        }
        return (Image)this.images.get(n);
    }

    private void initializeImages() {
        if (this.images != null) {
            return;
        }
        this.images = new ArrayList();
        DrawingGroupObject[] drawingGroupObjectArray = this.getDrawings();
        for (int i = 0; i < drawingGroupObjectArray.length; ++i) {
            if (!(drawingGroupObjectArray[i] instanceof Drawing)) continue;
            this.images.add(drawingGroupObjectArray[i]);
        }
    }

    public DrawingData getDrawingData() {
        SheetReader sheetReader = new SheetReader(this.excelFile, this.sharedStrings, this.formattingRecords, this.sheetBof, this.workbookBof, this.nineteenFour, this.workbook, this.startPosition, this);
        sheetReader.read();
        return sheetReader.getDrawingData();
    }

    void addLocalName(NameRecord nameRecord) {
        if (this.localNames == null) {
            this.localNames = new ArrayList();
        }
        this.localNames.add(nameRecord);
    }

    public ConditionalFormat[] getConditionalFormats() {
        ConditionalFormat[] conditionalFormatArray = new ConditionalFormat[this.conditionalFormats.size()];
        conditionalFormatArray = this.conditionalFormats.toArray(conditionalFormatArray);
        return conditionalFormatArray;
    }

    public AutoFilter getAutoFilter() {
        return this.autoFilter;
    }
}

