/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.biff.RecordData;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.read.biff.Record;

public class SortRecord
extends RecordData {
    private int col1Size;
    private int col2Size;
    private int col3Size;
    private String col1Name;
    private String col2Name;
    private String col3Name;
    private byte optionFlags;
    private boolean sortColumns = false;
    private boolean sortKey1Desc = false;
    private boolean sortKey2Desc = false;
    private boolean sortKey3Desc = false;
    private boolean sortCaseSensitive = false;

    public SortRecord(Record record) {
        super(Type.SORT);
        byte[] byArray = record.getData();
        this.optionFlags = byArray[0];
        this.sortColumns = (this.optionFlags & 1) != 0;
        this.sortKey1Desc = (this.optionFlags & 2) != 0;
        this.sortKey2Desc = (this.optionFlags & 4) != 0;
        this.sortKey3Desc = (this.optionFlags & 8) != 0;
        this.sortCaseSensitive = (this.optionFlags & 0x10) != 0;
        this.col1Size = byArray[2];
        this.col2Size = byArray[3];
        this.col3Size = byArray[4];
        int n = 5;
        if (byArray[n++] == 0) {
            this.col1Name = new String(byArray, n, this.col1Size);
            n += this.col1Size;
        } else {
            this.col1Name = StringHelper.getUnicodeString(byArray, this.col1Size, n);
            n += this.col1Size * 2;
        }
        if (this.col2Size > 0) {
            if (byArray[n++] == 0) {
                this.col2Name = new String(byArray, n, this.col2Size);
                n += this.col2Size;
            } else {
                this.col2Name = StringHelper.getUnicodeString(byArray, this.col2Size, n);
                n += this.col2Size * 2;
            }
        } else {
            this.col2Name = "";
        }
        if (this.col3Size > 0) {
            if (byArray[n++] == 0) {
                this.col3Name = new String(byArray, n, this.col3Size);
                n += this.col3Size;
            } else {
                this.col3Name = StringHelper.getUnicodeString(byArray, this.col3Size, n);
                n += this.col3Size * 2;
            }
        } else {
            this.col3Name = "";
        }
    }

    public String getSortCol1Name() {
        return this.col1Name;
    }

    public String getSortCol2Name() {
        return this.col2Name;
    }

    public String getSortCol3Name() {
        return this.col3Name;
    }

    public boolean getSortColumns() {
        return this.sortColumns;
    }

    public boolean getSortKey1Desc() {
        return this.sortKey1Desc;
    }

    public boolean getSortKey2Desc() {
        return this.sortKey2Desc;
    }

    public boolean getSortKey3Desc() {
        return this.sortKey3Desc;
    }

    public boolean getSortCaseSensitive() {
        return this.sortCaseSensitive;
    }
}

