/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.BuiltInName;
import jxl.biff.CellReferenceHelper;
import jxl.biff.DisplayFormat;
import jxl.biff.EmptyCell;
import jxl.biff.FontRecord;
import jxl.biff.Fonts;
import jxl.biff.FormatRecord;
import jxl.biff.FormattingRecords;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.PaletteRecord;
import jxl.biff.RangeImpl;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WorkbookMethods;
import jxl.biff.XFRecord;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.MsoDrawingGroupRecord;
import jxl.biff.drawing.Origin;
import jxl.biff.formula.ExternalSheet;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BiffException;
import jxl.read.biff.BoundsheetRecord;
import jxl.read.biff.ButtonPropertySetRecord;
import jxl.read.biff.CodepageRecord;
import jxl.read.biff.CompoundFile;
import jxl.read.biff.CountryRecord;
import jxl.read.biff.ExternalNameRecord;
import jxl.read.biff.ExternalSheetRecord;
import jxl.read.biff.File;
import jxl.read.biff.NameRecord;
import jxl.read.biff.NineteenFourRecord;
import jxl.read.biff.PasswordException;
import jxl.read.biff.ProtectRecord;
import jxl.read.biff.Record;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.SupbookRecord;

public class WorkbookParser
extends Workbook
implements ExternalSheet,
WorkbookMethods {
    private static Logger logger = Logger.getLogger(WorkbookParser.class);
    private File excelFile;
    private int bofs;
    private boolean nineteenFour;
    private SSTRecord sharedStrings;
    private ArrayList boundsheets;
    private FormattingRecords formattingRecords;
    private Fonts fonts;
    private ArrayList sheets;
    private SheetImpl lastSheet;
    private int lastSheetIndex;
    private HashMap namedRecords;
    private ArrayList nameTable;
    private ArrayList addInFunctions;
    private ExternalSheetRecord externSheet;
    private ArrayList supbooks;
    private BOFRecord workbookBof;
    private MsoDrawingGroupRecord msoDrawingGroup;
    private ButtonPropertySetRecord buttonPropertySet;
    private boolean wbProtected;
    private boolean containsMacros;
    private WorkbookSettings settings;
    private DrawingGroup drawingGroup;
    private CountryRecord countryRecord;

    public WorkbookParser(File file, WorkbookSettings workbookSettings) {
        this.excelFile = file;
        this.boundsheets = new ArrayList(10);
        this.fonts = new Fonts();
        this.formattingRecords = new FormattingRecords(this.fonts);
        this.sheets = new ArrayList(10);
        this.supbooks = new ArrayList(10);
        this.namedRecords = new HashMap();
        this.lastSheetIndex = -1;
        this.wbProtected = false;
        this.containsMacros = false;
        this.settings = workbookSettings;
    }

    public Sheet[] getSheets() {
        Sheet[] sheetArray = new Sheet[this.getNumberOfSheets()];
        return this.sheets.toArray(sheetArray);
    }

    public Sheet getReadSheet(int n) {
        return this.getSheet(n);
    }

    public Sheet getSheet(int n) {
        if (this.lastSheet != null && this.lastSheetIndex == n) {
            return this.lastSheet;
        }
        if (this.lastSheet != null) {
            this.lastSheet.clear();
            if (!this.settings.getGCDisabled()) {
                System.gc();
            }
        }
        this.lastSheet = (SheetImpl)this.sheets.get(n);
        this.lastSheetIndex = n;
        this.lastSheet.readSheet();
        return this.lastSheet;
    }

    public Sheet getSheet(String string) {
        int n = 0;
        boolean bl = false;
        Iterator iterator = this.boundsheets.iterator();
        BoundsheetRecord boundsheetRecord = null;
        while (iterator.hasNext() && !bl) {
            boundsheetRecord = (BoundsheetRecord)iterator.next();
            if (boundsheetRecord.getName().equals(string)) {
                bl = true;
                continue;
            }
            ++n;
        }
        return bl ? this.getSheet(n) : null;
    }

    public String[] getSheetNames() {
        String[] stringArray = new String[this.boundsheets.size()];
        BoundsheetRecord boundsheetRecord = null;
        for (int i = 0; i < stringArray.length; ++i) {
            boundsheetRecord = (BoundsheetRecord)this.boundsheets.get(i);
            stringArray[i] = boundsheetRecord.getName();
        }
        return stringArray;
    }

    public int getExternalSheetIndex(int n) {
        if (this.workbookBof.isBiff7()) {
            return n;
        }
        Assert.verify(this.externSheet != null);
        int n2 = this.externSheet.getFirstTabIndex(n);
        return n2;
    }

    public int getLastExternalSheetIndex(int n) {
        if (this.workbookBof.isBiff7()) {
            return n;
        }
        Assert.verify(this.externSheet != null);
        int n2 = this.externSheet.getLastTabIndex(n);
        return n2;
    }

    public String getExternalSheetName(int n) {
        if (this.workbookBof.isBiff7()) {
            BoundsheetRecord boundsheetRecord = (BoundsheetRecord)this.boundsheets.get(n);
            return boundsheetRecord.getName();
        }
        int n2 = this.externSheet.getSupbookIndex(n);
        SupbookRecord supbookRecord = (SupbookRecord)this.supbooks.get(n2);
        int n3 = this.externSheet.getFirstTabIndex(n);
        int n4 = this.externSheet.getLastTabIndex(n);
        String string = "";
        String string2 = "";
        if (supbookRecord.getType() == SupbookRecord.INTERNAL) {
            Object object;
            if (n3 == 65535) {
                string = "#REF";
            } else {
                object = (BoundsheetRecord)this.boundsheets.get(n3);
                string = ((BoundsheetRecord)object).getName();
            }
            if (n4 == 65535) {
                string2 = "#REF";
            } else {
                object = (BoundsheetRecord)this.boundsheets.get(n4);
                string2 = ((BoundsheetRecord)object).getName();
            }
            object = n3 == n4 ? string : string + ':' + string2;
            object = ((String)object).indexOf(39) == -1 ? object : StringHelper.replace((String)object, "'", "''");
            return ((String)object).indexOf(32) == -1 ? object : '\'' + (String)object + '\'';
        }
        if (supbookRecord.getType() == SupbookRecord.EXTERNAL) {
            StringBuffer stringBuffer = new StringBuffer();
            java.io.File file = new java.io.File(supbookRecord.getFileName());
            stringBuffer.append("'");
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append("[");
            stringBuffer.append(file.getName());
            stringBuffer.append("]");
            stringBuffer.append(n3 == 65535 ? "#REF" : supbookRecord.getSheetName(n3));
            if (n4 != n3) {
                stringBuffer.append(supbookRecord.getSheetName(n4));
            }
            stringBuffer.append("'");
            return stringBuffer.toString();
        }
        return "[UNKNOWN]";
    }

    public String getLastExternalSheetName(int n) {
        if (this.workbookBof.isBiff7()) {
            BoundsheetRecord boundsheetRecord = (BoundsheetRecord)this.boundsheets.get(n);
            return boundsheetRecord.getName();
        }
        int n2 = this.externSheet.getSupbookIndex(n);
        SupbookRecord supbookRecord = (SupbookRecord)this.supbooks.get(n2);
        int n3 = this.externSheet.getLastTabIndex(n);
        if (supbookRecord.getType() == SupbookRecord.INTERNAL) {
            if (n3 == 65535) {
                return "#REF";
            }
            BoundsheetRecord boundsheetRecord = (BoundsheetRecord)this.boundsheets.get(n3);
            return boundsheetRecord.getName();
        }
        if (supbookRecord.getType() == SupbookRecord.EXTERNAL) {
            StringBuffer stringBuffer = new StringBuffer();
            java.io.File file = new java.io.File(supbookRecord.getFileName());
            stringBuffer.append("'");
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append("[");
            stringBuffer.append(file.getName());
            stringBuffer.append("]");
            stringBuffer.append(n3 == 65535 ? "#REF" : supbookRecord.getSheetName(n3));
            stringBuffer.append("'");
            return stringBuffer.toString();
        }
        return "[UNKNOWN]";
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public void close() {
        if (this.lastSheet != null) {
            this.lastSheet.clear();
        }
        this.excelFile.clear();
        if (!this.settings.getGCDisabled()) {
            System.gc();
        }
    }

    final void addSheet(Sheet sheet) {
        this.sheets.add(sheet);
    }

    protected void parse() throws BiffException, PasswordException {
        Object object3;
        Object object2;
        BOFRecord bOFRecord;
        Record record = null;
        this.workbookBof = bOFRecord = new BOFRecord(this.excelFile.next());
        ++this.bofs;
        if (!bOFRecord.isBiff8() && !bOFRecord.isBiff7()) {
            throw new BiffException(BiffException.unrecognizedBiffVersion);
        }
        if (!bOFRecord.isWorkbookGlobals()) {
            throw new BiffException(BiffException.expectedGlobals);
        }
        ArrayList<Record> arrayList = new ArrayList<Record>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        this.nameTable = new ArrayList();
        this.addInFunctions = new ArrayList();
        while (this.bofs == 1) {
            record = this.excelFile.next();
            if (record.getType() == Type.SST) {
                arrayList.clear();
                object2 = this.excelFile.peek();
                while (((Record)object2).getType() == Type.CONTINUE) {
                    arrayList.add(this.excelFile.next());
                    object2 = this.excelFile.peek();
                }
                object3 = new Record[arrayList.size()];
                object3 = arrayList.toArray((T[])object3);
                this.sharedStrings = new SSTRecord(record, (Record[])object3, this.settings);
                continue;
            }
            if (record.getType() == Type.FILEPASS) {
                throw new PasswordException();
            }
            if (record.getType() == Type.NAME) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new NameRecord(record, this.settings, this.namedRecords.size()) : new NameRecord(record, this.settings, this.namedRecords.size(), NameRecord.biff7);
                if (((NameRecord)object2).isGlobal()) {
                    this.namedRecords.put(((NameRecord)object2).getName(), object2);
                    this.nameTable.add(object2);
                    continue;
                }
                arrayList2.add(object2);
                continue;
            }
            if (record.getType() == Type.FONT) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new FontRecord(record, this.settings) : new FontRecord(record, this.settings, FontRecord.biff7);
                this.fonts.addFont((FontRecord)object2);
                continue;
            }
            if (record.getType() == Type.PALETTE) {
                object2 = new PaletteRecord(record);
                this.formattingRecords.setPalette((PaletteRecord)object2);
                continue;
            }
            if (record.getType() == Type.NINETEENFOUR) {
                object2 = new NineteenFourRecord(record);
                this.nineteenFour = ((NineteenFourRecord)object2).is1904();
                continue;
            }
            if (record.getType() == Type.FORMAT) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new FormatRecord(record, this.settings, FormatRecord.biff8) : new FormatRecord(record, this.settings, FormatRecord.biff7);
                try {
                    this.formattingRecords.addFormat((DisplayFormat)object2);
                }
                catch (NumFormatRecordsException numFormatRecordsException) {
                    numFormatRecordsException.printStackTrace();
                    Assert.verify(false, numFormatRecordsException.getMessage());
                }
                continue;
            }
            if (record.getType() == Type.XF) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new XFRecord(record, this.settings, XFRecord.biff8) : new XFRecord(record, this.settings, XFRecord.biff7);
                try {
                    this.formattingRecords.addStyle((XFRecord)object2);
                }
                catch (NumFormatRecordsException numFormatRecordsException) {
                    Assert.verify(false, numFormatRecordsException.getMessage());
                }
                continue;
            }
            if (record.getType() == Type.BOUNDSHEET) {
                object2 = null;
                object2 = bOFRecord.isBiff8() ? new BoundsheetRecord(record) : new BoundsheetRecord(record, BoundsheetRecord.biff7);
                if (((BoundsheetRecord)object2).isSheet()) {
                    this.boundsheets.add(object2);
                    continue;
                }
                if (!((BoundsheetRecord)object2).isChart() || this.settings.getDrawingsDisabled()) continue;
                this.boundsheets.add(object2);
                continue;
            }
            if (record.getType() == Type.EXTERNSHEET) {
                if (bOFRecord.isBiff8()) {
                    this.externSheet = new ExternalSheetRecord(record, this.settings);
                    continue;
                }
                this.externSheet = new ExternalSheetRecord(record, this.settings, ExternalSheetRecord.biff7);
                continue;
            }
            if (record.getType() == Type.CODEPAGE) {
                object2 = new CodepageRecord(record);
                this.settings.setCharacterSet(((CodepageRecord)object2).getCharacterSet());
                continue;
            }
            if (record.getType() == Type.SUPBOOK) {
                object2 = this.excelFile.peek();
                while (((Record)object2).getType() == Type.CONTINUE) {
                    record.addContinueRecord(this.excelFile.next());
                    object2 = this.excelFile.peek();
                }
                object3 = new SupbookRecord(record, this.settings);
                this.supbooks.add(object3);
                continue;
            }
            if (record.getType() == Type.EXTERNNAME) {
                object2 = new ExternalNameRecord(record, this.settings);
                if (!((ExternalNameRecord)object2).isAddInFunction()) continue;
                this.addInFunctions.add(((ExternalNameRecord)object2).getName());
                continue;
            }
            if (record.getType() == Type.PROTECT) {
                object2 = new ProtectRecord(record);
                this.wbProtected = ((ProtectRecord)object2).isProtected();
                continue;
            }
            if (record.getType() == Type.OBJPROJ) {
                this.containsMacros = true;
                continue;
            }
            if (record.getType() == Type.COUNTRY) {
                this.countryRecord = new CountryRecord(record);
                continue;
            }
            if (record.getType() == Type.MSODRAWINGGROUP) {
                if (this.settings.getDrawingsDisabled()) continue;
                this.msoDrawingGroup = new MsoDrawingGroupRecord(record);
                if (this.drawingGroup == null) {
                    this.drawingGroup = new DrawingGroup(Origin.READ);
                }
                this.drawingGroup.add(this.msoDrawingGroup);
                object2 = this.excelFile.peek();
                while (((Record)object2).getType() == Type.CONTINUE) {
                    this.drawingGroup.add(this.excelFile.next());
                    object2 = this.excelFile.peek();
                }
                continue;
            }
            if (record.getType() == Type.BUTTONPROPERTYSET) {
                this.buttonPropertySet = new ButtonPropertySetRecord(record);
                continue;
            }
            if (record.getType() != Type.EOF) continue;
            --this.bofs;
        }
        bOFRecord = null;
        if (this.excelFile.hasNext() && (record = this.excelFile.next()).getType() == Type.BOF) {
            bOFRecord = new BOFRecord(record);
        }
        while (bOFRecord != null && this.getNumberOfSheets() < this.boundsheets.size()) {
            if (!bOFRecord.isBiff8() && !bOFRecord.isBiff7()) {
                throw new BiffException(BiffException.unrecognizedBiffVersion);
            }
            if (bOFRecord.isWorksheet()) {
                object2 = new SheetImpl(this.excelFile, this.sharedStrings, this.formattingRecords, bOFRecord, this.workbookBof, this.nineteenFour, this);
                object3 = (BoundsheetRecord)this.boundsheets.get(this.getNumberOfSheets());
                ((SheetImpl)object2).setName(((BoundsheetRecord)object3).getName());
                ((SheetImpl)object2).setHidden(((BoundsheetRecord)object3).isHidden());
                this.addSheet((Sheet)object2);
            } else if (bOFRecord.isChart()) {
                object2 = new SheetImpl(this.excelFile, this.sharedStrings, this.formattingRecords, bOFRecord, this.workbookBof, this.nineteenFour, this);
                object3 = (BoundsheetRecord)this.boundsheets.get(this.getNumberOfSheets());
                ((SheetImpl)object2).setName(((BoundsheetRecord)object3).getName());
                ((SheetImpl)object2).setHidden(((BoundsheetRecord)object3).isHidden());
                this.addSheet((Sheet)object2);
            } else {
                logger.warn("BOF is unrecognized");
                while (this.excelFile.hasNext() && record.getType() != Type.EOF) {
                    record = this.excelFile.next();
                }
            }
            bOFRecord = null;
            if (!this.excelFile.hasNext() || (record = this.excelFile.next()).getType() != Type.BOF) continue;
            bOFRecord = new BOFRecord(record);
        }
        for (Object object3 : arrayList2) {
            if (((NameRecord)object3).getBuiltInName() == null) {
                logger.warn("Usage of a local non-builtin name");
                continue;
            }
            if (((NameRecord)object3).getBuiltInName() != BuiltInName.PRINT_AREA) continue;
            SheetImpl sheetImpl = (SheetImpl)this.sheets.get(((NameRecord)object3).getSheetRef() - 1);
            sheetImpl.addLocalName((NameRecord)object3);
        }
    }

    public FormattingRecords getFormattingRecords() {
        return this.formattingRecords;
    }

    public ExternalSheetRecord getExternalSheetRecord() {
        return this.externSheet;
    }

    public MsoDrawingGroupRecord getMsoDrawingGroupRecord() {
        return this.msoDrawingGroup;
    }

    public SupbookRecord[] getSupbookRecords() {
        SupbookRecord[] supbookRecordArray = new SupbookRecord[this.supbooks.size()];
        return this.supbooks.toArray(supbookRecordArray);
    }

    public NameRecord[] getNameRecords() {
        NameRecord[] nameRecordArray = new NameRecord[this.nameTable.size()];
        return this.nameTable.toArray(nameRecordArray);
    }

    public Fonts getFonts() {
        return this.fonts;
    }

    public Cell getCell(String string) {
        Sheet sheet = this.getSheet(CellReferenceHelper.getSheet(string));
        return sheet.getCell(string);
    }

    public Cell findCellByName(String string) {
        NameRecord nameRecord = (NameRecord)this.namedRecords.get(string);
        if (nameRecord == null) {
            return null;
        }
        NameRecord.NameRange[] nameRangeArray = nameRecord.getRanges();
        Sheet sheet = this.getSheet(this.getExternalSheetIndex(nameRangeArray[0].getExternalSheet()));
        int n = nameRangeArray[0].getFirstColumn();
        int n2 = nameRangeArray[0].getFirstRow();
        if (n > sheet.getColumns() || n2 > sheet.getRows()) {
            return new EmptyCell(n, n2);
        }
        Cell cell = sheet.getCell(n, n2);
        return cell;
    }

    public Range[] findByName(String string) {
        NameRecord nameRecord = (NameRecord)this.namedRecords.get(string);
        if (nameRecord == null) {
            return null;
        }
        NameRecord.NameRange[] nameRangeArray = nameRecord.getRanges();
        Range[] rangeArray = new Range[nameRangeArray.length];
        for (int i = 0; i < nameRangeArray.length; ++i) {
            rangeArray[i] = new RangeImpl(this, this.getExternalSheetIndex(nameRangeArray[i].getExternalSheet()), nameRangeArray[i].getFirstColumn(), nameRangeArray[i].getFirstRow(), this.getLastExternalSheetIndex(nameRangeArray[i].getExternalSheet()), nameRangeArray[i].getLastColumn(), nameRangeArray[i].getLastRow());
        }
        return rangeArray;
    }

    public String[] getRangeNames() {
        Object[] objectArray = this.namedRecords.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    public BOFRecord getWorkbookBof() {
        return this.workbookBof;
    }

    public boolean isProtected() {
        return this.wbProtected;
    }

    public WorkbookSettings getSettings() {
        return this.settings;
    }

    public int getExternalSheetIndex(String string) {
        return 0;
    }

    public int getLastExternalSheetIndex(String string) {
        return 0;
    }

    public String getName(int n) {
        Assert.verify(n >= 0 && n < this.nameTable.size());
        return ((NameRecord)this.nameTable.get(n)).getName();
    }

    public int getNameIndex(String string) {
        NameRecord nameRecord = (NameRecord)this.namedRecords.get(string);
        return nameRecord != null ? nameRecord.getIndex() : 0;
    }

    public DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    public CompoundFile getCompoundFile() {
        return this.excelFile.getCompoundFile();
    }

    public boolean containsMacros() {
        return this.containsMacros;
    }

    public ButtonPropertySetRecord getButtonPropertySet() {
        return this.buttonPropertySet;
    }

    public CountryRecord getCountryRecord() {
        return this.countryRecord;
    }

    public String[] getAddInFunctionNames() {
        String[] stringArray = new String[]{};
        return this.addInFunctions.toArray(stringArray);
    }

    public int getIndex(Sheet sheet) {
        String string = sheet.getName();
        int n = -1;
        int n2 = 0;
        Iterator iterator = this.boundsheets.iterator();
        while (iterator.hasNext() && n == -1) {
            BoundsheetRecord boundsheetRecord = (BoundsheetRecord)iterator.next();
            if (boundsheetRecord.getName().equals(string)) {
                n = n2;
                continue;
            }
            ++n2;
        }
        return n;
    }
}

