/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.Sheet;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Comment;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.formula.FormulaException;
import jxl.format.CellFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableWorkbook;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.Styles;
import jxl.write.biff.WritableSheetImpl;

public abstract class CellValue
extends WritableRecordData
implements WritableCell {
    private static Logger logger = Logger.getLogger(CellValue.class);
    private int row;
    private int column;
    private XFRecord format;
    private FormattingRecords formattingRecords;
    private boolean referenced;
    private WritableSheetImpl sheet;
    private WritableCellFeatures features;
    private boolean copied;

    protected CellValue(Type type, int n, int n2) {
        this(type, n, n2, WritableWorkbook.NORMAL_STYLE);
        this.copied = false;
    }

    protected CellValue(Type type, Cell cell) {
        this(type, cell.getColumn(), cell.getRow());
        this.copied = true;
        this.format = (XFRecord)cell.getCellFormat();
        if (cell.getCellFeatures() != null) {
            this.features = new WritableCellFeatures(cell.getCellFeatures());
            this.features.setWritableCell(this);
        }
    }

    protected CellValue(Type type, int n, int n2, CellFormat cellFormat) {
        super(type);
        this.row = n2;
        this.column = n;
        this.format = (XFRecord)cellFormat;
        this.referenced = false;
        this.copied = false;
    }

    protected CellValue(Type type, int n, int n2, CellValue cellValue) {
        super(type);
        this.row = n2;
        this.column = n;
        this.format = cellValue.format;
        this.referenced = false;
        this.copied = false;
        if (cellValue.features != null) {
            this.features = new WritableCellFeatures(cellValue.features);
            this.features.setWritableCell(this);
        }
    }

    public void setCellFormat(CellFormat cellFormat) {
        this.format = (XFRecord)cellFormat;
        if (!this.referenced) {
            return;
        }
        Assert.verify(this.formattingRecords != null);
        this.addCellFormat();
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean isHidden() {
        ColumnInfoRecord columnInfoRecord = this.sheet.getColumnInfo(this.column);
        if (columnInfoRecord != null && columnInfoRecord.getWidth() == 0) {
            return true;
        }
        RowRecord rowRecord = this.sheet.getRowInfo(this.row);
        return rowRecord != null && (rowRecord.getRowHeight() == 0 || rowRecord.isCollapsed());
    }

    public byte[] getData() {
        byte[] byArray = new byte[6];
        IntegerHelper.getTwoBytes(this.row, byArray, 0);
        IntegerHelper.getTwoBytes(this.column, byArray, 2);
        IntegerHelper.getTwoBytes(this.format.getXFIndex(), byArray, 4);
        return byArray;
    }

    void setCellDetails(FormattingRecords formattingRecords, SharedStrings sharedStrings, WritableSheetImpl writableSheetImpl) {
        this.referenced = true;
        this.sheet = writableSheetImpl;
        this.formattingRecords = formattingRecords;
        this.addCellFormat();
        this.addCellFeatures();
    }

    final boolean isReferenced() {
        return this.referenced;
    }

    final int getXFIndex() {
        return this.format.getXFIndex();
    }

    public CellFormat getCellFormat() {
        return this.format;
    }

    void incrementRow() {
        Comment comment;
        ++this.row;
        if (this.features != null && (comment = this.features.getCommentDrawing()) != null) {
            comment.setX(this.column);
            comment.setY(this.row);
        }
    }

    void decrementRow() {
        --this.row;
        if (this.features != null) {
            Comment comment = this.features.getCommentDrawing();
            if (comment != null) {
                comment.setX(this.column);
                comment.setY(this.row);
            }
            if (this.features.hasDropDown()) {
                logger.warn("need to change value for drop down drawing");
            }
        }
    }

    void incrementColumn() {
        Comment comment;
        ++this.column;
        if (this.features != null && (comment = this.features.getCommentDrawing()) != null) {
            comment.setX(this.column);
            comment.setY(this.row);
        }
    }

    void decrementColumn() {
        Comment comment;
        --this.column;
        if (this.features != null && (comment = this.features.getCommentDrawing()) != null) {
            comment.setX(this.column);
            comment.setY(this.row);
        }
    }

    void columnInserted(Sheet sheet, int n, int n2) {
    }

    void columnRemoved(Sheet sheet, int n, int n2) {
    }

    void rowInserted(Sheet sheet, int n, int n2) {
    }

    void rowRemoved(Sheet sheet, int n, int n2) {
    }

    protected WritableSheetImpl getSheet() {
        return this.sheet;
    }

    private void addCellFormat() {
        Styles styles = this.sheet.getWorkbook().getStyles();
        this.format = styles.getFormat(this.format);
        try {
            if (!this.format.isInitialized()) {
                this.formattingRecords.addStyle(this.format);
            }
        }
        catch (NumFormatRecordsException numFormatRecordsException) {
            logger.warn("Maximum number of format records exceeded.  Using default format.");
            this.format = styles.getNormalStyle();
        }
    }

    public CellFeatures getCellFeatures() {
        return this.features;
    }

    public WritableCellFeatures getWritableCellFeatures() {
        return this.features;
    }

    public void setCellFeatures(WritableCellFeatures writableCellFeatures) {
        if (this.features != null) {
            logger.warn("current cell features not null - overwriting");
        }
        this.features = writableCellFeatures;
        writableCellFeatures.setWritableCell(this);
        if (this.referenced) {
            this.addCellFeatures();
        }
    }

    public final void addCellFeatures() {
        DrawingGroupObject drawingGroupObject;
        if (this.features == null) {
            return;
        }
        if (this.copied) {
            this.copied = false;
            return;
        }
        if (this.features.getComment() != null) {
            drawingGroupObject = new Comment(this.features.getComment(), this.column, this.row);
            drawingGroupObject.setWidth(this.features.getCommentWidth());
            drawingGroupObject.setHeight(this.features.getCommentHeight());
            this.sheet.addDrawing(drawingGroupObject);
            this.sheet.getWorkbook().addDrawing(drawingGroupObject);
            this.features.setCommentDrawing((Comment)drawingGroupObject);
        }
        if (this.features.hasDataValidation()) {
            try {
                this.features.getDVParser().setCell(this.column, this.row, this.sheet.getWorkbook(), this.sheet.getWorkbook(), this.sheet.getWorkbookSettings());
            }
            catch (FormulaException formulaException) {
                formulaException.printStackTrace();
                Assert.verify(false);
            }
            this.sheet.addValidationCell(this);
            if (!this.features.hasDropDown()) {
                return;
            }
            if (this.sheet.getComboBox() == null) {
                drawingGroupObject = new ComboBox();
                this.sheet.addDrawing(drawingGroupObject);
                this.sheet.getWorkbook().addDrawing(drawingGroupObject);
                this.sheet.setComboBox((ComboBox)drawingGroupObject);
            }
            this.features.setComboBox(this.sheet.getComboBox());
        }
    }

    public final void removeComment(Comment comment) {
        this.sheet.removeDrawing(comment);
    }

    final void setCopied(boolean bl) {
        this.copied = bl;
    }
}

