/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class ExternalSheetRecord
extends WritableRecordData {
    private byte[] data;
    private ArrayList xtis;

    public ExternalSheetRecord(jxl.read.biff.ExternalSheetRecord externalSheetRecord) {
        super(Type.EXTERNSHEET);
        this.xtis = new ArrayList(externalSheetRecord.getNumRecords());
        XTI xTI = null;
        for (int i = 0; i < externalSheetRecord.getNumRecords(); ++i) {
            xTI = new XTI(externalSheetRecord.getSupbookIndex(i), externalSheetRecord.getFirstTabIndex(i), externalSheetRecord.getLastTabIndex(i));
            this.xtis.add(xTI);
        }
    }

    public ExternalSheetRecord() {
        super(Type.EXTERNSHEET);
        this.xtis = new ArrayList();
    }

    int getIndex(int n, int n2) {
        Iterator iterator = this.xtis.iterator();
        XTI xTI = null;
        boolean bl = false;
        int n3 = 0;
        while (iterator.hasNext() && !bl) {
            xTI = (XTI)iterator.next();
            if (xTI.supbookIndex == n && xTI.firstTab == n2) {
                bl = true;
                continue;
            }
            ++n3;
        }
        if (!bl) {
            xTI = new XTI(n, n2, n2);
            this.xtis.add(xTI);
            n3 = this.xtis.size() - 1;
        }
        return n3;
    }

    public byte[] getData() {
        byte[] byArray = new byte[2 + this.xtis.size() * 6];
        int n = 0;
        IntegerHelper.getTwoBytes(this.xtis.size(), byArray, 0);
        n += 2;
        Iterator iterator = this.xtis.iterator();
        XTI xTI = null;
        while (iterator.hasNext()) {
            xTI = (XTI)iterator.next();
            IntegerHelper.getTwoBytes(xTI.supbookIndex, byArray, n);
            IntegerHelper.getTwoBytes(xTI.firstTab, byArray, n + 2);
            IntegerHelper.getTwoBytes(xTI.lastTab, byArray, n + 4);
            n += 6;
        }
        return byArray;
    }

    public int getSupbookIndex(int n) {
        return ((XTI)this.xtis.get((int)n)).supbookIndex;
    }

    public int getFirstTabIndex(int n) {
        return ((XTI)this.xtis.get((int)n)).firstTab;
    }

    public int getLastTabIndex(int n) {
        return ((XTI)this.xtis.get((int)n)).lastTab;
    }

    void sheetInserted(int n) {
        XTI xTI2 = null;
        for (XTI xTI2 : this.xtis) {
            xTI2.sheetInserted(n);
        }
    }

    void sheetRemoved(int n) {
        XTI xTI2 = null;
        for (XTI xTI2 : this.xtis) {
            xTI2.sheetRemoved(n);
        }
    }

    private static class XTI {
        int supbookIndex;
        int firstTab;
        int lastTab;

        XTI(int n, int n2, int n3) {
            this.supbookIndex = n;
            this.firstTab = n2;
            this.lastTab = n3;
        }

        void sheetInserted(int n) {
            if (this.firstTab >= n) {
                ++this.firstTab;
            }
            if (this.lastTab >= n) {
                ++this.lastTab;
            }
        }

        void sheetRemoved(int n) {
            if (this.firstTab == n) {
                this.firstTab = 0;
            }
            if (this.lastTab == n) {
                this.lastTab = 0;
            }
            if (this.firstTab > n) {
                --this.firstTab;
            }
            if (this.lastTab > n) {
                --this.lastTab;
            }
        }
    }
}

