/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import java.io.IOException;
import java.io.OutputStream;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.write.biff.CompoundFile;
import jxl.write.biff.JxlWriteException;

public final class File {
    private static Logger logger = Logger.getLogger(File.class);
    private byte[] data;
    private int pos;
    private OutputStream outputStream;
    private int initialFileSize;
    private int arrayGrowSize;
    private WorkbookSettings workbookSettings;
    jxl.read.biff.CompoundFile readCompoundFile;

    File(OutputStream outputStream, WorkbookSettings workbookSettings, jxl.read.biff.CompoundFile compoundFile) {
        this.initialFileSize = workbookSettings.getInitialFileSize();
        this.arrayGrowSize = workbookSettings.getArrayGrowSize();
        this.data = new byte[this.initialFileSize];
        this.pos = 0;
        this.outputStream = outputStream;
        this.workbookSettings = workbookSettings;
        this.readCompoundFile = compoundFile;
    }

    void close(boolean bl) throws IOException, JxlWriteException {
        CompoundFile compoundFile = new CompoundFile(this.data, this.pos, this.outputStream, this.readCompoundFile);
        compoundFile.write();
        this.outputStream.flush();
        if (bl) {
            this.outputStream.close();
        }
        this.data = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    public void write(ByteData byteData) throws IOException {
        byte[] byArray = byteData.getBytes();
        while (this.pos + byArray.length > this.data.length) {
            byte[] byArray2 = new byte[this.data.length + this.arrayGrowSize];
            System.arraycopy(this.data, 0, byArray2, 0, this.pos);
            this.data = byArray2;
        }
        System.arraycopy(byArray, 0, this.data, this.pos, byArray.length);
        this.pos += byArray.length;
    }

    int getPos() {
        return this.pos;
    }

    void setData(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.data, n, byArray.length);
    }

    public void setOutputFile(OutputStream outputStream) {
        if (this.data != null) {
            logger.warn("Rewriting a workbook with non-empty data");
        }
        this.outputStream = outputStream;
        this.data = new byte[this.initialFileSize];
        this.pos = 0;
    }
}

