/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.Range;
import jxl.WorkbookSettings;
import jxl.biff.SheetRangeImpl;
import jxl.write.Blank;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.File;
import jxl.write.biff.MergedCellsRecord;
import jxl.write.biff.WritableSheetImpl;

class MergedCells {
    private static Logger logger = Logger.getLogger(MergedCells.class);
    private ArrayList ranges = new ArrayList();
    private WritableSheet sheet;
    private static final int maxRangesPerSheet = 1020;

    public MergedCells(WritableSheet writableSheet) {
        this.sheet = writableSheet;
    }

    void add(Range range) {
        this.ranges.add(range);
    }

    void insertRow(int n) {
        SheetRangeImpl sheetRangeImpl2 = null;
        for (SheetRangeImpl sheetRangeImpl2 : this.ranges) {
            sheetRangeImpl2.insertRow(n);
        }
    }

    void insertColumn(int n) {
        SheetRangeImpl sheetRangeImpl2 = null;
        for (SheetRangeImpl sheetRangeImpl2 : this.ranges) {
            sheetRangeImpl2.insertColumn(n);
        }
    }

    void removeColumn(int n) {
        SheetRangeImpl sheetRangeImpl2 = null;
        for (SheetRangeImpl sheetRangeImpl2 : this.ranges) {
            if (sheetRangeImpl2.getTopLeft().getColumn() == n && sheetRangeImpl2.getBottomRight().getColumn() == n) {
                this.ranges.remove(this.ranges.indexOf(sheetRangeImpl2));
                continue;
            }
            sheetRangeImpl2.removeColumn(n);
        }
    }

    void removeRow(int n) {
        SheetRangeImpl sheetRangeImpl = null;
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            sheetRangeImpl = (SheetRangeImpl)iterator.next();
            if (sheetRangeImpl.getTopLeft().getRow() == n && sheetRangeImpl.getBottomRight().getRow() == n) {
                iterator.remove();
                continue;
            }
            sheetRangeImpl.removeRow(n);
        }
    }

    Range[] getMergedCells() {
        Range[] rangeArray = new Range[this.ranges.size()];
        for (int i = 0; i < rangeArray.length; ++i) {
            rangeArray[i] = (Range)this.ranges.get(i);
        }
        return rangeArray;
    }

    void unmergeCells(Range range) {
        int n = this.ranges.indexOf(range);
        if (n != -1) {
            this.ranges.remove(n);
        }
    }

    private void checkIntersections() {
        ArrayList<SheetRangeImpl> arrayList = new ArrayList<SheetRangeImpl>(this.ranges.size());
        for (SheetRangeImpl sheetRangeImpl : this.ranges) {
            Iterator iterator = arrayList.iterator();
            SheetRangeImpl sheetRangeImpl2 = null;
            boolean bl = false;
            while (iterator.hasNext() && !bl) {
                sheetRangeImpl2 = (SheetRangeImpl)iterator.next();
                if (!sheetRangeImpl2.intersects(sheetRangeImpl)) continue;
                logger.warn("Could not merge cells " + sheetRangeImpl + " as they clash with an existing set of merged cells.");
                bl = true;
            }
            if (bl) continue;
            arrayList.add(sheetRangeImpl);
        }
        this.ranges = arrayList;
    }

    private void checkRanges() {
        try {
            SheetRangeImpl sheetRangeImpl = null;
            for (int i = 0; i < this.ranges.size(); ++i) {
                sheetRangeImpl = (SheetRangeImpl)this.ranges.get(i);
                Cell cell = sheetRangeImpl.getTopLeft();
                Cell cell2 = sheetRangeImpl.getBottomRight();
                boolean bl = false;
                for (int j = cell.getColumn(); j <= cell2.getColumn(); ++j) {
                    for (int k = cell.getRow(); k <= cell2.getRow(); ++k) {
                        Cell cell3 = this.sheet.getCell(j, k);
                        if (cell3.getType() == CellType.EMPTY) continue;
                        if (!bl) {
                            bl = true;
                            continue;
                        }
                        logger.warn("Range " + sheetRangeImpl + " contains more than one data cell.  " + "Setting the other cells to blank.");
                        Blank blank = new Blank(j, k);
                        this.sheet.addCell(blank);
                    }
                }
            }
        }
        catch (WriteException writeException) {
            Assert.verify(false);
        }
    }

    void write(File file) throws IOException {
        if (this.ranges.size() == 0) {
            return;
        }
        WorkbookSettings workbookSettings = ((WritableSheetImpl)this.sheet).getWorkbookSettings();
        if (!workbookSettings.getMergedCellCheckingDisabled()) {
            this.checkIntersections();
            this.checkRanges();
        }
        if (this.ranges.size() < 1020) {
            MergedCellsRecord mergedCellsRecord = new MergedCellsRecord(this.ranges);
            file.write(mergedCellsRecord);
            return;
        }
        int n = this.ranges.size() / 1020 + 1;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = Math.min(1020, this.ranges.size() - n2);
            ArrayList arrayList = new ArrayList(n3);
            for (int j = 0; j < n3; ++j) {
                arrayList.add(this.ranges.get(n2 + j));
            }
            MergedCellsRecord mergedCellsRecord = new MergedCellsRecord(arrayList);
            file.write(mergedCellsRecord);
            n2 += n3;
        }
    }
}

