/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.util.List;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.write.Number;
import jxl.write.biff.CellValue;

class MulRKRecord
extends WritableRecordData {
    private int row;
    private int colFirst;
    private int colLast;
    private int[] rknumbers;
    private int[] xfIndices;

    public MulRKRecord(List list) {
        super(Type.MULRK);
        this.row = ((Number)list.get(0)).getRow();
        this.colFirst = ((Number)list.get(0)).getColumn();
        this.colLast = this.colFirst + list.size() - 1;
        this.rknumbers = new int[list.size()];
        this.xfIndices = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.rknumbers[i] = (int)((Number)list.get(i)).getValue();
            this.xfIndices[i] = ((CellValue)list.get(i)).getXFIndex();
        }
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.rknumbers.length * 6 + 6];
        IntegerHelper.getTwoBytes(this.row, byArray, 0);
        IntegerHelper.getTwoBytes(this.colFirst, byArray, 2);
        int n = 4;
        int n2 = 0;
        byte[] byArray2 = new byte[4];
        for (int i = 0; i < this.rknumbers.length; ++i) {
            IntegerHelper.getTwoBytes(this.xfIndices[i], byArray, n);
            n2 = this.rknumbers[i] << 2;
            IntegerHelper.getFourBytes(n2 |= 2, byArray, n + 2);
            n += 6;
        }
        IntegerHelper.getTwoBytes(this.colLast, byArray, n);
        return byArray;
    }
}

