/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.BuiltInName;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.NameRecord;

class NameRecord
extends WritableRecordData {
    private byte[] data;
    private String name;
    private BuiltInName builtInName;
    private int index;
    private int sheetRef = 0;
    private NameRange[] ranges;
    private static final int cellReference = 58;
    private static final int areaReference = 59;
    private static final int subExpression = 41;
    private static final int union = 16;

    public NameRecord(jxl.read.biff.NameRecord nameRecord, int n) {
        super(Type.NAME);
        this.data = nameRecord.getData();
        this.name = nameRecord.getName();
        this.sheetRef = nameRecord.getSheetRef();
        this.index = n;
        NameRecord.NameRange[] nameRangeArray = nameRecord.getRanges();
        this.ranges = new NameRange[nameRangeArray.length];
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i] = new NameRange(nameRangeArray[i]);
        }
    }

    NameRecord(String string, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(Type.NAME);
        this.name = string;
        this.index = n;
        this.sheetRef = bl ? 0 : this.index + 1;
        this.ranges = new NameRange[1];
        this.ranges[0] = new NameRange(n2, n3, n4, n5, n6);
    }

    NameRecord(BuiltInName builtInName, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(Type.NAME);
        this.builtInName = builtInName;
        this.index = n;
        this.sheetRef = bl ? 0 : this.index + 1;
        this.ranges = new NameRange[1];
        this.ranges[0] = new NameRange(n2, n3, n4, n5, n6);
    }

    public byte[] getData() {
        if (this.data != null) {
            return this.data;
        }
        int n = 26;
        this.data = new byte[n += this.builtInName != null ? 1 : this.name.length()];
        int n2 = 0;
        if (this.builtInName != null) {
            n2 |= 0x20;
        }
        IntegerHelper.getTwoBytes(n2, this.data, 0);
        this.data[2] = 0;
        this.data[3] = this.builtInName != null ? (byte)1 : (byte)this.name.length();
        IntegerHelper.getTwoBytes(11, this.data, 4);
        IntegerHelper.getTwoBytes(this.sheetRef, this.data, 6);
        IntegerHelper.getTwoBytes(this.sheetRef, this.data, 8);
        if (this.builtInName != null) {
            this.data[15] = (byte)this.builtInName.getValue();
        } else {
            StringHelper.getBytes(this.name, this.data, 15);
        }
        int n3 = this.builtInName != null ? 16 : this.name.length() + 15;
        this.data[n3] = 59;
        byte[] byArray = this.ranges[0].getData();
        System.arraycopy(byArray, 0, this.data, n3 + 1, byArray.length);
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSheetRef() {
        return this.sheetRef;
    }

    public void setSheetRef(int n) {
        this.sheetRef = n;
        IntegerHelper.getTwoBytes(this.sheetRef, this.data, 8);
    }

    public NameRange[] getRanges() {
        return this.ranges;
    }

    class NameRange {
        private int columnFirst;
        private int rowFirst;
        private int columnLast;
        private int rowLast;
        private int externalSheet;

        NameRange(NameRecord.NameRange nameRange) {
            this.columnFirst = nameRange.getFirstColumn();
            this.rowFirst = nameRange.getFirstRow();
            this.columnLast = nameRange.getLastColumn();
            this.rowLast = nameRange.getLastRow();
            this.externalSheet = nameRange.getExternalSheet();
        }

        NameRange(int n, int n2, int n3, int n4, int n5) {
            this.columnFirst = n4;
            this.rowFirst = n2;
            this.columnLast = n5;
            this.rowLast = n3;
            this.externalSheet = n;
        }

        int getFirstColumn() {
            return this.columnFirst;
        }

        int getFirstRow() {
            return this.rowFirst;
        }

        int getLastColumn() {
            return this.columnLast;
        }

        int getLastRow() {
            return this.rowLast;
        }

        int getExternalSheet() {
            return this.externalSheet;
        }

        byte[] getData() {
            byte[] byArray = new byte[10];
            IntegerHelper.getTwoBytes(this.externalSheet, byArray, 0);
            IntegerHelper.getTwoBytes(this.rowFirst, byArray, 2);
            IntegerHelper.getTwoBytes(this.rowLast, byArray, 4);
            IntegerHelper.getTwoBytes(this.columnFirst & 0xFF, byArray, 6);
            IntegerHelper.getTwoBytes(this.columnLast & 0xFF, byArray, 8);
            return byArray;
        }
    }
}

