/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class PasswordRecord
extends WritableRecordData {
    private String password;
    private byte[] data;

    public PasswordRecord(String string) {
        super(Type.PASSWORD);
        this.password = string;
        if (string == null) {
            this.data = new byte[2];
            IntegerHelper.getTwoBytes(0, this.data, 0);
        } else {
            byte[] byArray = string.getBytes();
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                int n2 = this.rotLeft15Bit(byArray[i], i + 1);
                n ^= n2;
            }
            n ^= byArray.length;
            this.data = new byte[2];
            IntegerHelper.getTwoBytes(n ^= 0xCE4B, this.data, 0);
        }
    }

    public PasswordRecord(int n) {
        super(Type.PASSWORD);
        this.data = new byte[2];
        IntegerHelper.getTwoBytes(n, this.data, 0);
    }

    public byte[] getData() {
        return this.data;
    }

    private int rotLeft15Bit(int n, int n2) {
        n &= Short.MAX_VALUE;
        while (n2 > 0) {
            n = (n & 0x4000) != 0 ? (n << 1 & Short.MAX_VALUE) + 1 : n << 1 & Short.MAX_VALUE;
            --n2;
        }
        return n;
    }
}

