/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import jxl.SheetSettings;
import jxl.biff.DoubleHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;

class SetupRecord
extends WritableRecordData {
    Logger logger = Logger.getLogger(SetupRecord.class);
    private byte[] data;
    private double headerMargin;
    private double footerMargin;
    private PageOrientation orientation;
    private int paperSize;
    private int scaleFactor;
    private int pageStart;
    private int fitWidth;
    private int fitHeight;
    private int horizontalPrintResolution;
    private int verticalPrintResolution;
    private int copies;

    public SetupRecord() {
        super(Type.SETUP);
        this.orientation = PageOrientation.PORTRAIT;
        this.headerMargin = 0.5;
        this.footerMargin = 0.5;
        this.paperSize = PaperSize.A4.getValue();
        this.horizontalPrintResolution = 300;
        this.verticalPrintResolution = 300;
        this.copies = 1;
    }

    public SetupRecord(SheetSettings sheetSettings) {
        super(Type.SETUP);
        this.orientation = sheetSettings.getOrientation();
        this.headerMargin = sheetSettings.getHeaderMargin();
        this.footerMargin = sheetSettings.getFooterMargin();
        this.paperSize = sheetSettings.getPaperSize().getValue();
        this.horizontalPrintResolution = sheetSettings.getHorizontalPrintResolution();
        this.verticalPrintResolution = sheetSettings.getVerticalPrintResolution();
        this.fitWidth = sheetSettings.getFitWidth();
        this.fitHeight = sheetSettings.getFitHeight();
        this.pageStart = sheetSettings.getPageStart();
        this.scaleFactor = sheetSettings.getScaleFactor();
        this.copies = sheetSettings.getCopies();
    }

    public SetupRecord(jxl.read.biff.SetupRecord setupRecord) {
        super(Type.SETUP);
        this.orientation = setupRecord.isPortrait() ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        this.paperSize = setupRecord.getPaperSize();
        this.headerMargin = setupRecord.getHeaderMargin();
        this.footerMargin = setupRecord.getFooterMargin();
        this.scaleFactor = setupRecord.getScaleFactor();
        this.pageStart = setupRecord.getPageStart();
        this.fitWidth = setupRecord.getFitWidth();
        this.fitHeight = setupRecord.getFitHeight();
        this.horizontalPrintResolution = setupRecord.getHorizontalPrintResolution();
        this.verticalPrintResolution = setupRecord.getVerticalPrintResolution();
        this.copies = setupRecord.getCopies();
    }

    public void setOrientation(PageOrientation pageOrientation) {
        this.orientation = pageOrientation;
    }

    public void setMargins(double d, double d2) {
        this.headerMargin = d;
        this.footerMargin = d2;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize.getValue();
    }

    public byte[] getData() {
        this.data = new byte[34];
        IntegerHelper.getTwoBytes(this.paperSize, this.data, 0);
        IntegerHelper.getTwoBytes(this.scaleFactor, this.data, 2);
        IntegerHelper.getTwoBytes(this.pageStart, this.data, 4);
        IntegerHelper.getTwoBytes(this.fitWidth, this.data, 6);
        IntegerHelper.getTwoBytes(this.fitHeight, this.data, 8);
        int n = 0;
        if (this.orientation == PageOrientation.PORTRAIT) {
            n |= 2;
        }
        if (this.pageStart != 0) {
            n |= 0x80;
        }
        IntegerHelper.getTwoBytes(n, this.data, 10);
        IntegerHelper.getTwoBytes(this.horizontalPrintResolution, this.data, 12);
        IntegerHelper.getTwoBytes(this.verticalPrintResolution, this.data, 14);
        DoubleHelper.getIEEEBytes(this.headerMargin, this.data, 16);
        DoubleHelper.getIEEEBytes(this.footerMargin, this.data, 24);
        IntegerHelper.getTwoBytes(this.copies, this.data, 32);
        return this.data;
    }
}

