/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfoBuilder;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.metrics.SdkMeter;

class SdkMeterBuilder
implements MeterBuilder {
    private final ComponentRegistry<SdkMeter> registry;
    private final InstrumentationScopeInfoBuilder scopeBuilder;

    SdkMeterBuilder(ComponentRegistry<SdkMeter> registry, String instrumentationScopeName) {
        this.registry = registry;
        this.scopeBuilder = InstrumentationScopeInfo.builder(instrumentationScopeName);
    }

    public MeterBuilder setSchemaUrl(String schemaUrl) {
        this.scopeBuilder.setSchemaUrl(schemaUrl);
        return this;
    }

    public MeterBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
        this.scopeBuilder.setVersion(instrumentationScopeVersion);
        return this;
    }

    public Meter build() {
        return this.registry.get(this.scopeBuilder.build());
    }
}

