/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.dnd.gtk.ListDragSourceEffect;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    long targetList;
    boolean moveData = false;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static Callback DragBegin = new Callback(DragSource.class, "DragBegin", 2);
    static Callback DragGetData = new Callback(DragSource.class, "DragGetData", 5);
    static Callback DragEnd = new Callback(DragSource.class, "DragEnd", 2);
    static Callback DragDataDelete = new Callback(DragSource.class, "DragDataDelete", 2);

    public DragSource(Control control, int n) {
        super(control, DragSource.checkStyle(n));
        this.control = control;
        if (DragGetData == null || DragEnd == null || DragDataDelete == null) {
            DND.error((int)2000);
        }
        if (control.getData("DragSource") != null) {
            DND.error((int)2000);
        }
        control.setData("DragSource", this);
        OS.g_signal_connect(control.handle, OS.drag_begin, DragBegin.getAddress(), 0L);
        OS.g_signal_connect(control.handle, OS.drag_data_get, DragGetData.getAddress(), 0L);
        OS.g_signal_connect(control.handle, OS.drag_end, DragEnd.getAddress(), 0L);
        OS.g_signal_connect(control.handle, OS.drag_data_delete, DragDataDelete.getAddress(), 0L);
        this.controlListener = event -> {
            if (event.type == 12 && !this.isDisposed()) {
                this.dispose();
            }
            if (event.type == 29 && !this.isDisposed()) {
                this.drag(event);
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        Object object = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (object instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)object;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        } else if (control instanceof List) {
            this.dragEffect = new ListDragSourceEffect((List)control);
        }
        this.addListener(12, event -> this.onDispose());
        this.getDisplay().runDNDCreationHooks(this);
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    static long DragBegin(long l, long l2) {
        DragSource dragSource = DragSource.FindDragSource(l);
        if (dragSource == null) {
            return 0L;
        }
        dragSource.dragBegin(l, l2);
        return 0L;
    }

    static long DragDataDelete(long l, long l2) {
        DragSource dragSource = DragSource.FindDragSource(l);
        if (dragSource == null) {
            return 0L;
        }
        dragSource.dragDataDelete(l, l2);
        return 0L;
    }

    static long DragEnd(long l, long l2) {
        DragSource dragSource = DragSource.FindDragSource(l);
        if (dragSource == null) {
            return 0L;
        }
        dragSource.dragEnd(l, l2);
        return 0L;
    }

    static long DragGetData(long l, long l2, long l3, long l4, long l5) {
        DragSource dragSource = DragSource.FindDragSource(l);
        if (dragSource == null) {
            return 0L;
        }
        dragSource.dragGetData(l, l2, l3, (int)l4, (int)l5);
        return 0L;
    }

    static DragSource FindDragSource(long l) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData("DragSource");
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error((int)4);
        }
        DNDListener dNDListener = new DNDListener((SWTEventListener)dragSourceListener);
        dNDListener.dndWidget = this;
        this.addListener(2008, (Listener)dNDListener);
        this.addListener(2001, (Listener)dNDListener);
        this.addListener(2000, (Listener)dNDListener);
    }

    @Override
    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = DragSource.class.getName();
        if (!string2.equals(string)) {
            DND.error((int)43);
        }
    }

    void drag(Event event) {
        this.moveData = false;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.x = event.x;
        dNDEvent.y = event.y;
        dNDEvent.time = event.time;
        dNDEvent.doit = true;
        this.notifyListeners(2008, (Event)dNDEvent);
        if (!dNDEvent.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        if (this.targetList == 0L) {
            return;
        }
        int n = this.opToOsOp(this.getStyle());
        Image image = dNDEvent.image;
        long l = GTK.gtk_drag_begin_with_coordinates((long)this.control.handle, (long)this.targetList, (int)n, (int)1, (long)0L, (int)-1, (int)-1);
        if (l != 0L && image != null) {
            GTK.gtk_drag_set_icon_surface((long)l, (long)image.surface);
        }
    }

    void dragBegin(long l, long l2) {
        if (this.control instanceof Text) {
            DNDEvent dNDEvent = new DNDEvent();
            Display display = Display.getCurrent();
            Point point = display.getCursorLocation();
            dNDEvent.widget = this;
            dNDEvent.doit = true;
            dNDEvent.x = point.x;
            dNDEvent.y = point.y;
            this.notifyListeners(2008, (Event)dNDEvent);
            if (!dNDEvent.doit || this.transferAgents == null || this.transferAgents.length == 0) {
                return;
            }
            if (this.targetList == 0L) {
                return;
            }
            Image image = dNDEvent.image;
            if (l2 != 0L && image != null) {
                GTK.gtk_drag_set_icon_surface((long)l2, (long)image.surface);
            }
        }
    }

    void dragEnd(long l, long l2) {
        long l3;
        long l4;
        long l5;
        if (GTK.GTK4) {
            l5 = GTK.gtk_native_get_surface((long)GTK.gtk_widget_get_native((long)l));
            l4 = GDK.gdk_surface_get_display((long)l5);
        } else {
            l4 = GDK.gdk_window_get_display((long)GTK.gtk_widget_get_window((long)l));
        }
        l5 = GDK.gdk_get_pointer((long)l4);
        if (!GTK.GTK4) {
            l3 = GDK.gdk_device_get_associated_device((long)l5);
            long l6 = GDK.gdk_device_get_seat((long)l3);
            GDK.gdk_seat_ungrab((long)l6);
        }
        l3 = GDK.gdk_device_get_seat((long)l5);
        GDK.gdk_seat_ungrab((long)l3);
        int n = 0;
        if (l2 != 0L) {
            long l7 = 0L;
            int n2 = 0;
            n2 = GDK.gdk_drag_context_get_selected_action((long)l2);
            if (OS.isX11()) {
                l7 = GDK.gdk_drag_context_get_dest_window((long)l2);
            }
            if (l7 != 0L || !OS.isX11()) {
                if (this.moveData) {
                    n = 2;
                } else {
                    n = this.osOpToOp(n2);
                    if (n == 2) {
                        n = 0;
                    }
                }
            }
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.doit = n != 0;
        dNDEvent.detail = n;
        this.notifyListeners(2000, (Event)dNDEvent);
        if (!OS.isX11()) {
            if (this.control instanceof Table || this.control instanceof Tree || this.control instanceof List) {
                long l8 = GTK.gtk_tree_view_get_selection((long)l);
                GTK.gtk_tree_selection_set_select_function((long)l8, (long)0L, (long)0L, (long)0L);
            }
            this.control.notifyListeners(4, (Event)dNDEvent);
        }
        this.moveData = false;
    }

    void dragGetData(long l, long l2, long l3, int n, int n2) {
        if (l3 == 0L) {
            return;
        }
        int n3 = GTK.gtk_selection_data_get_length((long)l3);
        int n4 = GTK.gtk_selection_data_get_format((long)l3);
        long l4 = GTK.gtk_selection_data_get_data((long)l3);
        long l5 = GTK.gtk_selection_data_get_target((long)l3);
        if (l5 == 0L) {
            return;
        }
        TransferData transferData = new TransferData();
        transferData.type = l5;
        transferData.pValue = l4;
        transferData.length = n3;
        transferData.format = n4;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = n2;
        dNDEvent.dataType = transferData;
        this.notifyListeners(2001, (Event)dNDEvent);
        if (!dNDEvent.doit) {
            return;
        }
        Transfer transfer = null;
        for (int i = 0; i < this.transferAgents.length; ++i) {
            Transfer transfer2 = this.transferAgents[i];
            if (transfer2 == null || !transfer2.isSupportedType(transferData)) continue;
            transfer = transfer2;
            break;
        }
        if (transfer == null) {
            return;
        }
        transfer.javaToNative(dNDEvent.data, transferData);
        if (transferData.result != 1) {
            return;
        }
        GTK.gtk_selection_data_set((long)l3, (long)transferData.type, (int)transferData.format, (long)transferData.pValue, (int)transferData.length);
        OS.g_free(transferData.pValue);
    }

    void dragDataDelete(long l, long l2) {
        this.moveData = true;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listenerArray = this.getListeners(2008);
        int n = listenerArray.length;
        DragSourceListener[] dragSourceListenerArray = new DragSourceListener[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Listener listener = listenerArray[i];
            if (!(listener instanceof DNDListener)) continue;
            dragSourceListenerArray[n2] = (DragSourceListener)((DNDListener)listener).getEventListener();
            ++n2;
        }
        if (n2 == n) {
            return dragSourceListenerArray;
        }
        DragSourceListener[] dragSourceListenerArray2 = new DragSourceListener[n2];
        System.arraycopy(dragSourceListenerArray, 0, dragSourceListenerArray2, 0, n2);
        return dragSourceListenerArray2;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.targetList != 0L) {
            GTK.gtk_target_list_unref((long)this.targetList);
        }
        this.targetList = 0L;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 |= 2;
        }
        if ((n & 2) == 2) {
            n2 |= 4;
        }
        if ((n & 4) == 4) {
            n2 |= 8;
        }
        return n2;
    }

    int osOpToOp(int n) {
        int n2 = 0;
        if ((n & 2) == 2) {
            n2 |= 1;
        }
        if ((n & 4) == 4) {
            n2 |= 2;
        }
        if ((n & 8) == 8) {
            n2 |= 4;
        }
        return n2;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error((int)4);
        }
        this.removeListener(2008, (SWTEventListener)dragSourceListener);
        this.removeListener(2001, (SWTEventListener)dragSourceListener);
        this.removeListener(2000, (SWTEventListener)dragSourceListener);
    }

    public void setDragSourceEffect(DragSourceEffect dragSourceEffect) {
        this.dragEffect = dragSourceEffect;
    }

    public void setTransfer(Transfer ... transferArray) {
        int n;
        if (this.targetList != 0L) {
            GTK.gtk_target_list_unref((long)this.targetList);
            this.targetList = 0L;
        }
        this.transferAgents = transferArray;
        if (transferArray == null || transferArray.length == 0) {
            return;
        }
        GtkTargetEntry[] gtkTargetEntryArray = new GtkTargetEntry[]{};
        for (int i = 0; i < transferArray.length; ++i) {
            Transfer transfer = transferArray[i];
            if (transfer == null) continue;
            int[] nArray = transfer.getTypeIds();
            String[] stringArray = transfer.getTypeNames();
            for (int j = 0; j < nArray.length; ++j) {
                GtkTargetEntry gtkTargetEntry = new GtkTargetEntry();
                byte[] byArray = Converter.wcsToMbcs((String)stringArray[j], (boolean)true);
                gtkTargetEntry.target = OS.g_malloc(byArray.length);
                C.memmove((long)gtkTargetEntry.target, (byte[])byArray, (long)byArray.length);
                gtkTargetEntry.info = nArray[j];
                GtkTargetEntry[] gtkTargetEntryArray2 = new GtkTargetEntry[gtkTargetEntryArray.length + 1];
                System.arraycopy(gtkTargetEntryArray, 0, gtkTargetEntryArray2, 0, gtkTargetEntryArray.length);
                gtkTargetEntryArray2[gtkTargetEntryArray.length] = gtkTargetEntry;
                gtkTargetEntryArray = gtkTargetEntryArray2;
            }
        }
        long l = OS.g_malloc(gtkTargetEntryArray.length * GtkTargetEntry.sizeof);
        for (n = 0; n < gtkTargetEntryArray.length; ++n) {
            OS.memmove(l + (long)(n * GtkTargetEntry.sizeof), gtkTargetEntryArray[n], (long)GtkTargetEntry.sizeof);
        }
        this.targetList = GTK.gtk_target_list_new((long)l, (int)gtkTargetEntryArray.length);
        for (n = 0; n < gtkTargetEntryArray.length; ++n) {
            OS.g_free(gtkTargetEntryArray[n].target);
        }
    }
}

