/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return false;
    }

    @Deprecated
    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        Object[] objectArray;
        boolean bl;
        int n;
        long l;
        long l2;
        byte[] byArray = Converter.javaStringToCString((String)this.title);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l3 = GTK.gtk_font_chooser_dialog_new((byte[])byArray, (long)0L);
        if (this.parent != null) {
            l2 = this.parent.topHandle();
            GTK.gtk_window_set_transient_for((long)l3, (long)l2);
        }
        l2 = GTK.gtk_window_get_group((long)0L);
        GTK.gtk_window_group_add_window((long)l2, (long)l3);
        GTK.gtk_window_set_modal((long)l3, (boolean)true);
        display.addIdleProc();
        Dialog dialog = display.getModalDialog();
        display.setModalDialog(this);
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            l = OS.pango_font_description_to_string(font.handle);
            n = C.strlen((long)l);
            byte[] byArray2 = new byte[n + 1];
            C.memmove((byte[])byArray2, (long)l, (long)n);
            font.dispose();
            OS.g_free(l);
            GTK.gtk_font_chooser_set_font((long)l3, (byte[])byArray2);
        }
        display.runDialogShownHooks(this, l3);
        int n2 = 0;
        l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, l3, 0L);
        }
        if (GTK.GTK4) {
            n = SyncDialogUtil.run((Display)display, (long)l3, (boolean)false);
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK.gtk_dialog_run((long)l3);
            GDK.gdk_threads_leave();
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l);
        }
        display.setModalDialog(dialog);
        boolean bl2 = bl = n == -5;
        if (bl) {
            long l4 = GTK.gtk_font_chooser_get_font((long)l3);
            int n3 = C.strlen((long)l4);
            byte[] byArray3 = new byte[n3 + 1];
            C.memmove((byte[])byArray3, (long)l4, (long)n3);
            OS.g_free(l4);
            long l5 = OS.pango_font_description_from_string(byArray3);
            Font font = Font.gtk_new((Device)display, (long)l5);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(l5);
        } else {
            this.fontData = null;
        }
        if (bl) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this.fontData;
            objectArray = objectArray2;
            objectArray2[1] = null;
        } else {
            objectArray = null;
        }
        Object[] objectArray3 = (Object[])display.runDialogClosedHooks(this, objectArray);
        if (objectArray3 != null) {
            this.fontData = (FontData)objectArray3[0];
            this.rgb = (RGB)objectArray3[1];
            bl = true;
        }
        display.removeIdleProc();
        if (GTK.GTK4) {
            OS.g_object_unref(l3);
        } else {
            GTK.gtk_widget_destroy((long)l3);
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean bl) {
    }

    @Deprecated
    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

