/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LevelFilter;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFormat;
import de.qfs.lib.log.StreamLogWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FileLogWriter
extends StreamLogWriter {
    public static final int MODE_CREATE = 0;
    public static final int MODE_APPEND = 1;
    public static final int MODE_UNIQUE = 2;
    private static LevelFilter lastLevelFilter;
    protected File file;
    protected boolean keepClosed;

    public FileLogWriter(String string, String string2) throws IOException {
        this.openFile(string, string2, 0);
    }

    public FileLogWriter(String string, String string2, int n, boolean bl) throws IOException {
        this.keepClosed = bl;
        this.openFile(string, string2, n);
    }

    public FileLogWriter(String string, String string2, LogFormat logFormat) throws IOException {
        super(logFormat);
        this.openFile(string, string2, 0);
    }

    public FileLogWriter(String string, String string2, int n, boolean bl, LogFormat logFormat) throws IOException {
        super(logFormat);
        this.keepClosed = bl;
        this.openFile(string, string2, n);
    }

    public static LevelFilter logToFile(String string, String string2, int n, boolean bl) throws IOException {
        lastLevelFilter = new LevelFilter(-1, new FileLogWriter(string, string2, n, bl));
        Log.addFilter(lastLevelFilter);
        return lastLevelFilter;
    }

    public static LevelFilter logToFile(String string, String string2, int n, boolean bl, LogFormat logFormat) throws IOException {
        lastLevelFilter = new LevelFilter(-1, new FileLogWriter(string, string2, n, bl, logFormat));
        Log.addFilter(lastLevelFilter);
        return lastLevelFilter;
    }

    public static void stopLogging() {
        if (lastLevelFilter != null) {
            lastLevelFilter.getLogWriter().close();
            Log.removeFilter(lastLevelFilter);
            lastLevelFilter = null;
        }
    }

    @Override
    public synchronized void write(LogEntry logEntry) {
        if (this.closed) {
            return;
        }
        try {
            if (this.keepClosed) {
                this.pw = new PrintWriter(new FileWriter(this.file.getPath(), true));
            }
            super.write(logEntry);
            if (this.keepClosed) {
                this.pw.close();
                this.pw = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void write(LogEntry[] logEntryArray) {
        if (this.closed) {
            return;
        }
        try {
            if (this.keepClosed) {
                this.pw = new PrintWriter(new FileWriter(this.file.getPath(), true));
            }
            super.write(logEntryArray);
            if (this.keepClosed) {
                this.pw.close();
                this.pw = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void openFile(String string, String string2, int n) {
        boolean bl = n != 1;
        this.file = new File(string2);
        File file = new File(this.file.getParent());
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        try {
            block1 : switch (n) {
                case 0: {
                    this.pw = new PrintWriter(new FileWriter(this.file));
                    break;
                }
                case 1: {
                    bl = !this.file.exists();
                    this.pw = new PrintWriter(new FileWriter(string2, true));
                    break;
                }
                case 2: {
                    String string3 = "";
                    int n2 = string2.lastIndexOf(46);
                    if (n2 > 0) {
                        string3 = string2.substring(n2);
                        string2 = string2.substring(0, n2);
                    }
                    int n3 = 1;
                    while (true) {
                        this.file = new File(string2 + n3 + string3);
                        if (!this.file.exists()) {
                            this.pw = new PrintWriter(new FileWriter(this.file));
                            break block1;
                        }
                        ++n3;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Argument mode must be one of MODE_CREATE, MODE_APPEND or MODE_UNIQUE.");
                }
            }
            if (bl) {
                this.pw.println("client name: " + string);
                this.pw.flush();
            }
            if (this.keepClosed) {
                this.pw.close();
                this.pw = null;
            } else {
                this.mustClose = true;
            }
        }
        catch (IOException iOException) {
            this.closed = true;
        }
    }
}

