/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class QFLogger
extends Logger {
    private boolean initialized = true;
    private boolean checkMethod = false;
    private Map<String, Logger> methodLoggers;

    public QFLogger(Class<?> clazz) {
        this(clazz.getName(), false);
    }

    public QFLogger(Object object) {
        this(object.getClass().getName(), false);
    }

    public QFLogger(String string) {
        this(string, false);
    }

    public QFLogger(String string, boolean bl) {
        super(string);
        this.setCheckMethod(bl);
    }

    public void setCheckMethod(boolean bl) {
        this.checkMethod = bl;
        this.setLevel(this.level);
    }

    public LevelAwareLogBuilder lvlBuild(int n, String string) {
        return this.lvlBuild(n, string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LevelAwareLogBuilder lvlBuild(int n, String string, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.checkMethod) {
            QFLogger qFLogger = this;
            synchronized (qFLogger) {
                int n3;
                if (this.methodLoggers == null) {
                    this.methodLoggers = new HashMap<String, Logger>();
                }
                Logger logger = this.methodLoggers.get(string);
                String string2 = null;
                if (logger == null) {
                    string2 = string;
                    n3 = string2.indexOf("(");
                    if (n3 > 0) {
                        string2 = string2.substring(0, n3);
                    }
                    if ((logger = this.methodLoggers.get(string2)) == null) {
                        logger = new Logger(this.getOwnerName() + "_mtd." + string2);
                        this.methodLoggers.put(string2, logger);
                    }
                    this.methodLoggers.put(string, logger);
                }
                boolean bl3 = bl = QFLogger.getLogLevel(logger) < n;
                if (!bl) {
                    logger = this.methodLoggers.get("_dmp." + string);
                    if (logger == null) {
                        if (string2 == null && (n3 = (string2 = string).indexOf("(")) > 0) {
                            string2 = string2.substring(0, n3);
                        }
                        if ((logger = this.methodLoggers.get("_dmp." + string2)) == null) {
                            logger = new Logger(this.getOwnerName() + "_dmp." + string2);
                            this.methodLoggers.put("_dmp." + string2, logger);
                        }
                        this.methodLoggers.put("_dmp." + string, logger);
                    }
                    bl2 = QFLogger.getLogLevel(logger) >= n;
                }
            }
        }
        return new LevelAwareLogBuilder(this, n, string, n2, bl, bl2);
    }

    @Override
    public void setLevel(int n) {
        super.setLevel(n);
        if (!this.initialized) {
            return;
        }
        String string = this.getOwnerName() + "_mtd.";
        boolean bl = false;
        Object[] objectArray = QFLogger.getLogLevels();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!string.equals(objectArray[i])) continue;
            bl = true;
            break;
        }
        if (this.checkMethod) {
            if (!bl) {
                QFLogger.setLogLevel(string, 10);
            }
        } else if (bl) {
            this.checkMethod = true;
        }
    }

    public QFLogger setMethodLevel(String string, int n) {
        int n2;
        if (!this.checkMethod) {
            this.setCheckMethod(true);
        }
        if ((n2 = string.lastIndexOf("(")) > 0) {
            string = string.substring(0, n2);
        }
        QFLogger.setLogLevel(this.getOwnerName() + "_mtd." + string, n);
        return this;
    }

    public static void bridgeJavaLogger(String string) {
        QFLogger.bridgeJavaLogger(string, false);
    }

    public static void bridgeJavaLogger(String string, boolean bl) {
        new BridgingFilter(string, bl).bridge();
    }

    public static int javaLoggerLevelToQFLogLevel(Level level) {
        if (Level.SEVERE.equals(level)) {
            return 1;
        }
        if (Level.WARNING.equals(level)) {
            return 3;
        }
        if (Level.INFO.equals(level)) {
            return 5;
        }
        if (Level.CONFIG.equals(level)) {
            return 7;
        }
        return 9;
    }

    public static Level qfLoggerLevelToJavaLogLevel(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return Level.SEVERE;
            }
            case 3: 
            case 4: {
                return Level.WARNING;
            }
            case 5: 
            case 6: {
                return Level.INFO;
            }
            case 7: 
            case 8: {
                return Level.CONFIG;
            }
        }
        return Level.FINEST;
    }

    private static class BridgingFilter
    implements Filter {
        final String classToLog;
        final boolean passThrough;
        final java.util.logging.Logger javalogger;
        final BridgingLogger qfLogger;

        public BridgingFilter(String string, boolean bl) {
            this.classToLog = string;
            this.passThrough = bl;
            this.javalogger = java.util.logging.Logger.getLogger(string);
            this.qfLogger = new BridgingLogger(this.javalogger, string);
            this.qfLogger.setJavaLoggerLevel();
        }

        public BridgingFilter bridge() {
            this.javalogger.setFilter(this);
            return this;
        }

        @Override
        public boolean isLoggable(LogRecord logRecord) {
            int n = QFLogger.javaLoggerLevelToQFLogLevel(logRecord.getLevel());
            if (this.qfLogger.level >= n) {
                ((LevelAwareLogBuilder)this.qfLogger.lvlBuild(n, logRecord.getSourceMethodName()).add(logRecord.getMessage())).logAt(logRecord.getMillis());
            }
            return this.passThrough;
        }
    }

    private static class BridgingLogger
    extends QFLogger {
        final java.util.logging.Logger javalogger;

        public BridgingLogger(java.util.logging.Logger logger, String string) {
            super(string);
            this.javalogger = logger;
        }

        @Override
        public void setLevel(int n) {
            super.setLevel(n);
            this.setJavaLoggerLevel();
        }

        public void setJavaLoggerLevel() {
            if (this.javalogger != null) {
                this.javalogger.setLevel(BridgingLogger.qfLoggerLevelToJavaLogLevel(this.level));
            }
        }
    }
}

