/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    long boxHandle;
    long labelHandle;
    long imageHandle;
    long arrowHandle;
    long groupHandle;
    boolean selected;
    boolean grayed;
    ImageList imageList;
    Image image;
    String text;
    GdkRGBA background;
    static final int INNER_BORDER = 1;
    static final int DEFAULT_BORDER = 1;

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    static int checkStyle(int n) {
        if (((n = Button.checkBits(n, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Button.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n & 4) != 0) {
            return Button.checkBits(n |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n;
    }

    static GtkBorder getBorder(byte[] byArray, long l, int n) {
        GtkBorder gtkBorder = new GtkBorder();
        long[] lArray = new long[1];
        OS.gtk_widget_style_get(l, byArray, lArray, 0L);
        if (lArray[0] != 0L) {
            OS.memmove(gtkBorder, lArray[0], (long)GtkBorder.sizeof);
            OS.gtk_border_free(lArray[0]);
            return gtkBorder;
        }
        gtkBorder.left = n;
        gtkBorder.top = n;
        gtkBorder.right = n;
        gtkBorder.bottom = n;
        return gtkBorder;
    }

    @Override
    GdkColor getContextBackground() {
        if (this.background != null) {
            return this.display.toGdkColor(this.background);
        }
        return this.display.COLOR_WIDGET_BACKGROUND;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        Point point;
        boolean bl2;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        this.forceResize();
        int[] nArray = null;
        int[] nArray2 = null;
        if ((this.style & 0x30) != 0) {
            nArray = new int[1];
            nArray2 = new int[1];
            OS.gtk_widget_get_size_request(this.boxHandle, nArray, nArray2);
            OS.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        boolean bl3 = bl2 = this.labelHandle != 0L && (this.style & 0x40) != 0 && OS.gtk_widget_get_visible(this.labelHandle);
        if (bl2) {
            Object object;
            Object object2;
            Object object3;
            int n3;
            int n4 = OS.gtk_container_get_border_width(this.handle);
            int[] nArray3 = new int[1];
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray3, 0L);
            int[] nArray4 = new int[1];
            OS.gtk_widget_style_get(this.handle, OS.focus_padding, nArray4, 0L);
            int n5 = n3 = 2 * (n4 + nArray3[0] + nArray4[0]);
            int n6 = 0;
            if ((this.style & 0x30) != 0) {
                object3 = new int[1];
                OS.gtk_widget_style_get(this.handle, OS.indicator_size, object3, 0L);
                object2 = new int[1];
                OS.gtk_widget_style_get(this.handle, OS.indicator_spacing, object2, 0L);
                n6 = object3[0] + 2 * object2[0];
                n3 += n6 + object2[0];
            } else {
                object3 = this.getThickness(this.handle);
                n3 += object3.x * 2;
                n5 += object3.y * 2;
                object2 = Button.getBorder(OS.inner_border, this.handle, 1);
                n3 += object2.left + object2.right;
                n5 += object2.top + object2.bottom;
                if (OS.gtk_widget_get_can_default(this.handle)) {
                    object = Button.getBorder(OS.default_border, this.handle, 1);
                    n3 += ((GtkBorder)object).left + ((GtkBorder)object).right;
                    n5 += ((GtkBorder)object).top + ((GtkBorder)object).bottom;
                }
            }
            int n7 = 0;
            int n8 = 0;
            if (OS.gtk_widget_get_visible(this.imageHandle)) {
                object = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, (GtkRequisition)object);
                n7 = ((GtkRequisition)object).width;
                n8 = ((GtkRequisition)object).height;
                int[] nArray5 = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, nArray5, 0L);
                n7 += nArray5[0];
            }
            long l = OS.gtk_label_get_layout(this.labelHandle);
            int n9 = OS.pango_layout_get_width(l);
            if (n != -1) {
                OS.pango_layout_set_width(l, Math.max(1, n - n7 - n3) * 1024);
            } else {
                OS.pango_layout_set_width(l, -1);
            }
            int[] nArray6 = new int[1];
            int[] nArray7 = new int[1];
            OS.pango_layout_get_pixel_size(l, nArray6, nArray7);
            OS.pango_layout_set_width(l, n9);
            point = new Point(0, 0);
            point.x = point.x + (n == -1 ? nArray6[0] + n7 + n3 : n);
            point.y = point.y + (n2 == -1 ? Math.max(Math.max(n8, n6), nArray7[0]) + n5 : n2);
        } else {
            point = this.computeNativeSize(this.handle, n, n2, bl);
        }
        if ((this.style & 0x30) != 0) {
            OS.gtk_widget_set_size_request(this.boxHandle, nArray[0], nArray2[0]);
        }
        if ((n != -1 || n2 != -1) && OS.gtk_widget_get_can_default(this.handle)) {
            GtkBorder gtkBorder = Button.getBorder(OS.default_border, this.handle, 1);
            if (n != -1) {
                point.x += gtkBorder.left + gtkBorder.right;
            }
            if (n2 != -1) {
                point.y += gtkBorder.top + gtkBorder.bottom;
            }
        }
        return point;
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        if ((this.style & 0xA) == 0) {
            this.state |= 0x10000;
        }
        int n2 = 62;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        switch (this.style & n2) {
            case 4: {
                if (OS.GTK3) {
                    byte[] byArray = OS.GTK_NAMED_ICON_GO_UP;
                    if ((this.style & 0x80) != 0) {
                        byArray = OS.GTK_NAMED_ICON_GO_UP;
                    }
                    if ((this.style & 0x400) != 0) {
                        byArray = OS.GTK_NAMED_ICON_GO_DOWN;
                    }
                    if ((this.style & 0x4000) != 0) {
                        byArray = OS.GTK_NAMED_ICON_GO_PREVIOUS;
                    }
                    if ((this.style & 0x20000) != 0) {
                        byArray = OS.GTK_NAMED_ICON_GO_NEXT;
                    }
                    this.arrowHandle = OS.gtk_image_new_from_icon_name(byArray, 1);
                } else {
                    int n3 = 0;
                    if ((this.style & 0x80) != 0) {
                        n3 = 0;
                    }
                    if ((this.style & 0x400) != 0) {
                        n3 = 1;
                    }
                    if ((this.style & 0x4000) != 0) {
                        n3 = 2;
                    }
                    if ((this.style & 0x20000) != 0) {
                        n3 = 3;
                    }
                    this.arrowHandle = OS.gtk_arrow_new(n3, 2);
                }
                if (this.arrowHandle == 0L) {
                    this.error(2);
                }
                this.handle = OS.gtk_button_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            case 2: {
                this.handle = OS.gtk_toggle_button_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            case 32: {
                this.handle = OS.gtk_check_button_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            case 16: {
                this.groupHandle = OS.gtk_radio_button_new(0L);
                if (this.groupHandle == 0L) {
                    this.error(2);
                }
                OS.g_object_ref(this.groupHandle);
                OS.g_object_ref_sink(this.groupHandle);
                this.handle = OS.gtk_radio_button_new(OS.gtk_radio_button_get_group(this.groupHandle));
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                OS.gtk_widget_set_can_default(this.handle, true);
            }
        }
        if ((this.style & 4) != 0) {
            OS.gtk_container_add(this.handle, this.arrowHandle);
        } else {
            this.boxHandle = this.gtk_box_new(0, false, 4);
            if (this.boxHandle == 0L) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.boxHandle);
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_container_add(this.boxHandle, this.labelHandle);
            if ((this.style & 0x40) != 0) {
                OS.gtk_label_set_line_wrap(this.labelHandle, true);
                OS.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
            }
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 4) != 0) {
            return;
        }
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
        this._setAlignment(this.style & 0x1024000);
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.boxHandle != 0L) {
            this.display.removeWidget(this.boxHandle);
        }
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0L) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.arrowHandle != 0L) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    @Override
    long fontHandle() {
        if (this.labelHandle != 0L) {
            return this.labelHandle;
        }
        return super.fontHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.gtk_toggle_button_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return l3;
    }

    @Override
    long gtk_clicked(long l) {
        if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.selected);
            } else {
                this.selectRadio();
            }
        } else if ((this.style & 0x20) != 0 && this.grayed) {
            if (OS.gtk_toggle_button_get_active(this.handle)) {
                OS.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                OS.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        long l3 = super.gtk_focus_in_event(l, l2);
        if (this.handle == 0L) {
            return 0L;
        }
        if ((this.style & 8) != 0 && OS.gtk_widget_has_default(this.handle)) {
            Decorations decorations = this.menuShell();
            decorations.defaultButton = this;
        }
        return l3;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        long l3 = super.gtk_focus_out_event(l, l2);
        if (this.handle == 0L) {
            return 0L;
        }
        if ((this.style & 8) != 0) {
            Decorations decorations = this.menuShell();
            if (decorations.defaultButton == this) {
                decorations.defaultButton = null;
            }
        }
        return l3;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        if ((this.style & 0x10) != 0) {
            this.selected = this.getSelection();
        }
        return l3;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean isDescribedByLabel() {
        return false;
    }

    @Override
    boolean mnemonicHit(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        boolean bl = super.mnemonicHit(this.labelHandle, c);
        if (bl) {
            this.setFocus();
        }
        return bl;
    }

    @Override
    boolean mnemonicMatch(char c) {
        if (this.labelHandle == 0L) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, c);
    }

    @Override
    void register() {
        super.register();
        if (this.boxHandle != 0L) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0L) {
            this.display.addWidget(this.imageHandle, this);
        }
        if (this.arrowHandle != 0L) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.arrowHandle = 0L;
        this.labelHandle = 0L;
        this.imageHandle = 0L;
        this.boxHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.groupHandle != 0L) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.image = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void resizeHandle(int n, int n2) {
        super.resizeHandle(n, n2);
        if (!OS.GTK3 && (this.style & 0x30) != 0) {
            OS.gtk_widget_set_size_request(this.boxHandle, n, -1);
        }
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            Control control = controlArray[i];
            if (this == control) continue;
            control.setRadioSelection(false);
        }
        this.setSelection(true);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        this._setAlignment(n);
    }

    void _setAlignment(int n) {
        boolean bl;
        if ((this.style & 4) != 0) {
            boolean bl2;
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n & 0x24480;
            boolean bl3 = bl2 = (this.style & 0x4000000) != 0;
            if (OS.GTK3) {
                byte[] byArray = OS.GTK_NAMED_ICON_GO_UP;
                switch (n) {
                    case 128: {
                        byArray = OS.GTK_NAMED_ICON_GO_UP;
                        break;
                    }
                    case 1024: {
                        byArray = OS.GTK_NAMED_ICON_GO_DOWN;
                        break;
                    }
                    case 16384: {
                        byArray = bl2 ? OS.GTK_NAMED_ICON_GO_NEXT : OS.GTK_NAMED_ICON_GO_PREVIOUS;
                        break;
                    }
                    case 131072: {
                        byArray = bl2 ? OS.GTK_NAMED_ICON_GO_PREVIOUS : OS.GTK_NAMED_ICON_GO_NEXT;
                    }
                }
                OS.gtk_image_set_from_icon_name(this.arrowHandle, byArray, 1);
            } else {
                int n2 = 0;
                switch (n) {
                    case 128: {
                        n2 = 0;
                        break;
                    }
                    case 1024: {
                        n2 = 1;
                        break;
                    }
                    case 16384: {
                        n2 = bl2 ? 3 : 2;
                        break;
                    }
                    case 131072: {
                        n2 = bl2 ? 2 : 3;
                    }
                }
                OS.gtk_arrow_set(this.arrowHandle, n2, 2);
            }
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        boolean bl4 = bl = OS.gtk_widget_get_visible(this.labelHandle) && OS.gtk_widget_get_visible(this.imageHandle);
        if (bl) {
            if ((this.style & 0x30) != 0) {
                n = 16384;
            }
            if ((this.style & 0xA) != 0) {
                n = 0x1000000;
            }
        }
        if ((n & 0x4000) != 0) {
            if (bl) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 0);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
            } else if (OS.GTK3) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_label_set_align(this.labelHandle, 0.0f, 0.5f);
                this.gtk_widget_set_align(this.imageHandle, 1, 3);
            } else {
                OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
                OS.gtk_misc_set_alignment(this.imageHandle, 0.0f, 0.5f);
            }
            OS.gtk_label_set_justify(this.labelHandle, 0);
            return;
        }
        if ((n & 0x1000000) != 0) {
            if (bl) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                    this.gtk_label_set_align(this.labelHandle, 0.0f, 0.5f);
                    this.gtk_widget_set_align(this.imageHandle, 2, 3);
                } else {
                    OS.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.5f);
                    OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
                }
            } else {
                if (OS.GTK3) {
                    OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                    OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
                }
                if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                    this.gtk_label_set_align(this.labelHandle, 0.5f, 0.5f);
                    this.gtk_widget_set_align(this.imageHandle, 3, 3);
                } else {
                    OS.gtk_misc_set_alignment(this.labelHandle, 0.5f, 0.5f);
                    OS.gtk_misc_set_alignment(this.imageHandle, 0.5f, 0.5f);
                }
                OS.gtk_label_set_justify(this.labelHandle, 2);
            }
            return;
        }
        if ((n & 0x20000) != 0) {
            if (bl) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 1);
            } else if (OS.GTK3) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 1);
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
            }
            if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_label_set_align(this.labelHandle, 1.0f, 0.5f);
                this.gtk_widget_set_align(this.imageHandle, 2, 3);
            } else {
                OS.gtk_misc_set_alignment(this.labelHandle, 1.0f, 0.5f);
                OS.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            }
            OS.gtk_label_set_justify(this.labelHandle, 1);
            return;
        }
    }

    @Override
    void setBackgroundColor(long l, long l2, GdkRGBA gdkRGBA) {
        this.background = gdkRGBA;
        if (OS.GTK_VERSION < OS.VERSION(3, 10, 3) && (this.style & 0x30) != 0) {
            super.setBackgroundColor(l, l2, gdkRGBA);
            return;
        }
        String string = "* {background : ";
        String string2 = this.display.gtk_rgba_to_css_string(gdkRGBA);
        this.cssBackground = string = string + string2 + ";}";
        String string3 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string3);
    }

    @Override
    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        this.setBackgroundColor(this.fixedHandle, gdkColor);
        if (!OS.GTK3) {
            if (this.labelHandle != 0L) {
                this.setBackgroundColor(this.labelHandle, gdkColor);
            }
            if (this.imageHandle != 0L) {
                this.setBackgroundColor(this.imageHandle, gdkColor);
            }
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.labelHandle != 0L && (this.style & 0x40) != 0 && OS.gtk_widget_get_visible(this.labelHandle);
        if (bl3) {
            OS.gtk_widget_set_size_request(this.boxHandle, -1, -1);
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            GtkRequisition gtkRequisition;
            GtkAllocation gtkAllocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(this.boxHandle, gtkAllocation);
            int n6 = gtkAllocation.width;
            int n7 = gtkAllocation.height;
            long l = OS.gtk_label_get_layout(this.labelHandle);
            int n8 = OS.pango_layout_get_width(l);
            OS.pango_layout_set_width(l, -1);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.pango_layout_get_pixel_size(l, nArray, nArray2);
            OS.pango_layout_set_width(l, n8);
            int n9 = 0;
            if (OS.gtk_widget_get_visible(this.imageHandle)) {
                gtkRequisition = new GtkRequisition();
                this.gtk_widget_get_preferred_size(this.imageHandle, gtkRequisition);
                n9 = gtkRequisition.width;
                int[] nArray3 = new int[1];
                OS.g_object_get(this.boxHandle, OS.spacing, nArray3, 0L);
                n9 += nArray3[0];
            }
            OS.gtk_widget_set_size_request(this.labelHandle, Math.min(nArray[0], n6 - n9), -1);
            gtkRequisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.boxHandle, gtkRequisition);
            gtkAllocation.width = n6;
            gtkAllocation.height = n7;
            OS.gtk_widget_size_allocate(this.boxHandle, gtkAllocation);
        }
        return n5;
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        if (this.labelHandle != 0L) {
            this.setFontDescription(this.labelHandle, l);
        }
        if (this.imageHandle != 0L) {
            this.setFontDescription(this.imageHandle, l);
        }
    }

    @Override
    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            GdkRGBA gdkRGBA = null;
            if (gdkColor != null) {
                gdkRGBA = this.display.toGdkRGBA(gdkColor);
            }
            this.setForegroundColor(this.fixedHandle, gdkRGBA);
            if (this.labelHandle != 0L) {
                this.setForegroundColor(this.labelHandle, gdkRGBA);
            }
            if (this.imageHandle != 0L) {
                this.setForegroundColor(this.imageHandle, gdkRGBA);
            }
        } else {
            this.setForegroundColor(this.fixedHandle, gdkColor);
            if (this.labelHandle != 0L) {
                this.setForegroundColor(this.labelHandle, gdkColor);
            }
            if (this.imageHandle != 0L) {
                this.setForegroundColor(this.imageHandle, gdkColor);
            }
            if (OS.GTK_VERSION >= OS.VERSION(3, 10, 0) && OS.GTK_VERSION < OS.VERSION(3, 16, 0) && (this.style & 0x30) != 0) {
                this.gtk_swt_set_border_color(gdkColor);
            }
        }
    }

    @Override
    void setForegroundColor(long l, GdkRGBA gdkRGBA) {
        String string;
        GdkRGBA gdkRGBA2;
        if (gdkRGBA != null) {
            gdkRGBA2 = gdkRGBA;
        } else {
            GdkColor gdkColor = this.display.COLOR_WIDGET_FOREGROUND;
            gdkRGBA2 = this.display.toGdkRGBA(gdkColor);
        }
        long l2 = OS.gtk_widget_get_style_context(l);
        String string2 = this.display.gtk_rgba_to_css_string(gdkRGBA2);
        String string3 = OS.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "button" : "GtkButton";
        this.cssForeground = string = string3 + " {color: " + string2 + ";}";
        String string4 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 16);
        this.gtk_css_provider_load_from_css(l2, string4);
    }

    private void gtk_swt_set_border_color(GdkColor gdkColor) {
        GdkRGBA gdkRGBA = null;
        if (gdkColor != null) {
            gdkRGBA = this.display.toGdkRGBA(gdkColor);
        }
        String string = "* {\n";
        if (gdkRGBA != null) {
            String string2 = this.display.gtk_rgba_to_css_string(gdkRGBA);
            string = string + "border-color: " + string2 + ";\n";
        }
        string = string + "}\n";
        long l = OS.gtk_widget_get_style_context(this.handle);
        this.gtk_css_provider_load_from_css(l, string);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = bl;
        if (bl && OS.gtk_toggle_button_get_active(this.handle)) {
            OS.gtk_toggle_button_set_inconsistent(this.handle, true);
        } else {
            OS.gtk_toggle_button_set_inconsistent(this.handle, false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            this.imageList = new ImageList();
            int n = this.imageList.add(image);
            long l = this.imageList.getPixbuf(n);
            this.gtk_image_set_from_pixbuf(this.imageHandle, l);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
        }
        this.image = image;
        this.updateWidgetsVisibility();
        this._setAlignment(this.style);
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.boxHandle != 0L) {
                OS.gtk_widget_set_direction(this.boxHandle, n);
            }
            if (this.labelHandle != 0L) {
                OS.gtk_widget_set_direction(this.labelHandle, n);
            }
            if (this.imageHandle != 0L) {
                OS.gtk_widget_set_direction(this.imageHandle, n);
            }
            if (this.arrowHandle != 0L) {
                if (OS.GTK3) {
                    byte[] byArray = (this.style & 0x4000000) != 0 ? OS.GTK_NAMED_ICON_GO_NEXT : OS.GTK_NAMED_ICON_GO_PREVIOUS;
                    switch (this.style & 0x24000) {
                        case 16384: {
                            OS.gtk_image_set_from_icon_name(this.arrowHandle, byArray, 1);
                            break;
                        }
                        case 131072: {
                            OS.gtk_image_set_from_icon_name(this.arrowHandle, byArray, 1);
                        }
                    }
                } else {
                    int n3 = (this.style & 0x4000000) != 0 ? 3 : 2;
                    switch (this.style & 0x24000) {
                        case 16384: {
                            OS.gtk_arrow_set(this.arrowHandle, n3, 2);
                            break;
                        }
                        case 131072: {
                            OS.gtk_arrow_set(this.arrowHandle, n3, 2);
                        }
                    }
                }
            }
        }
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
        OS.gtk_toggle_button_set_active(this.handle, bl);
        if ((this.style & 0x20) != 0) {
            if (bl && this.grayed) {
                OS.gtk_toggle_button_set_inconsistent(this.handle, true);
            } else {
                OS.gtk_toggle_button_set_inconsistent(this.handle, false);
            }
        }
        if ((this.style & 0x10) != 0) {
            OS.gtk_toggle_button_set_active(this.groupHandle, !bl);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        this.updateWidgetsVisibility();
        this._setAlignment(this.style);
    }

    private void updateWidgetsVisibility() {
        if (this.text.length() == 0 && this.image == null) {
            OS.gtk_widget_hide(this.boxHandle);
            OS.gtk_widget_hide(this.labelHandle);
            OS.gtk_widget_hide(this.imageHandle);
        } else {
            OS.gtk_widget_show(this.boxHandle);
            if (this.text.length() == 0) {
                OS.gtk_widget_hide(this.labelHandle);
            } else {
                OS.gtk_widget_show(this.labelHandle);
            }
            if (this.image == null) {
                OS.gtk_widget_hide(this.imageHandle);
            } else {
                OS.gtk_widget_show(this.imageHandle);
            }
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.boxHandle != 0L && (this.text != null && this.text.length() != 0 || this.image != null)) {
            OS.gtk_widget_show(this.boxHandle);
        }
        if (this.labelHandle != 0L && this.text != null && this.text.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
        if (this.arrowHandle != 0L) {
            OS.gtk_widget_show(this.arrowHandle);
        }
    }

    @Override
    int traversalCode(int n, GdkEventKey gdkEventKey) {
        int n2 = super.traversalCode(n, gdkEventKey);
        if ((this.style & 4) != 0) {
            n2 &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            n2 |= 0x60;
        }
        return n2;
    }
}

