/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j;

import com.cdp4j.Browser;
import com.cdp4j.Constant;
import com.cdp4j.Options;
import com.cdp4j.channel.ChannelFactory;
import com.cdp4j.channel.Connection;
import com.cdp4j.channel.JreWebSocketFactory;
import com.cdp4j.channel.NvWebSocketFactory;
import com.cdp4j.channel.WebSocketConnection;
import com.cdp4j.exception.CdpException;
import com.cdp4j.logger.CdpLogger;
import com.cdp4j.logger.CdpLoggerFactory;
import com.cdp4j.process.CdpProcess;
import com.cdp4j.session.SessionFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.ThreadLocalRandom;

public class Launcher {
    private final Options options;
    private final ChannelFactory channelFactory;
    private final CdpLogger log;
    private Path userDataDir;
    private SessionFactory factory;

    public Launcher(Options options, ChannelFactory channelFactory) {
        this.options = options;
        this.channelFactory = channelFactory;
        this.log = new CdpLoggerFactory(options).getLogger("cdp4j.launcher");
        this.log.info("ChannelFactory: {}", channelFactory.getClass().getSimpleName());
    }

    public Launcher(ChannelFactory channelFactory) {
        this(Options.builder().build(), channelFactory);
    }

    public Launcher(Options options) {
        this(options, Launcher.createChannelFactory());
    }

    public Launcher() {
        this(Options.builder().build(), Launcher.createChannelFactory());
    }

    private static ChannelFactory createChannelFactory() {
        if (Constant.JAVA_8) {
            return new NvWebSocketFactory();
        }
        return new JreWebSocketFactory();
    }

    protected String findChrome() {
        String executablePath = this.options.browserExecutablePath();
        if (executablePath != null && !executablePath.trim().isEmpty()) {
            this.log.info("Browser executablePath: {}", executablePath);
            return executablePath;
        }
        if (Constant.WINDOWS) {
            String executable = this.findChromeWinPath();
            this.log.info("Browser executablePath [Windows]: {}", executable);
            if (executable == null) {
                throw new CdpException("Chromium/Chrome browser not found");
            }
            return executable;
        }
        if (Constant.MACOS) {
            String executable = this.findChromeOsxPath();
            this.log.info("Browser executablePath [macOS]: {}", executable);
            if (executable == null) {
                throw new CdpException("Chromium/Chrome browser not found");
            }
            return executable;
        }
        executablePath = "google-chrome";
        this.log.info("Browser executablePath [GNU/Linux]: {}", executablePath);
        return executablePath;
    }

    protected String findChromeWinPath() {
        try {
            for (String next : this.getChromeWinPaths()) {
                Path path = Paths.get(next, new String[0]);
                boolean exist = Files.exists(path, new LinkOption[0]) && Files.isExecutable(path);
                if (!exist) continue;
                return next;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean isChromeInstalled() {
        return this.findChrome() != null;
    }

    protected List<String> getChromeWinPaths() {
        Browser browser = this.options.browser();
        List<String> prefixes = Arrays.asList(System.getenv("localappdata"), System.getenv("programfiles"), System.getenv("programfiles(x86)"));
        List<Object> suffixes = Collections.emptyList();
        switch (browser) {
            case Any: {
                suffixes = Arrays.asList("\\Google\\Chrome Dev\\Application\\chrome.exe", "\\Google\\Chrome SxS\\Application\\chrome.exe", "\\Google\\Chrome\\Application\\chrome.exe", "\\Microsoft\\Edge\\Application\\msedge.exe");
            }
            default: {
                suffixes = Arrays.asList("\\Google\\Chrome\\Application\\chrome.exe");
                break;
            }
            case ChromeCanary: {
                suffixes = Arrays.asList("\\Google\\Chrome SxS\\Application\\chrome.exe");
                break;
            }
            case ChromeDev: {
                suffixes = Arrays.asList("\\Google\\Chrome Dev\\Application\\chrome.exe");
                break;
            }
            case MicrosoftEdge: {
                suffixes = Arrays.asList("\\Microsoft\\Edge\\Application\\msedge.exe");
            }
        }
        ArrayList<String> installations = new ArrayList<String>(prefixes.size() * suffixes.size());
        for (String prefix : prefixes) {
            for (String string : suffixes) {
                installations.add(prefix + string);
            }
        }
        return installations;
    }

    protected String findChromeOsxPath() {
        for (String path : this.getChromeOsxPaths()) {
            File chrome = new File(path);
            if (!chrome.exists() || !chrome.canExecute()) continue;
            return chrome.toString();
        }
        return null;
    }

    protected List<String> getChromeOsxPaths() {
        return Arrays.asList("/Applications/Google Chrome Canary.app/Contents/MacOS/Google Chrome Canary", "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome");
    }

    protected List<String> getCommonParameters(String chromeExecutablePath, List<String> arguments) {
        ArrayList<String> list = new ArrayList<String>();
        String safeProcessPath = this.options.safeProcessPath();
        if (!Constant.MACOS_ARM && safeProcessPath != null && !safeProcessPath.trim().isEmpty()) {
            list.add(safeProcessPath);
            list.add("--");
        }
        list.add(chromeExecutablePath);
        list.add("--disable-features=Translate");
        list.add("--disable-extensions");
        list.add("--disable-component-extensions-with-background-pages");
        list.add("--disable-background-networking");
        list.add("--safebrowsing-disable-auto-update");
        list.add("--disable-component-update");
        list.add("--disable-client-side-phishing-detection");
        list.add("--disable-sync");
        list.add("--metrics-recording-only");
        list.add("--disable-default-apps");
        list.add("--mute-audio");
        list.add("--no-first-run");
        list.add("--disable-renderer-backgrounding");
        list.add("--disable-background-timer-throttling");
        list.add("--disable-ipc-flooding-protection");
        list.add("--no-default-browser-check");
        list.add("--use-mock-keychain");
        list.add("--disable-breakpad");
        list.add("--disable-backgrounding-occluded-windows");
        list.add("--password-store=basic");
        list.add("--force-fieldtrials=*BackgroundTracing/default/");
        list.add("--disable-hang-monitor");
        list.add("--disable-dev-shm-usage");
        list.add("--disable-plugin-power-saver");
        list.add("--disable-popup-blocking");
        list.add("--disable-prompt-on-repost");
        if (!arguments.isEmpty()) {
            list.addAll(arguments);
        }
        return list;
    }

    protected String toString(InputStream is) {
        try (Scanner scanner = new Scanner(is);){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    public SessionFactory launch() {
        boolean inUse;
        List<String> arguments = this.getCommonParameters(this.findChrome(), this.options.arguments());
        this.appendStartPage(arguments);
        Path path = this.userDataDir = this.options.userDataDir() != null ? this.options.userDataDir() : Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("remote-profile");
        if (!this.options.useDefaultUserDataDir() && this.userDataDir != null) {
            this.log.info("user-data-dir: {}", this.userDataDir.toString());
            arguments.add(String.format("--user-data-dir=%s", this.userDataDir.toString()));
        }
        boolean bl = inUse = this.options.useDefaultUserDataDir() ? false : this.isInUse(this.userDataDir);
        if (inUse) {
            throw new CdpException("--user-data-dir [" + this.userDataDir.toString() + "] is used by another process.");
        }
        if (this.options.headless()) {
            this.log.info("headless: {}", this.options.headless());
            arguments.add("--headless=new");
        }
        SessionFactory factory = null;
        if (this.options.remoteDebuggingPort() > 0) {
            this.log.info("remote-debugging-port: {}", this.options.remoteDebuggingPort());
            arguments.add(String.format("--remote-debugging-port=%d", this.options.remoteDebuggingPort()));
        } else {
            arguments.add("--remote-debugging-port=0");
        }
        this.log.info("launcher: {}", "ProcessBuilder");
        this.factory = factory = this.launchWithProcessBuilder(arguments);
        return this.factory;
    }

    protected void appendStartPage(List<String> arguments) {
        if (!arguments.get(arguments.size() - 1).equals("about:blank")) {
            arguments.add("about:blank");
        }
    }

    protected boolean isInUse(Path userDataDir) {
        Path devToolsActivePort = userDataDir.resolve("DevToolsActivePort");
        if (Files.exists(devToolsActivePort, new LinkOption[0])) {
            int port;
            List<Object> lines = Collections.emptyList();
            try {
                lines = Files.readAllLines(devToolsActivePort);
            }
            catch (IOException e) {
                throw new CdpException(e);
            }
            if (lines.size() >= 1 && (port = Integer.parseInt((String)lines.get(0))) > 0) {
                boolean bl;
                ServerSocket ignored = new ServerSocket(port);
                try {
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return true;
                    }
                }
                ignored.close();
                return bl;
            }
        }
        return false;
    }

    protected SessionFactory launchWithProcessBuilder(List<String> arguments) {
        String cdp4jId = Long.toHexString(ThreadLocalRandom.current().nextLong());
        arguments.add(String.format("--cdp4jId=%s", cdp4jId));
        Connection connection = null;
        ProcessBuilder builder = new ProcessBuilder(arguments);
        builder.environment().put("CDP4J_ID", cdp4jId);
        try {
            Process process = builder.start();
            try (Scanner scanner = new Scanner(process.getErrorStream());){
                while (scanner.hasNext()) {
                    String line = scanner.nextLine().trim();
                    if (line.isEmpty() || !line.toLowerCase(Locale.ENGLISH).startsWith("devtools listening on")) continue;
                    int start = line.indexOf("ws://");
                    connection = new WebSocketConnection(line.substring(start, line.length()));
                    break;
                }
                if (connection == null) {
                    throw new CdpException("WebSocket connection url is required!");
                }
            }
            if (!process.isAlive()) {
                throw new CdpException("No process: the chrome process is not alive.");
            }
            this.options.processManager().setProcess(new CdpProcess(process, cdp4jId));
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        try {
            URL url = new URL(connection.getUrl().replace("ws://", "http://"));
            this.log.info("DevTools remote debugging URL: http://{}:{}", url.getHost(), url.getPort());
        }
        catch (MalformedURLException e) {
            throw new CdpException(e);
        }
        SessionFactory factory = new SessionFactory(this.options, this.channelFactory, connection);
        return factory;
    }

    public boolean kill() {
        if (this.factory != null) {
            this.factory.close();
        }
        return this.options.processManager().kill();
    }

    public Options getOptions() {
        return this.options;
    }

    public Path getUserDataDir() {
        return this.userDataDir;
    }
}

