/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.asynchttpclient.netty.ws.NettyWebSocket;

class AsyncWebSocketChannel
implements Channel {
    private final CompletableFuture<NettyWebSocket> future;
    private NettyWebSocket webSocket;

    public AsyncWebSocketChannel(CompletableFuture<NettyWebSocket> future) {
        this.future = future;
    }

    @Override
    public boolean isOpen() {
        return this.webSocket.isOpen();
    }

    @Override
    public void disconnect() {
        if (this.isOpen()) {
            this.webSocket.sendCloseFrame(1000, "done");
        }
    }

    @Override
    public void sendText(String message) {
        this.webSocket.sendTextFrame(message);
    }

    @Override
    public void sendText(byte[] message) {
        this.webSocket.sendTextFrame(new String(message, StandardCharsets.UTF_8));
    }

    @Override
    public void connect() {
        this.webSocket = this.future.join();
    }
}

