/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import com.cdp4j.channel.ChannelFactory;
import com.cdp4j.channel.Connection;
import com.cdp4j.channel.JakartaWebSocketChannel;
import com.cdp4j.channel.JakartaWebSocketListener;
import com.cdp4j.exception.CdpException;
import com.cdp4j.session.SessionFactory;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;

public class JakartaWebSocketFactory
implements ChannelFactory {
    private final WebSocketContainer webSocketContainer;

    public JakartaWebSocketFactory(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, com.cdp4j.session.MessageHandler handler) {
        try {
            JakartaWebSocketListener listener = new JakartaWebSocketListener(factory, handler);
            Session session = this.webSocketContainer.connectToServer((Endpoint)listener, ClientEndpointConfig.Builder.create().build(), URI.create(connection.getUrl()));
            session.addMessageHandler((MessageHandler)listener);
            return new JakartaWebSocketChannel(session);
        }
        catch (DeploymentException | IOException e) {
            throw new CdpException(e);
        }
    }
}

