/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import com.cdp4j.channel.ChannelFactory;
import com.cdp4j.channel.Connection;
import com.cdp4j.channel.JreWebSocketChannel;
import com.cdp4j.channel.JreWebSocketListener;
import com.cdp4j.session.MessageHandler;
import com.cdp4j.session.SessionFactory;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class JreWebSocketFactory
implements ChannelFactory {
    private static final int CONNECTION_TIMEOUT = 10000;
    private final HttpClient client;

    public JreWebSocketFactory() {
        this(null);
    }

    public JreWebSocketFactory(Executor executor) {
        this(executor, 10000);
    }

    public JreWebSocketFactory(Executor executor, int connectionTimeout) {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (executor != null) {
            builder.executor(executor);
        }
        this.client = builder.connectTimeout(Duration.ofMillis(connectionTimeout)).build();
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        String url = connection.getUrl();
        CompletableFuture<WebSocket> future = this.client.newWebSocketBuilder().buildAsync(URI.create(url), new JreWebSocketListener(factory, handler));
        return new JreWebSocketChannel(future);
    }
}

