/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import com.cdp4j.channel.NettyWebSocketClientHandshaker;
import com.cdp4j.channel.NettyWebSocketListener;
import com.cdp4j.exception.CdpException;
import com.cdp4j.session.MessageHandler;
import com.cdp4j.session.SessionFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;

public class NettyWebSocketChannel
implements Channel {
    private final Bootstrap bootstrap;
    private final URI uri;
    private io.netty.channel.Channel channel;

    public NettyWebSocketChannel(SessionFactory factory, MessageHandler handler, URI uri, EventLoopGroup group, boolean performMasking) {
        this.uri = uri;
        this.bootstrap = new Bootstrap();
        NettyWebSocketClientHandshaker handshaker = performMasking ? WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, null, (int)0x10000000) : new NettyWebSocketClientHandshaker(uri, WebSocketVersion.V13, null, false, null, 0x10000000, performMasking, performMasking);
        final NettyWebSocketListener webSocketHandler = new NettyWebSocketListener(factory, handler, (WebSocketClientHandshaker)handshaker);
        ((Bootstrap)((Bootstrap)this.bootstrap.group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), webSocketHandler});
            }
        });
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void disconnect() {
        if (this.channel.isOpen()) {
            try {
                this.channel.writeAndFlush((Object)new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE)).sync();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.channel.close();
            }
        }
    }

    @Override
    public void sendText(String message) {
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(message));
    }

    @Override
    public void sendText(byte[] message) {
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(Unpooled.wrappedBuffer((byte[])message)));
    }

    @Override
    public void connect() {
        try {
            this.channel = this.bootstrap.connect(this.uri.getHost(), this.uri.getPort()).sync().channel();
        }
        catch (InterruptedException e) {
            throw new CdpException(e);
        }
    }
}

