/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import com.cdp4j.exception.CdpException;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFrame;

public class NvWebSocketChannel
implements Channel {
    private final WebSocket webSocket;

    NvWebSocketChannel(WebSocket webSocket) {
        this.webSocket = webSocket;
        this.webSocket.setDirectTextMessage(true);
        this.webSocket.setAutoFlush(true);
    }

    @Override
    public boolean isOpen() {
        return this.webSocket.isOpen();
    }

    @Override
    public void disconnect() {
        if (this.webSocket.isOpen()) {
            try {
                this.webSocket.sendClose(1000, "done");
                this.webSocket.disconnect(1000, null, 100L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void sendText(String message) {
        this.webSocket.sendText(message);
    }

    @Override
    public void sendText(byte[] message) {
        WebSocketFrame frame = new WebSocketFrame().setPayload(message).setOpcode(1).setFin(true);
        this.webSocket.sendFrame(frame);
    }

    @Override
    public void connect() {
        try {
            this.webSocket.connect();
        }
        catch (WebSocketException e) {
            throw new CdpException(e);
        }
    }
}

