/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import com.cdp4j.channel.ChannelFactory;
import com.cdp4j.channel.Connection;
import com.cdp4j.channel.NvWebSocketChannel;
import com.cdp4j.channel.NvWebSocketListener;
import com.cdp4j.exception.CdpException;
import com.cdp4j.session.MessageHandler;
import com.cdp4j.session.SessionFactory;
import com.neovisionaries.ws.client.DualStackMode;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketListener;
import java.io.IOException;

public class NvWebSocketFactory
implements ChannelFactory,
AutoCloseable {
    private static final int CONNECTION_TIMEOUT = 10000;
    private final WebSocketFactory factory = new WebSocketFactory();
    private WebSocket webSocket;

    public NvWebSocketFactory() {
        this(10000);
    }

    public NvWebSocketFactory(int connectionTimeout) {
        this.factory.setConnectionTimeout(connectionTimeout);
        this.factory.setDualStackMode(DualStackMode.IPV4_ONLY);
        this.factory.setVerifyHostname(false);
        this.factory.setSocketTimeout(connectionTimeout);
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        if (this.webSocket != null) {
            throw new IllegalStateException();
        }
        String url = connection.getUrl();
        try {
            this.webSocket = this.factory.createSocket(url);
        }
        catch (IOException e) {
            throw new CdpException(e);
        }
        this.webSocket.addListener((WebSocketListener)new NvWebSocketListener(factory, handler));
        return new NvWebSocketChannel(this.webSocket);
    }

    @Override
    public void close() {
        if (this.webSocket != null && this.webSocket.isOpen()) {
            this.webSocket.disconnect();
        }
    }
}

