/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.websocket.CloseReason;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;

public class StandardWebSocketChannel
implements Channel {
    private final Session session;
    private final RemoteEndpoint.Async remote;

    public StandardWebSocketChannel(Session session) {
        this.session = session;
        this.remote = session.getAsyncRemote();
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public void disconnect() {
        if (this.session.isOpen()) {
            try {
                this.session.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)1000), "done"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void sendText(String message) {
        this.remote.sendText(message);
    }

    @Override
    public void sendText(byte[] message) {
        this.remote.sendText(new String(message, StandardCharsets.UTF_8));
    }

    @Override
    public void connect() {
    }
}

