/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import com.cdp4j.channel.ChannelFactory;
import com.cdp4j.channel.Connection;
import com.cdp4j.channel.StandardWebSocketChannel;
import com.cdp4j.channel.StandardWebSocketListener;
import com.cdp4j.exception.CdpException;
import com.cdp4j.session.MessageHandler;
import com.cdp4j.session.SessionFactory;
import java.io.IOException;
import java.net.URI;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class StandardWebSocketFactory
implements ChannelFactory {
    private final WebSocketContainer webSocketContainer;

    public StandardWebSocketFactory(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        try {
            StandardWebSocketListener listener = new StandardWebSocketListener(factory, handler);
            Session session = this.webSocketContainer.connectToServer((Endpoint)listener, ClientEndpointConfig.Builder.create().build(), URI.create(connection.getUrl()));
            session.addMessageHandler((javax.websocket.MessageHandler)listener);
            return new StandardWebSocketChannel(session);
        }
        catch (IOException | DeploymentException e) {
            throw new CdpException(e);
        }
    }
}

