/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.channel;

import com.cdp4j.channel.Channel;
import com.cdp4j.channel.ChannelFactory;
import com.cdp4j.channel.Connection;
import com.cdp4j.channel.UndertowWebSocketChannel;
import com.cdp4j.exception.CdpException;
import com.cdp4j.session.MessageHandler;
import com.cdp4j.session.SessionFactory;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.core.WebSocketChannel;
import java.net.URI;
import java.net.URISyntaxException;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowWebSocketFactory
implements ChannelFactory,
AutoCloseable {
    private static final int DEFAULT_POOL_BUFFER_SIZE = 16384;
    private final XnioWorker worker;
    private final ByteBufferPool pool;

    public UndertowWebSocketFactory() {
        this(false, 16384);
    }

    public UndertowWebSocketFactory(boolean useDirectByteBuffer) {
        this(false, 16384);
    }

    public UndertowWebSocketFactory(boolean useDirectByteBuffer, int poolBufferSize) {
        OptionMap options = OptionMap.builder().set(Options.THREAD_DAEMON, true).set(Options.WORKER_TASK_MAX_THREADS, 1).set(Options.WORKER_IO_THREADS, 1).set(Options.WORKER_NAME, (Object)"CdpWebSocketWorker").set(Options.USE_DIRECT_BUFFERS, useDirectByteBuffer).set(Options.WORKER_READ_THREADS, 1).getMap();
        this.worker = Xnio.getInstance().createWorkerBuilder().populateFromOptions(options).setCoreWorkerPoolSize(1).setMaxWorkerPoolSize(1).setDaemon(true).setWorkerName("CdpWebSocketWorker").build();
        this.pool = new DefaultByteBufferPool(useDirectByteBuffer, poolBufferSize);
    }

    public UndertowWebSocketFactory(XnioWorker worker, ByteBufferPool pool) {
        this.worker = worker;
        this.pool = pool;
    }

    @Override
    public Channel createChannel(Connection connection, SessionFactory factory, MessageHandler handler) {
        URI uri;
        String url = connection.getUrl();
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new CdpException(e);
        }
        WebSocketClient.ConnectionBuilder builder = WebSocketClient.connectionBuilder((XnioWorker)this.worker, (ByteBufferPool)this.pool, (URI)uri);
        IoFuture future = builder.connect();
        return new UndertowWebSocketChannel((IoFuture<WebSocketChannel>)future, factory, handler);
    }

    @Override
    public void close() {
        if (this.worker != null) {
            this.worker.shutdownNow();
        }
        if (this.pool != null) {
            this.pool.close();
        }
    }
}

