/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.chromium;

import com.cdp4j.chromium.ChromiumChannel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ChromiumVersion
implements Comparable<ChromiumVersion> {
    private final String version;
    private final ChromiumChannel channel;
    @JsonSerialize(using=LocalDateSerializer.class)
    @JsonDeserialize(using=LocalDateDeserializer.class)
    private final LocalDate releaseDate;
    private final Long position;

    @JsonCreator
    ChromiumVersion(@JsonProperty(value="version") String version, @JsonProperty(value="channel") ChromiumChannel channel, @JsonProperty(value="releaseDate") LocalDate releaseDate, @JsonProperty(value="position") Long position) {
        this.version = version;
        this.channel = channel;
        this.releaseDate = releaseDate;
        this.position = position;
    }

    public String getVersion() {
        return this.version;
    }

    public ChromiumChannel getChannel() {
        return this.channel;
    }

    public LocalDate getReleaseDate() {
        return this.releaseDate;
    }

    @Override
    public int compareTo(ChromiumVersion o) {
        return this.releaseDate.compareTo(o.getReleaseDate());
    }

    public Long getPosition() {
        return this.position;
    }

    public long daysBetween(LocalDate date) {
        return ChronoUnit.DAYS.between(this.releaseDate, date);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channel, this.position, this.releaseDate, this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChromiumVersion other = (ChromiumVersion)obj;
        return this.channel == other.channel && Objects.equals(this.position, other.position) && Objects.equals(this.releaseDate, other.releaseDate) && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return "ChromiumVersion [version=" + this.version + ", channel=" + (Object)((Object)this.channel) + ", releaseDate=" + this.releaseDate + "]";
    }

    private static class LocalDateSerializer
    extends JsonSerializer<LocalDate> {
        private LocalDateSerializer() {
        }

        public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
            map.put("year", value.getYear());
            map.put("month", value.getMonthValue());
            map.put("day", value.getDayOfMonth());
            gen.writeObject(map);
        }
    }

    private static class LocalDateDeserializer
    extends JsonDeserializer<LocalDate> {
        private LocalDateDeserializer() {
        }

        public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map map = (Map)ctxt.readValue(p, Map.class);
            int year = (Integer)map.get("year");
            int month = (Integer)map.get("month");
            int dayOfMonth = (Integer)map.get("day");
            LocalDate date = LocalDate.of(year, month, dayOfMonth);
            return date;
        }
    }
}

