/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.command;

import com.cdp4j.command.BluetoothEmulationAsync;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.DomainCommand;
import com.cdp4j.session.ParameterizedCommandImpl;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.type.bluetoothemulation.CentralState;
import com.cdp4j.type.bluetoothemulation.CharacteristicOperationType;
import com.cdp4j.type.bluetoothemulation.CharacteristicProperties;
import com.cdp4j.type.bluetoothemulation.DescriptorOperationType;
import com.cdp4j.type.bluetoothemulation.GATTOperationType;
import com.cdp4j.type.bluetoothemulation.ManufacturerData;
import com.cdp4j.type.bluetoothemulation.ScanEntry;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class BluetoothEmulationAsyncImpl
extends ParameterizedCommandImpl<BluetoothEmulationAsync>
implements BluetoothEmulationAsync {
    private static final CommandReturnType CRT_ADD_CHARACTERISTIC = new CommandReturnType("characteristicId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_ADD_DESCRIPTOR = new CommandReturnType("descriptorId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_ADD_SERVICE = new CommandReturnType("serviceId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_DISABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ENABLE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_REMOVE_CHARACTERISTIC = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_REMOVE_DESCRIPTOR = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_REMOVE_SERVICE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_SIMULATED_CENTRAL_STATE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_ADVERTISEMENT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_GA_TT_DISCONNECTION = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_GA_TT_OPERATION_RESPONSE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SIMULATE_PRECONNECTED_PERIPHERAL = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_ADD_CHARACTERISTIC_1 = new String[]{"serviceId", "characteristicUuid", "properties"};
    private static final String[] PARAMS_ADD_DESCRIPTOR_1 = new String[]{"characteristicId", "descriptorUuid"};
    private static final String[] PARAMS_ADD_SERVICE_1 = new String[]{"address", "serviceUuid"};
    private static final String[] PARAMS_ENABLE_1 = new String[]{"state", "leSupported"};
    private static final String[] PARAMS_REMOVE_CHARACTERISTIC_1 = new String[]{"characteristicId"};
    private static final String[] PARAMS_REMOVE_DESCRIPTOR_1 = new String[]{"descriptorId"};
    private static final String[] PARAMS_REMOVE_SERVICE_1 = new String[]{"serviceId"};
    private static final String[] PARAMS_SET_SIMULATED_CENTRAL_STATE_1 = new String[]{"state"};
    private static final String[] PARAMS_SIMULATE_ADVERTISEMENT_1 = new String[]{"entry"};
    private static final String[] PARAMS_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE_1 = new String[]{"characteristicId", "type", "code"};
    private static final String[] PARAMS_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE_2 = new String[]{"characteristicId", "type", "code", "data"};
    private static final String[] PARAMS_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE_1 = new String[]{"descriptorId", "type", "code"};
    private static final String[] PARAMS_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE_2 = new String[]{"descriptorId", "type", "code", "data"};
    private static final String[] PARAMS_SIMULATE_GA_TT_DISCONNECTION_1 = new String[]{"address"};
    private static final String[] PARAMS_SIMULATE_GA_TT_OPERATION_RESPONSE_1 = new String[]{"address", "type", "code"};
    private static final String[] PARAMS_SIMULATE_PRECONNECTED_PERIPHERAL_1 = new String[]{"address", "name", "manufacturerData", "knownServiceUuids"};
    private final SessionInvocationHandler handler;

    public BluetoothEmulationAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<String> addCharacteristic(String serviceId, String characteristicUuid, CharacteristicProperties properties) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_addCharacteristic, CRT_ADD_CHARACTERISTIC, PARAMS_ADD_CHARACTERISTIC_1, new Object[]{serviceId, characteristicUuid, properties}, false);
    }

    @Override
    public CompletableFuture<String> addDescriptor(String characteristicId, String descriptorUuid) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_addDescriptor, CRT_ADD_DESCRIPTOR, PARAMS_ADD_DESCRIPTOR_1, new Object[]{characteristicId, descriptorUuid}, false);
    }

    @Override
    public CompletableFuture<String> addService(String address, String serviceUuid) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_addService, CRT_ADD_SERVICE, PARAMS_ADD_SERVICE_1, new Object[]{address, serviceUuid}, false);
    }

    @Override
    public CompletableFuture<Void> disable() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_disable, CRT_DISABLE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> enable(CentralState state, Boolean leSupported) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_enable, CRT_ENABLE, PARAMS_ENABLE_1, new Object[]{state, leSupported}, false);
    }

    @Override
    public CompletableFuture<Void> removeCharacteristic(String characteristicId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_removeCharacteristic, CRT_REMOVE_CHARACTERISTIC, PARAMS_REMOVE_CHARACTERISTIC_1, new Object[]{characteristicId}, false);
    }

    @Override
    public CompletableFuture<Void> removeDescriptor(String descriptorId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_removeDescriptor, CRT_REMOVE_DESCRIPTOR, PARAMS_REMOVE_DESCRIPTOR_1, new Object[]{descriptorId}, false);
    }

    @Override
    public CompletableFuture<Void> removeService(String serviceId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_removeService, CRT_REMOVE_SERVICE, PARAMS_REMOVE_SERVICE_1, new Object[]{serviceId}, false);
    }

    @Override
    public CompletableFuture<Void> setSimulatedCentralState(CentralState state) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_setSimulatedCentralState, CRT_SET_SIMULATED_CENTRAL_STATE, PARAMS_SET_SIMULATED_CENTRAL_STATE_1, new Object[]{state}, false);
    }

    @Override
    public CompletableFuture<Void> simulateAdvertisement(ScanEntry entry) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateAdvertisement, CRT_SIMULATE_ADVERTISEMENT, PARAMS_SIMULATE_ADVERTISEMENT_1, new Object[]{entry}, false);
    }

    @Override
    public CompletableFuture<Void> simulateCharacteristicOperationResponse(String characteristicId, CharacteristicOperationType type, Integer code) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateCharacteristicOperationResponse, CRT_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE, PARAMS_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE_1, new Object[]{characteristicId, type, code}, false);
    }

    @Override
    public CompletableFuture<Void> simulateCharacteristicOperationResponse(String characteristicId, CharacteristicOperationType type, Integer code, String data) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateCharacteristicOperationResponse, CRT_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE, PARAMS_SIMULATE_CHARACTERISTIC_OPERATION_RESPONSE_2, new Object[]{characteristicId, type, code, data}, false);
    }

    @Override
    public CompletableFuture<Void> simulateDescriptorOperationResponse(String descriptorId, DescriptorOperationType type, Integer code) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateDescriptorOperationResponse, CRT_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE, PARAMS_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE_1, new Object[]{descriptorId, type, code}, false);
    }

    @Override
    public CompletableFuture<Void> simulateDescriptorOperationResponse(String descriptorId, DescriptorOperationType type, Integer code, String data) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateDescriptorOperationResponse, CRT_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE, PARAMS_SIMULATE_DESCRIPTOR_OPERATION_RESPONSE_2, new Object[]{descriptorId, type, code, data}, false);
    }

    @Override
    public CompletableFuture<Void> simulateGATTDisconnection(String address) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateGATTDisconnection, CRT_SIMULATE_GA_TT_DISCONNECTION, PARAMS_SIMULATE_GA_TT_DISCONNECTION_1, new Object[]{address}, false);
    }

    @Override
    public CompletableFuture<Void> simulateGATTOperationResponse(String address, GATTOperationType type, Integer code) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulateGATTOperationResponse, CRT_SIMULATE_GA_TT_OPERATION_RESPONSE, PARAMS_SIMULATE_GA_TT_OPERATION_RESPONSE_1, new Object[]{address, type, code}, false);
    }

    @Override
    public CompletableFuture<Void> simulatePreconnectedPeripheral(String address, String name, List<ManufacturerData> manufacturerData, List<String> knownServiceUuids) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.BluetoothEmulation_simulatePreconnectedPeripheral, CRT_SIMULATE_PRECONNECTED_PERIPHERAL, PARAMS_SIMULATE_PRECONNECTED_PERIPHERAL_1, new Object[]{address, name, manufacturerData, knownServiceUuids}, false);
    }
}

