/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.command;

import com.cdp4j.TypeReference;
import com.cdp4j.command.BrowserAsync;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.DomainCommand;
import com.cdp4j.session.ParameterizedCommandImpl;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.type.browser.Bounds;
import com.cdp4j.type.browser.BrowserCommandId;
import com.cdp4j.type.browser.GetVersionResult;
import com.cdp4j.type.browser.GetWindowForTargetResult;
import com.cdp4j.type.browser.Histogram;
import com.cdp4j.type.browser.PermissionDescriptor;
import com.cdp4j.type.browser.PermissionSetting;
import com.cdp4j.type.browser.PermissionType;
import com.cdp4j.type.browser.PrivacySandboxAPI;
import com.cdp4j.type.constant.DownloadBehavior;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class BrowserAsyncImpl
extends ParameterizedCommandImpl<BrowserAsync>
implements BrowserAsync {
    private static final TypeReference<List<Histogram>> LIST_HISTOGRAM = new TypeReference<List<Histogram>>(){};
    private static final TypeReference<List<String>> LIST_STRING = new TypeReference<List<String>>(){};
    private static final CommandReturnType CRT_ADD_PRIVACY_SANDBOX_COORDINATOR_KEY_CONFIG = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ADD_PRIVACY_SANDBOX_ENROLLMENT_OVERRIDE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CANCEL_DOWNLOAD = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLOSE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CRASH = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CRASH_GPU_PROCESS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_EXECUTE_BROWSER_COMMAND = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_BROWSER_COMMAND_LINE = new CommandReturnType("arguments", (Type)((Object)List.class), LIST_STRING);
    private static final CommandReturnType CRT_GET_HISTOGRAM = new CommandReturnType("histogram", (Type)((Object)Histogram.class), null);
    private static final CommandReturnType CRT_GET_HISTOGRAMS = new CommandReturnType("histograms", (Type)((Object)List.class), LIST_HISTOGRAM);
    private static final CommandReturnType CRT_GET_VERSION = new CommandReturnType(null, (Type)((Object)GetVersionResult.class), null);
    private static final CommandReturnType CRT_GET_WINDOW_BOUNDS = new CommandReturnType("bounds", (Type)((Object)Bounds.class), null);
    private static final CommandReturnType CRT_GET_WINDOW_FOR_TARGET = new CommandReturnType(null, (Type)((Object)GetWindowForTargetResult.class), null);
    private static final CommandReturnType CRT_GRANT_PERMISSIONS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_RESET_PERMISSIONS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_CONTENTS_SIZE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_DOCK_TILE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_DOWNLOAD_BEHAVIOR = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_PERMISSION = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_WINDOW_BOUNDS = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_ADD_PRIVACY_SANDBOX_COORDINATOR_KEY_CONFIG_1 = new String[]{"api", "coordinatorOrigin", "keyConfig"};
    private static final String[] PARAMS_ADD_PRIVACY_SANDBOX_COORDINATOR_KEY_CONFIG_2 = new String[]{"api", "coordinatorOrigin", "keyConfig", "browserContextId"};
    private static final String[] PARAMS_ADD_PRIVACY_SANDBOX_ENROLLMENT_OVERRIDE_1 = new String[]{"url"};
    private static final String[] PARAMS_CANCEL_DOWNLOAD_1 = new String[]{"guid"};
    private static final String[] PARAMS_CANCEL_DOWNLOAD_2 = new String[]{"guid", "browserContextId"};
    private static final String[] PARAMS_EXECUTE_BROWSER_COMMAND_1 = new String[]{"commandId"};
    private static final String[] PARAMS_GET_HISTOGRAMS_2 = new String[]{"query", "delta"};
    private static final String[] PARAMS_GET_HISTOGRAM_1 = new String[]{"name"};
    private static final String[] PARAMS_GET_HISTOGRAM_2 = new String[]{"name", "delta"};
    private static final String[] PARAMS_GET_WINDOW_BOUNDS_1 = new String[]{"windowId"};
    private static final String[] PARAMS_GET_WINDOW_FOR_TARGET_2 = new String[]{"targetId"};
    private static final String[] PARAMS_GRANT_PERMISSIONS_1 = new String[]{"permissions"};
    private static final String[] PARAMS_GRANT_PERMISSIONS_2 = new String[]{"permissions", "origin", "browserContextId"};
    private static final String[] PARAMS_RESET_PERMISSIONS_2 = new String[]{"browserContextId"};
    private static final String[] PARAMS_SET_CONTENTS_SIZE_1 = new String[]{"windowId"};
    private static final String[] PARAMS_SET_CONTENTS_SIZE_2 = new String[]{"windowId", "width", "height"};
    private static final String[] PARAMS_SET_DOCK_TILE_2 = new String[]{"badgeLabel", "image"};
    private static final String[] PARAMS_SET_DOWNLOAD_BEHAVIOR_1 = new String[]{"behavior"};
    private static final String[] PARAMS_SET_DOWNLOAD_BEHAVIOR_2 = new String[]{"behavior", "browserContextId", "downloadPath", "eventsEnabled"};
    private static final String[] PARAMS_SET_PERMISSION_1 = new String[]{"permission", "setting"};
    private static final String[] PARAMS_SET_PERMISSION_2 = new String[]{"permission", "setting", "origin", "embeddedOrigin", "browserContextId"};
    private static final String[] PARAMS_SET_WINDOW_BOUNDS_1 = new String[]{"windowId", "bounds"};
    private final SessionInvocationHandler handler;

    public BrowserAsyncImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public CompletableFuture<Void> addPrivacySandboxCoordinatorKeyConfig(PrivacySandboxAPI api, String coordinatorOrigin, String keyConfig) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_addPrivacySandboxCoordinatorKeyConfig, CRT_ADD_PRIVACY_SANDBOX_COORDINATOR_KEY_CONFIG, PARAMS_ADD_PRIVACY_SANDBOX_COORDINATOR_KEY_CONFIG_1, new Object[]{api, coordinatorOrigin, keyConfig}, false);
    }

    @Override
    public CompletableFuture<Void> addPrivacySandboxCoordinatorKeyConfig(PrivacySandboxAPI api, String coordinatorOrigin, String keyConfig, String browserContextId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_addPrivacySandboxCoordinatorKeyConfig, CRT_ADD_PRIVACY_SANDBOX_COORDINATOR_KEY_CONFIG, PARAMS_ADD_PRIVACY_SANDBOX_COORDINATOR_KEY_CONFIG_2, new Object[]{api, coordinatorOrigin, keyConfig, browserContextId}, false);
    }

    @Override
    public CompletableFuture<Void> addPrivacySandboxEnrollmentOverride(String url) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_addPrivacySandboxEnrollmentOverride, CRT_ADD_PRIVACY_SANDBOX_ENROLLMENT_OVERRIDE, PARAMS_ADD_PRIVACY_SANDBOX_ENROLLMENT_OVERRIDE_1, new Object[]{url}, false);
    }

    @Override
    public CompletableFuture<Void> cancelDownload(String guid) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_cancelDownload, CRT_CANCEL_DOWNLOAD, PARAMS_CANCEL_DOWNLOAD_1, new Object[]{guid}, false);
    }

    @Override
    public CompletableFuture<Void> cancelDownload(String guid, String browserContextId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_cancelDownload, CRT_CANCEL_DOWNLOAD, PARAMS_CANCEL_DOWNLOAD_2, new Object[]{guid, browserContextId}, false);
    }

    @Override
    public CompletableFuture<Void> close() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_close, CRT_CLOSE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> crash() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_crash, CRT_CRASH, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> crashGpuProcess() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_crashGpuProcess, CRT_CRASH_GPU_PROCESS, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> executeBrowserCommand(BrowserCommandId commandId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_executeBrowserCommand, CRT_EXECUTE_BROWSER_COMMAND, PARAMS_EXECUTE_BROWSER_COMMAND_1, new Object[]{commandId}, false);
    }

    @Override
    public CompletableFuture<List<String>> getBrowserCommandLine() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_getBrowserCommandLine, CRT_GET_BROWSER_COMMAND_LINE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Histogram> getHistogram(String name) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_getHistogram, CRT_GET_HISTOGRAM, PARAMS_GET_HISTOGRAM_1, new Object[]{name}, false);
    }

    @Override
    public CompletableFuture<Histogram> getHistogram(String name, Boolean delta) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_getHistogram, CRT_GET_HISTOGRAM, PARAMS_GET_HISTOGRAM_2, new Object[]{name, delta}, false);
    }

    @Override
    public CompletableFuture<List<Histogram>> getHistograms() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_getHistograms, CRT_GET_HISTOGRAMS, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<List<Histogram>> getHistograms(String query, Boolean delta) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_getHistograms, CRT_GET_HISTOGRAMS, PARAMS_GET_HISTOGRAMS_2, new Object[]{query, delta}, false);
    }

    @Override
    public CompletableFuture<GetVersionResult> getVersion() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_getVersion, CRT_GET_VERSION, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Bounds> getWindowBounds(Integer windowId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_getWindowBounds, CRT_GET_WINDOW_BOUNDS, PARAMS_GET_WINDOW_BOUNDS_1, new Object[]{windowId}, false);
    }

    @Override
    public CompletableFuture<GetWindowForTargetResult> getWindowForTarget() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_getWindowForTarget, CRT_GET_WINDOW_FOR_TARGET, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<GetWindowForTargetResult> getWindowForTarget(String targetId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_getWindowForTarget, CRT_GET_WINDOW_FOR_TARGET, PARAMS_GET_WINDOW_FOR_TARGET_2, new Object[]{targetId}, false);
    }

    @Override
    public CompletableFuture<Void> grantPermissions(PermissionType permissions) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_grantPermissions, CRT_GRANT_PERMISSIONS, PARAMS_GRANT_PERMISSIONS_1, new Object[]{permissions}, false);
    }

    @Override
    public CompletableFuture<Void> grantPermissions(PermissionType permissions, String origin, String browserContextId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_grantPermissions, CRT_GRANT_PERMISSIONS, PARAMS_GRANT_PERMISSIONS_2, new Object[]{permissions, origin, browserContextId}, false);
    }

    @Override
    public CompletableFuture<Void> resetPermissions() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_resetPermissions, CRT_RESET_PERMISSIONS, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> resetPermissions(String browserContextId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_resetPermissions, CRT_RESET_PERMISSIONS, PARAMS_RESET_PERMISSIONS_2, new Object[]{browserContextId}, false);
    }

    @Override
    public CompletableFuture<Void> setContentsSize(Integer windowId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_setContentsSize, CRT_SET_CONTENTS_SIZE, PARAMS_SET_CONTENTS_SIZE_1, new Object[]{windowId}, false);
    }

    @Override
    public CompletableFuture<Void> setContentsSize(Integer windowId, Integer width, Integer height) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_setContentsSize, CRT_SET_CONTENTS_SIZE, PARAMS_SET_CONTENTS_SIZE_2, new Object[]{windowId, width, height}, false);
    }

    @Override
    public CompletableFuture<Void> setDockTile() {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_setDockTile, CRT_SET_DOCK_TILE, EMPTY_ARGS, EMPTY_VALUES, false);
    }

    @Override
    public CompletableFuture<Void> setDockTile(String badgeLabel, String image) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_setDockTile, CRT_SET_DOCK_TILE, PARAMS_SET_DOCK_TILE_2, new Object[]{badgeLabel, image}, false);
    }

    @Override
    public CompletableFuture<Void> setDownloadBehavior(DownloadBehavior behavior) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_setDownloadBehavior, CRT_SET_DOWNLOAD_BEHAVIOR, PARAMS_SET_DOWNLOAD_BEHAVIOR_1, new Object[]{behavior}, false);
    }

    @Override
    public CompletableFuture<Void> setDownloadBehavior(DownloadBehavior behavior, String browserContextId, String downloadPath, Boolean eventsEnabled) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_setDownloadBehavior, CRT_SET_DOWNLOAD_BEHAVIOR, PARAMS_SET_DOWNLOAD_BEHAVIOR_2, new Object[]{behavior, browserContextId, downloadPath, eventsEnabled}, false);
    }

    @Override
    public CompletableFuture<Void> setPermission(PermissionDescriptor permission, PermissionSetting setting) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_setPermission, CRT_SET_PERMISSION, PARAMS_SET_PERMISSION_1, new Object[]{permission, setting}, false);
    }

    @Override
    public CompletableFuture<Void> setPermission(PermissionDescriptor permission, PermissionSetting setting, String origin, String embeddedOrigin, String browserContextId) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_setPermission, CRT_SET_PERMISSION, PARAMS_SET_PERMISSION_2, new Object[]{permission, setting, origin, embeddedOrigin, browserContextId}, false);
    }

    @Override
    public CompletableFuture<Void> setWindowBounds(Integer windowId, Bounds bounds) {
        return (CompletableFuture)this.handler.invoke(this, DomainCommand.Browser_setWindowBounds, CRT_SET_WINDOW_BOUNDS, PARAMS_SET_WINDOW_BOUNDS_1, new Object[]{windowId, bounds}, false);
    }
}

