/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.command;

import com.cdp4j.TypeReference;
import com.cdp4j.command.Storage;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.DomainCommand;
import com.cdp4j.session.ParameterizedCommandImpl;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.type.network.Cookie;
import com.cdp4j.type.network.CookieParam;
import com.cdp4j.type.storage.GetUsageAndQuotaResult;
import com.cdp4j.type.storage.RelatedWebsiteSet;
import com.cdp4j.type.storage.SharedStorageEntry;
import com.cdp4j.type.storage.SharedStorageMetadata;
import com.cdp4j.type.storage.StorageBucket;
import com.cdp4j.type.storage.TrustTokens;
import java.lang.reflect.Type;
import java.util.List;

class StorageImpl
extends ParameterizedCommandImpl<Storage>
implements Storage {
    private static final TypeReference<List<Cookie>> LIST_COOKIE = new TypeReference<List<Cookie>>(){};
    private static final TypeReference<List<RelatedWebsiteSet>> LIST_RELATEDWEBSITESET = new TypeReference<List<RelatedWebsiteSet>>(){};
    private static final TypeReference<List<SharedStorageEntry>> LIST_SHAREDSTORAGEENTRY = new TypeReference<List<SharedStorageEntry>>(){};
    private static final TypeReference<List<String>> LIST_STRING = new TypeReference<List<String>>(){};
    private static final TypeReference<List<TrustTokens>> LIST_TRUSTTOKENS = new TypeReference<List<TrustTokens>>(){};
    private static final CommandReturnType CRT_CLEAR_COOKIES = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLEAR_DATA_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLEAR_DATA_FOR_STORAGE_KEY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLEAR_SHARED_STORAGE_ENTRIES = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLEAR_TRUST_TOKENS = new CommandReturnType("didDeleteTokens", (Type)((Object)Boolean.class), null);
    private static final CommandReturnType CRT_DELETE_SHARED_STORAGE_ENTRY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DELETE_STORAGE_BUCKET = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_AFFECTED_URLS_FOR_THIRD_PARTY_COOKIE_METADATA = new CommandReturnType("matchedUrls", (Type)((Object)List.class), LIST_STRING);
    private static final CommandReturnType CRT_GET_COOKIES = new CommandReturnType("cookies", (Type)((Object)List.class), LIST_COOKIE);
    private static final CommandReturnType CRT_GET_RELATED_WEBSITE_SETS = new CommandReturnType("sets", (Type)((Object)List.class), LIST_RELATEDWEBSITESET);
    private static final CommandReturnType CRT_GET_SHARED_STORAGE_ENTRIES = new CommandReturnType("entries", (Type)((Object)List.class), LIST_SHAREDSTORAGEENTRY);
    private static final CommandReturnType CRT_GET_SHARED_STORAGE_METADATA = new CommandReturnType("metadata", (Type)((Object)SharedStorageMetadata.class), null);
    private static final CommandReturnType CRT_GET_STORAGE_KEY = new CommandReturnType("storageKey", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_GET_STORAGE_KEY_FOR_FRAME = new CommandReturnType("storageKey", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_GET_TRUST_TOKENS = new CommandReturnType("tokens", (Type)((Object)List.class), LIST_TRUSTTOKENS);
    private static final CommandReturnType CRT_GET_USAGE_AND_QUOTA = new CommandReturnType(null, (Type)((Object)GetUsageAndQuotaResult.class), null);
    private static final CommandReturnType CRT_OVERRIDE_QUOTA_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_RESET_SHARED_STORAGE_BUDGET = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_RUN_BOUNCE_TRACKING_MITIGATIONS = new CommandReturnType("deletedSites", (Type)((Object)List.class), LIST_STRING);
    private static final CommandReturnType CRT_SEND_PENDING_ATTRIBUTION_REPORTS = new CommandReturnType("numSent", (Type)((Object)Integer.class), null);
    private static final CommandReturnType CRT_SET_ATTRIBUTION_REPORTING_LOCAL_TESTING_MODE = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_ATTRIBUTION_REPORTING_TRACKING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_COOKIES = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_INTEREST_GROUP_AUCTION_TRACKING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_INTEREST_GROUP_TRACKING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_PROTECTED_AUDIENCE_KANONYMITY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_SHARED_STORAGE_ENTRY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_SHARED_STORAGE_TRACKING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_STORAGE_BUCKET_TRACKING = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TRACK_CACHE_STORAGE_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TRACK_CACHE_STORAGE_FOR_STORAGE_KEY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TRACK_INDEXED_DB_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_TRACK_INDEXED_DB_FOR_STORAGE_KEY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_UNTRACK_CACHE_STORAGE_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_UNTRACK_CACHE_STORAGE_FOR_STORAGE_KEY = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_UNTRACK_INDEXED_DB_FOR_ORIGIN = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_UNTRACK_INDEXED_DB_FOR_STORAGE_KEY = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_CLEAR_COOKIES_2 = new String[]{"browserContextId"};
    private static final String[] PARAMS_CLEAR_DATA_FOR_ORIGIN_1 = new String[]{"origin", "storageTypes"};
    private static final String[] PARAMS_CLEAR_DATA_FOR_STORAGE_KEY_1 = new String[]{"storageKey", "storageTypes"};
    private static final String[] PARAMS_CLEAR_SHARED_STORAGE_ENTRIES_1 = new String[]{"ownerOrigin"};
    private static final String[] PARAMS_CLEAR_TRUST_TOKENS_1 = new String[]{"issuerOrigin"};
    private static final String[] PARAMS_DELETE_SHARED_STORAGE_ENTRY_1 = new String[]{"ownerOrigin", "key"};
    private static final String[] PARAMS_DELETE_STORAGE_BUCKET_1 = new String[]{"bucket"};
    private static final String[] PARAMS_GET_AFFECTED_URLS_FOR_THIRD_PARTY_COOKIE_METADATA_1 = new String[]{"firstPartyUrl", "thirdPartyUrls"};
    private static final String[] PARAMS_GET_COOKIES_2 = new String[]{"browserContextId"};
    private static final String[] PARAMS_GET_SHARED_STORAGE_ENTRIES_1 = new String[]{"ownerOrigin"};
    private static final String[] PARAMS_GET_SHARED_STORAGE_METADATA_1 = new String[]{"ownerOrigin"};
    private static final String[] PARAMS_GET_STORAGE_KEY_2 = new String[]{"frameId"};
    private static final String[] PARAMS_GET_STORAGE_KEY_FOR_FRAME_1 = new String[]{"frameId"};
    private static final String[] PARAMS_GET_USAGE_AND_QUOTA_1 = new String[]{"origin"};
    private static final String[] PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_2 = new String[]{"origin", "quotaSize"};
    private static final String[] PARAMS_RESET_SHARED_STORAGE_BUDGET_1 = new String[]{"ownerOrigin"};
    private static final String[] PARAMS_SET_ATTRIBUTION_REPORTING_LOCAL_TESTING_MODE_1 = new String[]{"enabled"};
    private static final String[] PARAMS_SET_ATTRIBUTION_REPORTING_TRACKING_1 = new String[]{"enable"};
    private static final String[] PARAMS_SET_COOKIES_1 = new String[]{"cookies"};
    private static final String[] PARAMS_SET_COOKIES_2 = new String[]{"cookies", "browserContextId"};
    private static final String[] PARAMS_SET_INTEREST_GROUP_AUCTION_TRACKING_1 = new String[]{"enable"};
    private static final String[] PARAMS_SET_INTEREST_GROUP_TRACKING_1 = new String[]{"enable"};
    private static final String[] PARAMS_SET_PROTECTED_AUDIENCE_KANONYMITY_1 = new String[]{"owner", "name", "hashes"};
    private static final String[] PARAMS_SET_SHARED_STORAGE_ENTRY_1 = new String[]{"ownerOrigin", "key", "value"};
    private static final String[] PARAMS_SET_SHARED_STORAGE_ENTRY_2 = new String[]{"ownerOrigin", "key", "value", "ignoreIfPresent"};
    private static final String[] PARAMS_SET_SHARED_STORAGE_TRACKING_1 = new String[]{"enable"};
    private static final String[] PARAMS_SET_STORAGE_BUCKET_TRACKING_1 = new String[]{"storageKey", "enable"};
    private static final String[] PARAMS_TRACK_CACHE_STORAGE_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_TRACK_CACHE_STORAGE_FOR_STORAGE_KEY_1 = new String[]{"storageKey"};
    private static final String[] PARAMS_TRACK_INDEXED_DB_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_TRACK_INDEXED_DB_FOR_STORAGE_KEY_1 = new String[]{"storageKey"};
    private static final String[] PARAMS_UNTRACK_CACHE_STORAGE_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_UNTRACK_CACHE_STORAGE_FOR_STORAGE_KEY_1 = new String[]{"storageKey"};
    private static final String[] PARAMS_UNTRACK_INDEXED_DB_FOR_ORIGIN_1 = new String[]{"origin"};
    private static final String[] PARAMS_UNTRACK_INDEXED_DB_FOR_STORAGE_KEY_1 = new String[]{"storageKey"};
    private final SessionInvocationHandler handler;

    public StorageImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void clearCookies() {
        this.handler.invoke(this, DomainCommand.Storage_clearCookies, CRT_CLEAR_COOKIES, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void clearCookies(String browserContextId) {
        this.handler.invoke(this, DomainCommand.Storage_clearCookies, CRT_CLEAR_COOKIES, PARAMS_CLEAR_COOKIES_2, new Object[]{browserContextId}, true);
    }

    @Override
    public void clearDataForOrigin(String origin, String storageTypes) {
        this.handler.invoke(this, DomainCommand.Storage_clearDataForOrigin, CRT_CLEAR_DATA_FOR_ORIGIN, PARAMS_CLEAR_DATA_FOR_ORIGIN_1, new Object[]{origin, storageTypes}, true);
    }

    @Override
    public void clearDataForStorageKey(String storageKey, String storageTypes) {
        this.handler.invoke(this, DomainCommand.Storage_clearDataForStorageKey, CRT_CLEAR_DATA_FOR_STORAGE_KEY, PARAMS_CLEAR_DATA_FOR_STORAGE_KEY_1, new Object[]{storageKey, storageTypes}, true);
    }

    @Override
    public void clearSharedStorageEntries(String ownerOrigin) {
        this.handler.invoke(this, DomainCommand.Storage_clearSharedStorageEntries, CRT_CLEAR_SHARED_STORAGE_ENTRIES, PARAMS_CLEAR_SHARED_STORAGE_ENTRIES_1, new Object[]{ownerOrigin}, true);
    }

    @Override
    public Boolean clearTrustTokens(String issuerOrigin) {
        return (Boolean)this.handler.invoke(this, DomainCommand.Storage_clearTrustTokens, CRT_CLEAR_TRUST_TOKENS, PARAMS_CLEAR_TRUST_TOKENS_1, new Object[]{issuerOrigin}, true);
    }

    @Override
    public void deleteSharedStorageEntry(String ownerOrigin, String key) {
        this.handler.invoke(this, DomainCommand.Storage_deleteSharedStorageEntry, CRT_DELETE_SHARED_STORAGE_ENTRY, PARAMS_DELETE_SHARED_STORAGE_ENTRY_1, new Object[]{ownerOrigin, key}, true);
    }

    @Override
    public void deleteStorageBucket(StorageBucket bucket) {
        this.handler.invoke(this, DomainCommand.Storage_deleteStorageBucket, CRT_DELETE_STORAGE_BUCKET, PARAMS_DELETE_STORAGE_BUCKET_1, new Object[]{bucket}, true);
    }

    @Override
    public List<String> getAffectedUrlsForThirdPartyCookieMetadata(String firstPartyUrl, List<String> thirdPartyUrls) {
        return (List)this.handler.invoke(this, DomainCommand.Storage_getAffectedUrlsForThirdPartyCookieMetadata, CRT_GET_AFFECTED_URLS_FOR_THIRD_PARTY_COOKIE_METADATA, PARAMS_GET_AFFECTED_URLS_FOR_THIRD_PARTY_COOKIE_METADATA_1, new Object[]{firstPartyUrl, thirdPartyUrls}, true);
    }

    @Override
    public List<Cookie> getCookies() {
        return (List)this.handler.invoke(this, DomainCommand.Storage_getCookies, CRT_GET_COOKIES, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public List<Cookie> getCookies(String browserContextId) {
        return (List)this.handler.invoke(this, DomainCommand.Storage_getCookies, CRT_GET_COOKIES, PARAMS_GET_COOKIES_2, new Object[]{browserContextId}, true);
    }

    @Override
    public List<RelatedWebsiteSet> getRelatedWebsiteSets() {
        return (List)this.handler.invoke(this, DomainCommand.Storage_getRelatedWebsiteSets, CRT_GET_RELATED_WEBSITE_SETS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public List<SharedStorageEntry> getSharedStorageEntries(String ownerOrigin) {
        return (List)this.handler.invoke(this, DomainCommand.Storage_getSharedStorageEntries, CRT_GET_SHARED_STORAGE_ENTRIES, PARAMS_GET_SHARED_STORAGE_ENTRIES_1, new Object[]{ownerOrigin}, true);
    }

    @Override
    public SharedStorageMetadata getSharedStorageMetadata(String ownerOrigin) {
        return (SharedStorageMetadata)this.handler.invoke(this, DomainCommand.Storage_getSharedStorageMetadata, CRT_GET_SHARED_STORAGE_METADATA, PARAMS_GET_SHARED_STORAGE_METADATA_1, new Object[]{ownerOrigin}, true);
    }

    @Override
    public String getStorageKey() {
        return (String)this.handler.invoke(this, DomainCommand.Storage_getStorageKey, CRT_GET_STORAGE_KEY, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public String getStorageKey(String frameId) {
        return (String)this.handler.invoke(this, DomainCommand.Storage_getStorageKey, CRT_GET_STORAGE_KEY, PARAMS_GET_STORAGE_KEY_2, new Object[]{frameId}, true);
    }

    @Override
    public String getStorageKeyForFrame(String frameId) {
        return (String)this.handler.invoke(this, DomainCommand.Storage_getStorageKeyForFrame, CRT_GET_STORAGE_KEY_FOR_FRAME, PARAMS_GET_STORAGE_KEY_FOR_FRAME_1, new Object[]{frameId}, true);
    }

    @Override
    public List<TrustTokens> getTrustTokens() {
        return (List)this.handler.invoke(this, DomainCommand.Storage_getTrustTokens, CRT_GET_TRUST_TOKENS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public GetUsageAndQuotaResult getUsageAndQuota(String origin) {
        return (GetUsageAndQuotaResult)this.handler.invoke(this, DomainCommand.Storage_getUsageAndQuota, CRT_GET_USAGE_AND_QUOTA, PARAMS_GET_USAGE_AND_QUOTA_1, new Object[]{origin}, true);
    }

    @Override
    public void overrideQuotaForOrigin(String origin) {
        this.handler.invoke(this, DomainCommand.Storage_overrideQuotaForOrigin, CRT_OVERRIDE_QUOTA_FOR_ORIGIN, PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_1, new Object[]{origin}, true);
    }

    @Override
    public void overrideQuotaForOrigin(String origin, Double quotaSize) {
        this.handler.invoke(this, DomainCommand.Storage_overrideQuotaForOrigin, CRT_OVERRIDE_QUOTA_FOR_ORIGIN, PARAMS_OVERRIDE_QUOTA_FOR_ORIGIN_2, new Object[]{origin, quotaSize}, true);
    }

    @Override
    public void resetSharedStorageBudget(String ownerOrigin) {
        this.handler.invoke(this, DomainCommand.Storage_resetSharedStorageBudget, CRT_RESET_SHARED_STORAGE_BUDGET, PARAMS_RESET_SHARED_STORAGE_BUDGET_1, new Object[]{ownerOrigin}, true);
    }

    @Override
    public List<String> runBounceTrackingMitigations() {
        return (List)this.handler.invoke(this, DomainCommand.Storage_runBounceTrackingMitigations, CRT_RUN_BOUNCE_TRACKING_MITIGATIONS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public Integer sendPendingAttributionReports() {
        return (Integer)this.handler.invoke(this, DomainCommand.Storage_sendPendingAttributionReports, CRT_SEND_PENDING_ATTRIBUTION_REPORTS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void setAttributionReportingLocalTestingMode(Boolean enabled) {
        this.handler.invoke(this, DomainCommand.Storage_setAttributionReportingLocalTestingMode, CRT_SET_ATTRIBUTION_REPORTING_LOCAL_TESTING_MODE, PARAMS_SET_ATTRIBUTION_REPORTING_LOCAL_TESTING_MODE_1, new Object[]{enabled}, true);
    }

    @Override
    public void setAttributionReportingTracking(Boolean enable) {
        this.handler.invoke(this, DomainCommand.Storage_setAttributionReportingTracking, CRT_SET_ATTRIBUTION_REPORTING_TRACKING, PARAMS_SET_ATTRIBUTION_REPORTING_TRACKING_1, new Object[]{enable}, true);
    }

    @Override
    public void setCookies(List<CookieParam> cookies) {
        this.handler.invoke(this, DomainCommand.Storage_setCookies, CRT_SET_COOKIES, PARAMS_SET_COOKIES_1, new Object[]{cookies}, true);
    }

    @Override
    public void setCookies(List<CookieParam> cookies, String browserContextId) {
        this.handler.invoke(this, DomainCommand.Storage_setCookies, CRT_SET_COOKIES, PARAMS_SET_COOKIES_2, new Object[]{cookies, browserContextId}, true);
    }

    @Override
    public void setInterestGroupAuctionTracking(Boolean enable) {
        this.handler.invoke(this, DomainCommand.Storage_setInterestGroupAuctionTracking, CRT_SET_INTEREST_GROUP_AUCTION_TRACKING, PARAMS_SET_INTEREST_GROUP_AUCTION_TRACKING_1, new Object[]{enable}, true);
    }

    @Override
    public void setInterestGroupTracking(Boolean enable) {
        this.handler.invoke(this, DomainCommand.Storage_setInterestGroupTracking, CRT_SET_INTEREST_GROUP_TRACKING, PARAMS_SET_INTEREST_GROUP_TRACKING_1, new Object[]{enable}, true);
    }

    @Override
    public void setProtectedAudienceKAnonymity(String owner, String name, List<String> hashes) {
        this.handler.invoke(this, DomainCommand.Storage_setProtectedAudienceKAnonymity, CRT_SET_PROTECTED_AUDIENCE_KANONYMITY, PARAMS_SET_PROTECTED_AUDIENCE_KANONYMITY_1, new Object[]{owner, name, hashes}, true);
    }

    @Override
    public void setSharedStorageEntry(String ownerOrigin, String key, String value) {
        this.handler.invoke(this, DomainCommand.Storage_setSharedStorageEntry, CRT_SET_SHARED_STORAGE_ENTRY, PARAMS_SET_SHARED_STORAGE_ENTRY_1, new Object[]{ownerOrigin, key, value}, true);
    }

    @Override
    public void setSharedStorageEntry(String ownerOrigin, String key, String value, Boolean ignoreIfPresent) {
        this.handler.invoke(this, DomainCommand.Storage_setSharedStorageEntry, CRT_SET_SHARED_STORAGE_ENTRY, PARAMS_SET_SHARED_STORAGE_ENTRY_2, new Object[]{ownerOrigin, key, value, ignoreIfPresent}, true);
    }

    @Override
    public void setSharedStorageTracking(Boolean enable) {
        this.handler.invoke(this, DomainCommand.Storage_setSharedStorageTracking, CRT_SET_SHARED_STORAGE_TRACKING, PARAMS_SET_SHARED_STORAGE_TRACKING_1, new Object[]{enable}, true);
    }

    @Override
    public void setStorageBucketTracking(String storageKey, Boolean enable) {
        this.handler.invoke(this, DomainCommand.Storage_setStorageBucketTracking, CRT_SET_STORAGE_BUCKET_TRACKING, PARAMS_SET_STORAGE_BUCKET_TRACKING_1, new Object[]{storageKey, enable}, true);
    }

    @Override
    public void trackCacheStorageForOrigin(String origin) {
        this.handler.invoke(this, DomainCommand.Storage_trackCacheStorageForOrigin, CRT_TRACK_CACHE_STORAGE_FOR_ORIGIN, PARAMS_TRACK_CACHE_STORAGE_FOR_ORIGIN_1, new Object[]{origin}, true);
    }

    @Override
    public void trackCacheStorageForStorageKey(String storageKey) {
        this.handler.invoke(this, DomainCommand.Storage_trackCacheStorageForStorageKey, CRT_TRACK_CACHE_STORAGE_FOR_STORAGE_KEY, PARAMS_TRACK_CACHE_STORAGE_FOR_STORAGE_KEY_1, new Object[]{storageKey}, true);
    }

    @Override
    public void trackIndexedDBForOrigin(String origin) {
        this.handler.invoke(this, DomainCommand.Storage_trackIndexedDBForOrigin, CRT_TRACK_INDEXED_DB_FOR_ORIGIN, PARAMS_TRACK_INDEXED_DB_FOR_ORIGIN_1, new Object[]{origin}, true);
    }

    @Override
    public void trackIndexedDBForStorageKey(String storageKey) {
        this.handler.invoke(this, DomainCommand.Storage_trackIndexedDBForStorageKey, CRT_TRACK_INDEXED_DB_FOR_STORAGE_KEY, PARAMS_TRACK_INDEXED_DB_FOR_STORAGE_KEY_1, new Object[]{storageKey}, true);
    }

    @Override
    public void untrackCacheStorageForOrigin(String origin) {
        this.handler.invoke(this, DomainCommand.Storage_untrackCacheStorageForOrigin, CRT_UNTRACK_CACHE_STORAGE_FOR_ORIGIN, PARAMS_UNTRACK_CACHE_STORAGE_FOR_ORIGIN_1, new Object[]{origin}, true);
    }

    @Override
    public void untrackCacheStorageForStorageKey(String storageKey) {
        this.handler.invoke(this, DomainCommand.Storage_untrackCacheStorageForStorageKey, CRT_UNTRACK_CACHE_STORAGE_FOR_STORAGE_KEY, PARAMS_UNTRACK_CACHE_STORAGE_FOR_STORAGE_KEY_1, new Object[]{storageKey}, true);
    }

    @Override
    public void untrackIndexedDBForOrigin(String origin) {
        this.handler.invoke(this, DomainCommand.Storage_untrackIndexedDBForOrigin, CRT_UNTRACK_INDEXED_DB_FOR_ORIGIN, PARAMS_UNTRACK_INDEXED_DB_FOR_ORIGIN_1, new Object[]{origin}, true);
    }

    @Override
    public void untrackIndexedDBForStorageKey(String storageKey) {
        this.handler.invoke(this, DomainCommand.Storage_untrackIndexedDBForStorageKey, CRT_UNTRACK_INDEXED_DB_FOR_STORAGE_KEY, PARAMS_UNTRACK_INDEXED_DB_FOR_STORAGE_KEY_1, new Object[]{storageKey}, true);
    }
}

