/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.command;

import com.cdp4j.TypeReference;
import com.cdp4j.command.Target;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.DomainCommand;
import com.cdp4j.session.ParameterizedCommandImpl;
import com.cdp4j.session.SessionInvocationHandler;
import com.cdp4j.type.target.FilterEntry;
import com.cdp4j.type.target.GetBrowserContextsResult;
import com.cdp4j.type.target.RemoteLocation;
import com.cdp4j.type.target.TargetInfo;
import com.cdp4j.type.target.WindowState;
import java.lang.reflect.Type;
import java.util.List;

class TargetImpl
extends ParameterizedCommandImpl<Target>
implements Target {
    private static final TypeReference<List<TargetInfo>> LIST_TARGETINFO = new TypeReference<List<TargetInfo>>(){};
    private static final CommandReturnType CRT_ACTIVATE_TARGET = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_ATTACH_TO_BROWSER_TARGET = new CommandReturnType("sessionId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_ATTACH_TO_TARGET = new CommandReturnType("sessionId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_AUTO_ATTACH_RELATED = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_CLOSE_TARGET = new CommandReturnType("success", (Type)((Object)Boolean.class), null);
    private static final CommandReturnType CRT_CREATE_BROWSER_CONTEXT = new CommandReturnType("browserContextId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_CREATE_TARGET = new CommandReturnType("targetId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_DETACH_FROM_TARGET = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_DISPOSE_BROWSER_CONTEXT = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_EXPOSE_DEV_TOOLS_PROTOCOL = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_GET_BROWSER_CONTEXTS = new CommandReturnType(null, (Type)((Object)GetBrowserContextsResult.class), null);
    private static final CommandReturnType CRT_GET_DEV_TOOLS_TARGET = new CommandReturnType("targetId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_GET_TARGETS = new CommandReturnType("targetInfos", (Type)((Object)List.class), LIST_TARGETINFO);
    private static final CommandReturnType CRT_GET_TARGET_INFO = new CommandReturnType("targetInfo", (Type)((Object)TargetInfo.class), null);
    private static final CommandReturnType CRT_OPEN_DEV_TOOLS = new CommandReturnType("targetId", (Type)((Object)String.class), null);
    private static final CommandReturnType CRT_SEND_MESSAGE_TO_TARGET = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_AUTO_ATTACH = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_DISCOVER_TARGETS = new CommandReturnType(null, Void.TYPE, null);
    private static final CommandReturnType CRT_SET_REMOTE_LOCATIONS = new CommandReturnType(null, Void.TYPE, null);
    private static final String[] EMPTY_ARGS = new String[0];
    private static final Object[] EMPTY_VALUES = new Object[0];
    private static final String[] PARAMS_ACTIVATE_TARGET_1 = new String[]{"targetId"};
    private static final String[] PARAMS_ATTACH_TO_TARGET_1 = new String[]{"targetId"};
    private static final String[] PARAMS_ATTACH_TO_TARGET_2 = new String[]{"targetId", "flatten"};
    private static final String[] PARAMS_AUTO_ATTACH_RELATED_1 = new String[]{"targetId", "waitForDebuggerOnStart"};
    private static final String[] PARAMS_AUTO_ATTACH_RELATED_2 = new String[]{"targetId", "waitForDebuggerOnStart", "filter"};
    private static final String[] PARAMS_CLOSE_TARGET_1 = new String[]{"targetId"};
    private static final String[] PARAMS_CREATE_BROWSER_CONTEXT_2 = new String[]{"disposeOnDetach", "proxyServer", "proxyBypassList", "originsWithUniversalNetworkAccess"};
    private static final String[] PARAMS_CREATE_TARGET_1 = new String[]{"url"};
    private static final String[] PARAMS_CREATE_TARGET_2 = new String[]{"url", "left", "top", "width", "height", "windowState", "browserContextId", "enableBeginFrameControl", "newWindow", "background", "forTab", "hidden"};
    private static final String[] PARAMS_DETACH_FROM_TARGET_2 = new String[]{"sessionId", "targetId"};
    private static final String[] PARAMS_DISPOSE_BROWSER_CONTEXT_1 = new String[]{"browserContextId"};
    private static final String[] PARAMS_EXPOSE_DEV_TOOLS_PROTOCOL_1 = new String[]{"targetId"};
    private static final String[] PARAMS_EXPOSE_DEV_TOOLS_PROTOCOL_2 = new String[]{"targetId", "bindingName", "inheritPermissions"};
    private static final String[] PARAMS_GET_DEV_TOOLS_TARGET_1 = new String[]{"targetId"};
    private static final String[] PARAMS_GET_TARGETS_2 = new String[]{"filter"};
    private static final String[] PARAMS_GET_TARGET_INFO_2 = new String[]{"targetId"};
    private static final String[] PARAMS_OPEN_DEV_TOOLS_1 = new String[]{"targetId"};
    private static final String[] PARAMS_OPEN_DEV_TOOLS_2 = new String[]{"targetId", "panelId"};
    private static final String[] PARAMS_SEND_MESSAGE_TO_TARGET_1 = new String[]{"message"};
    private static final String[] PARAMS_SEND_MESSAGE_TO_TARGET_2 = new String[]{"message", "sessionId", "targetId"};
    private static final String[] PARAMS_SET_AUTO_ATTACH_1 = new String[]{"autoAttach", "waitForDebuggerOnStart"};
    private static final String[] PARAMS_SET_AUTO_ATTACH_2 = new String[]{"autoAttach", "waitForDebuggerOnStart", "flatten", "filter"};
    private static final String[] PARAMS_SET_DISCOVER_TARGETS_1 = new String[]{"discover"};
    private static final String[] PARAMS_SET_DISCOVER_TARGETS_2 = new String[]{"discover", "filter"};
    private static final String[] PARAMS_SET_REMOTE_LOCATIONS_1 = new String[]{"locations"};
    private final SessionInvocationHandler handler;

    public TargetImpl(SessionInvocationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void activateTarget(String targetId) {
        this.handler.invoke(this, DomainCommand.Target_activateTarget, CRT_ACTIVATE_TARGET, PARAMS_ACTIVATE_TARGET_1, new Object[]{targetId}, true);
    }

    @Override
    public String attachToBrowserTarget() {
        return (String)this.handler.invoke(this, DomainCommand.Target_attachToBrowserTarget, CRT_ATTACH_TO_BROWSER_TARGET, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public String attachToTarget(String targetId) {
        return (String)this.handler.invoke(this, DomainCommand.Target_attachToTarget, CRT_ATTACH_TO_TARGET, PARAMS_ATTACH_TO_TARGET_1, new Object[]{targetId}, true);
    }

    @Override
    public String attachToTarget(String targetId, Boolean flatten) {
        return (String)this.handler.invoke(this, DomainCommand.Target_attachToTarget, CRT_ATTACH_TO_TARGET, PARAMS_ATTACH_TO_TARGET_2, new Object[]{targetId, flatten}, true);
    }

    @Override
    public void autoAttachRelated(String targetId, Boolean waitForDebuggerOnStart) {
        this.handler.invoke(this, DomainCommand.Target_autoAttachRelated, CRT_AUTO_ATTACH_RELATED, PARAMS_AUTO_ATTACH_RELATED_1, new Object[]{targetId, waitForDebuggerOnStart}, true);
    }

    @Override
    public void autoAttachRelated(String targetId, Boolean waitForDebuggerOnStart, List<FilterEntry> filter) {
        this.handler.invoke(this, DomainCommand.Target_autoAttachRelated, CRT_AUTO_ATTACH_RELATED, PARAMS_AUTO_ATTACH_RELATED_2, new Object[]{targetId, waitForDebuggerOnStart, filter}, true);
    }

    @Override
    public Boolean closeTarget(String targetId) {
        return (Boolean)this.handler.invoke(this, DomainCommand.Target_closeTarget, CRT_CLOSE_TARGET, PARAMS_CLOSE_TARGET_1, new Object[]{targetId}, true);
    }

    @Override
    public String createBrowserContext() {
        return (String)this.handler.invoke(this, DomainCommand.Target_createBrowserContext, CRT_CREATE_BROWSER_CONTEXT, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public String createBrowserContext(Boolean disposeOnDetach, String proxyServer, String proxyBypassList, List<String> originsWithUniversalNetworkAccess) {
        return (String)this.handler.invoke(this, DomainCommand.Target_createBrowserContext, CRT_CREATE_BROWSER_CONTEXT, PARAMS_CREATE_BROWSER_CONTEXT_2, new Object[]{disposeOnDetach, proxyServer, proxyBypassList, originsWithUniversalNetworkAccess}, true);
    }

    @Override
    public String createTarget(String url) {
        return (String)this.handler.invoke(this, DomainCommand.Target_createTarget, CRT_CREATE_TARGET, PARAMS_CREATE_TARGET_1, new Object[]{url}, true);
    }

    @Override
    public String createTarget(String url, Integer left, Integer top, Integer width, Integer height, WindowState windowState, String browserContextId, Boolean enableBeginFrameControl, Boolean newWindow, Boolean background, Boolean forTab, Boolean hidden) {
        return (String)this.handler.invoke(this, DomainCommand.Target_createTarget, CRT_CREATE_TARGET, PARAMS_CREATE_TARGET_2, new Object[]{url, left, top, width, height, windowState, browserContextId, enableBeginFrameControl, newWindow, background, forTab, hidden}, true);
    }

    @Override
    public void detachFromTarget() {
        this.handler.invoke(this, DomainCommand.Target_detachFromTarget, CRT_DETACH_FROM_TARGET, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public void detachFromTarget(String sessionId, String targetId) {
        this.handler.invoke(this, DomainCommand.Target_detachFromTarget, CRT_DETACH_FROM_TARGET, PARAMS_DETACH_FROM_TARGET_2, new Object[]{sessionId, targetId}, true);
    }

    @Override
    public void disposeBrowserContext(String browserContextId) {
        this.handler.invoke(this, DomainCommand.Target_disposeBrowserContext, CRT_DISPOSE_BROWSER_CONTEXT, PARAMS_DISPOSE_BROWSER_CONTEXT_1, new Object[]{browserContextId}, true);
    }

    @Override
    public void exposeDevToolsProtocol(String targetId) {
        this.handler.invoke(this, DomainCommand.Target_exposeDevToolsProtocol, CRT_EXPOSE_DEV_TOOLS_PROTOCOL, PARAMS_EXPOSE_DEV_TOOLS_PROTOCOL_1, new Object[]{targetId}, true);
    }

    @Override
    public void exposeDevToolsProtocol(String targetId, String bindingName, Boolean inheritPermissions) {
        this.handler.invoke(this, DomainCommand.Target_exposeDevToolsProtocol, CRT_EXPOSE_DEV_TOOLS_PROTOCOL, PARAMS_EXPOSE_DEV_TOOLS_PROTOCOL_2, new Object[]{targetId, bindingName, inheritPermissions}, true);
    }

    @Override
    public GetBrowserContextsResult getBrowserContexts() {
        return (GetBrowserContextsResult)this.handler.invoke(this, DomainCommand.Target_getBrowserContexts, CRT_GET_BROWSER_CONTEXTS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public String getDevToolsTarget(String targetId) {
        return (String)this.handler.invoke(this, DomainCommand.Target_getDevToolsTarget, CRT_GET_DEV_TOOLS_TARGET, PARAMS_GET_DEV_TOOLS_TARGET_1, new Object[]{targetId}, true);
    }

    @Override
    public TargetInfo getTargetInfo() {
        return (TargetInfo)this.handler.invoke(this, DomainCommand.Target_getTargetInfo, CRT_GET_TARGET_INFO, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public TargetInfo getTargetInfo(String targetId) {
        return (TargetInfo)this.handler.invoke(this, DomainCommand.Target_getTargetInfo, CRT_GET_TARGET_INFO, PARAMS_GET_TARGET_INFO_2, new Object[]{targetId}, true);
    }

    @Override
    public List<TargetInfo> getTargets() {
        return (List)this.handler.invoke(this, DomainCommand.Target_getTargets, CRT_GET_TARGETS, EMPTY_ARGS, EMPTY_VALUES, true);
    }

    @Override
    public List<TargetInfo> getTargets(List<FilterEntry> filter) {
        return (List)this.handler.invoke(this, DomainCommand.Target_getTargets, CRT_GET_TARGETS, PARAMS_GET_TARGETS_2, new Object[]{filter}, true);
    }

    @Override
    public String openDevTools(String targetId) {
        return (String)this.handler.invoke(this, DomainCommand.Target_openDevTools, CRT_OPEN_DEV_TOOLS, PARAMS_OPEN_DEV_TOOLS_1, new Object[]{targetId}, true);
    }

    @Override
    public String openDevTools(String targetId, String panelId) {
        return (String)this.handler.invoke(this, DomainCommand.Target_openDevTools, CRT_OPEN_DEV_TOOLS, PARAMS_OPEN_DEV_TOOLS_2, new Object[]{targetId, panelId}, true);
    }

    @Override
    public void sendMessageToTarget(String message) {
        this.handler.invoke(this, DomainCommand.Target_sendMessageToTarget, CRT_SEND_MESSAGE_TO_TARGET, PARAMS_SEND_MESSAGE_TO_TARGET_1, new Object[]{message}, true);
    }

    @Override
    public void sendMessageToTarget(String message, String sessionId, String targetId) {
        this.handler.invoke(this, DomainCommand.Target_sendMessageToTarget, CRT_SEND_MESSAGE_TO_TARGET, PARAMS_SEND_MESSAGE_TO_TARGET_2, new Object[]{message, sessionId, targetId}, true);
    }

    @Override
    public void setAutoAttach(Boolean autoAttach, Boolean waitForDebuggerOnStart) {
        this.handler.invoke(this, DomainCommand.Target_setAutoAttach, CRT_SET_AUTO_ATTACH, PARAMS_SET_AUTO_ATTACH_1, new Object[]{autoAttach, waitForDebuggerOnStart}, true);
    }

    @Override
    public void setAutoAttach(Boolean autoAttach, Boolean waitForDebuggerOnStart, Boolean flatten, List<FilterEntry> filter) {
        this.handler.invoke(this, DomainCommand.Target_setAutoAttach, CRT_SET_AUTO_ATTACH, PARAMS_SET_AUTO_ATTACH_2, new Object[]{autoAttach, waitForDebuggerOnStart, flatten, filter}, true);
    }

    @Override
    public void setDiscoverTargets(Boolean discover) {
        this.handler.invoke(this, DomainCommand.Target_setDiscoverTargets, CRT_SET_DISCOVER_TARGETS, PARAMS_SET_DISCOVER_TARGETS_1, new Object[]{discover}, true);
    }

    @Override
    public void setDiscoverTargets(Boolean discover, List<FilterEntry> filter) {
        this.handler.invoke(this, DomainCommand.Target_setDiscoverTargets, CRT_SET_DISCOVER_TARGETS, PARAMS_SET_DISCOVER_TARGETS_2, new Object[]{discover, filter}, true);
    }

    @Override
    public void setRemoteLocations(List<RemoteLocation> locations) {
        this.handler.invoke(this, DomainCommand.Target_setRemoteLocations, CRT_SET_REMOTE_LOCATIONS, PARAMS_SET_REMOTE_LOCATIONS_1, new Object[]{locations}, true);
    }
}

