/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.junit;

import com.cdp4j.Browser;
import com.cdp4j.JsonLibrary;
import com.cdp4j.Launcher;
import com.cdp4j.Options;
import com.cdp4j.junit.Incognito;
import com.cdp4j.junit.MultiFrame;
import com.cdp4j.logger.CdpLoggerType;
import com.cdp4j.logger.CdpLogggerLevel;
import com.cdp4j.session.Session;
import com.cdp4j.session.SessionFactory;
import com.cdp4j.session.SessionSettings;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class CdpExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final ExtensionContext.Namespace NS_CDP4J = ExtensionContext.Namespace.create((Object[])new Object[]{"cdp4j"});
    protected static final String KEY_LAUNCHER = "launcher";
    protected static final String KEY_FACTORY = "factory";
    protected static final String KEY_SESSIONS = "sessions";
    protected static final String KEY_DUMMY_SESSION = "dummy-session";
    protected static final String KEY_BROWSER_CONTEXT_IDS = "browser-context-ids";
    private final Options options;

    public CdpExtension() {
        this.options = this.createOptions();
    }

    public CdpExtension(Options options) {
        this.options = options;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(Session.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        ExtensionContext.Store store = context.getStore(NS_CDP4J);
        if (store == null) {
            return null;
        }
        SessionFactory factory = (SessionFactory)store.get((Object)KEY_FACTORY);
        if (factory == null) {
            return null;
        }
        boolean incognito = parameterContext.isAnnotated(Incognito.class);
        boolean multiFrame = parameterContext.isAnnotated(MultiFrame.class);
        Session session = null;
        if (incognito) {
            Incognito annotation = parameterContext.getParameter().getAnnotation(Incognito.class);
            String incognitoId = annotation.value();
            context.getStore(NS_CDP4J).get((Object)KEY_BROWSER_CONTEXT_IDS);
            Map browserContextIds = (Map)store.get((Object)KEY_BROWSER_CONTEXT_IDS);
            browserContextIds.computeIfAbsent(incognitoId, id -> factory.createBrowserContext());
            if (multiFrame) {
                SessionSettings settings = SessionSettings.builder().multiFrameMode(true).build();
                session = factory.create((String)browserContextIds.get(incognitoId), settings);
            } else {
                session = factory.create((String)browserContextIds.get(incognitoId));
            }
        } else if (multiFrame) {
            SessionSettings settings = SessionSettings.builder().multiFrameMode(true).build();
            session = factory.create(settings);
        } else {
            session = factory.create();
        }
        List sessions = (List)store.get((Object)KEY_SESSIONS);
        sessions.add(session);
        return session;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = context.getStore(NS_CDP4J);
        store.put((Object)KEY_SESSIONS, new CopyOnWriteArrayList());
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = context.getStore(NS_CDP4J);
        List sessions = (List)store.remove((Object)KEY_SESSIONS);
        if (sessions == null) {
            return;
        }
        for (Session next : sessions) {
            next.close();
        }
        sessions.clear();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = context.getStore(NS_CDP4J);
        Launcher launcher = new Launcher(this.options);
        store.put((Object)KEY_LAUNCHER, (Object)launcher);
        SessionFactory factory = launcher.launch();
        store.put((Object)KEY_FACTORY, (Object)factory);
        store.put((Object)KEY_SESSIONS, new CopyOnWriteArrayList());
        Session dummySession = factory.create();
        store.put((Object)KEY_DUMMY_SESSION, (Object)dummySession);
        store.put((Object)KEY_BROWSER_CONTEXT_IDS, new ConcurrentHashMap(1));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Launcher launcher;
        SessionFactory factory;
        ExtensionContext.Store store = context.getStore(NS_CDP4J);
        if (store == null) {
            return;
        }
        Session dummySession = (Session)store.get((Object)KEY_DUMMY_SESSION);
        if (dummySession != null) {
            dummySession.close();
        }
        if ((factory = (SessionFactory)store.remove((Object)KEY_FACTORY)) != null) {
            Map browserContextIds = (Map)store.remove((Object)KEY_BROWSER_CONTEXT_IDS);
            if (browserContextIds != null) {
                browserContextIds.values().stream().forEach(browserContextId -> factory.disposeBrowserContext((String)browserContextId));
            }
            factory.close();
        }
        if ((launcher = (Launcher)store.remove((Object)KEY_LAUNCHER)) != null) {
            launcher.kill();
        }
    }

    protected Options createOptions() {
        Options.Builder builder = Options.builder().loggerType(this.loggerType()).consoleLoggerLevel(this.consoleLoggerLevel()).headless(this.headless()).userProfileCleanerMaxSleepTime(this.userProfileCleanerMaxSleepTime()).createNewUserDataDir(this.createNewUserDataDir()).jsonLibrary(this.jsonLibrary());
        if (this.browser() != null) {
            builder.browser(this.browser());
        }
        if (this.browserExecutablePath() != null && !this.browserExecutablePath().trim().isEmpty()) {
            builder.browserExecutablePath(this.browserExecutablePath());
        }
        return builder.build();
    }

    protected boolean createNewUserDataDir() {
        return true;
    }

    protected CdpLoggerType loggerType() {
        return CdpLoggerType.Console;
    }

    protected CdpLogggerLevel consoleLoggerLevel() {
        return CdpLogggerLevel.Info;
    }

    protected boolean headless() {
        return false;
    }

    protected JsonLibrary jsonLibrary() {
        return JsonLibrary.Gson;
    }

    protected Browser browser() {
        return null;
    }

    protected int userProfileCleanerMaxSleepTime() {
        return 2000;
    }

    protected String browserExecutablePath() {
        return null;
    }
}

