/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.logger;

import com.cdp4j.logger.CdpLogger;
import com.cdp4j.logger.CdpLogggerLevel;
import com.cdp4j.logger.FormattingTuple;
import com.cdp4j.logger.MessageFormatter;

class CdpConsoleLogger
implements CdpLogger {
    private final CdpLogggerLevel loggerLevel;

    public CdpConsoleLogger() {
        this(CdpLogggerLevel.Info);
    }

    public CdpConsoleLogger(CdpLogggerLevel loggerLevel) {
        this.loggerLevel = loggerLevel;
    }

    @Override
    public void info(String message, Object ... args) {
        if (CdpLogggerLevel.Info == this.loggerLevel || CdpLogggerLevel.Debug == this.loggerLevel) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[INFO] " + tuple.getMessage());
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (CdpLogggerLevel.Debug == this.loggerLevel) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[DEBUG] " + tuple.getMessage());
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (CdpLogggerLevel.Info == this.loggerLevel || CdpLogggerLevel.Warn == this.loggerLevel || CdpLogggerLevel.Debug == this.loggerLevel) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[WARN] " + tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (CdpLogggerLevel.Info == this.loggerLevel || CdpLogggerLevel.Warn == this.loggerLevel || CdpLogggerLevel.Error == this.loggerLevel || CdpLogggerLevel.Debug == this.loggerLevel) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(message, args);
            System.out.println("[ERROR] " + tuple.getMessage());
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (CdpLogggerLevel.Info == this.loggerLevel || CdpLogggerLevel.Warn == this.loggerLevel || CdpLogggerLevel.Error == this.loggerLevel || CdpLogggerLevel.Debug == this.loggerLevel) {
            System.err.println("[ERROR] " + message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return CdpLogggerLevel.Debug == this.loggerLevel;
    }
}

