/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.process;

import com.cdp4j.process.CdpProcess;
import com.cdp4j.process.ProcessManager;
import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;

public class DefaultProcessManager
implements ProcessManager {
    protected long pid;
    protected Instant startTime;
    protected String command;

    @Override
    public void setProcess(CdpProcess process) {
        ProcessHandle handle = ((Process)process.getProcess()).toHandle();
        ProcessHandle.Info info = handle.info();
        this.startTime = info.startInstant().get();
        this.command = info.command().get();
        this.pid = handle.pid();
    }

    @Override
    public boolean kill() {
        if (this.pid <= 0L) {
            return false;
        }
        Optional<ProcessHandle> process = ProcessHandle.of(this.pid);
        if (process.isPresent()) {
            ProcessHandle handle = process.get();
            ProcessHandle.Info info = handle.info();
            if (handle.isAlive() && info.startInstant().isPresent() && info.startInstant().get().equals(this.startTime) && info.command().isPresent() && info.command().get().equals(this.command)) {
                try (Stream<ProcessHandle> descendants = handle.descendants();){
                    descendants.forEach(ph -> {
                        try {
                            if (ph.isAlive()) {
                                ph.destroyForcibly();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                boolean success = handle.destroyForcibly();
                if (success) {
                    handle.onExit().join();
                }
                return success;
            }
        }
        return false;
    }
}

