/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.command.Runtime;
import com.cdp4j.exception.CdpException;
import com.cdp4j.exception.JsPromiseException;
import com.cdp4j.session.Constant;
import com.cdp4j.session.Session;
import com.cdp4j.type.constant.ObjectType;
import com.cdp4j.type.runtime.CallArgument;
import com.cdp4j.type.runtime.CallFunctionOnResult;
import com.cdp4j.type.runtime.EvaluateResult;
import com.cdp4j.type.runtime.RemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public interface JavaScript {
    default public Object evaluate(String expression) {
        Integer contextId;
        Runtime runtime = this.getThis().getCommand().getRuntime();
        EvaluateResult result = runtime.evaluate(expression, null, null, null, contextId = this.getThis().getExecutionContextId(), null, null, null, null, null, null, null, null, null, null, null);
        if (result == null) {
            return null;
        }
        RemoteObject remoteObject = result.getResult();
        if (remoteObject == null) {
            return null;
        }
        String objectId = result.getResult().getObjectId();
        if (objectId != null) {
            this.getThis().releaseObject(objectId);
        }
        Object value = remoteObject.getValue();
        this.getThis().logExit("evaluate", expression, value);
        return value;
    }

    default public void callFunction(String name) {
        this.callFunction(name, Void.TYPE, Constant.EMPTY_ARGS);
    }

    default public <T> T callFunction(String name, Class<T> returnType) {
        return this.callFunction(name, returnType, Constant.EMPTY_ARGS);
    }

    default public <T> T callFunction(String name, Class<T> returnType, Object ... arguments) {
        CallArgument objArgument = new CallArgument();
        objArgument.setValue(name);
        CallFunctionOnResult funcObj = this.getThis().getCommand().getRuntime().callFunctionOn("function(functionName) { return functionName.split('.').reduce((o, i) => o[i], this); }", null, Arrays.asList(objArgument), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.getThis().getExecutionContextId(), null, null, null, null);
        if (funcObj.getExceptionDetails() != null && funcObj.getExceptionDetails().getException() != null) {
            this.getThis().releaseObject(funcObj.getExceptionDetails().getException().getObjectId());
            throw new CdpException(funcObj.getExceptionDetails().getException().getDescription());
        }
        if (ObjectType.Undefined == funcObj.getResult().getType()) {
            this.getThis().releaseObject(funcObj.getResult().getObjectId());
            throw new CdpException(String.format("Function [%s] is not defined", name));
        }
        StringJoiner argNames = new StringJoiner(", ");
        ArrayList<CallArgument> argsFunc = arguments != null ? new ArrayList<CallArgument>(arguments.length) : null;
        int i = 0;
        if (arguments != null && arguments.length > 0) {
            for (Object argument : arguments) {
                CallArgument ca = new CallArgument();
                argsFunc.add(ca);
                if (argument != null) {
                    if (this.getThis().isPrimitive(argument.getClass())) {
                        ca.setValue(argument);
                    } else {
                        ca.setUnserializableValue(this.getThis().getJsonMapper().toJson(argument));
                    }
                }
                argNames.add("arg" + i++);
            }
        }
        CallFunctionOnResult func = this.getThis().getCommand().getRuntime().callFunctionOn(String.format("function(%s) { const result = this.apply(this, Array.prototype.slice.call(arguments)); return typeof result === 'undefined' ? undefined : JSON.stringify({ result : result }); }", argNames.toString()), funcObj.getResult().getObjectId(), argsFunc, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null);
        this.getThis().releaseObject(funcObj.getResult().getObjectId());
        this.getThis().releaseObject(func.getResult().getObjectId());
        if (func.getExceptionDetails() != null && func.getExceptionDetails().getException() != null) {
            this.getThis().releaseObject(func.getExceptionDetails().getException().getObjectId());
            throw new CdpException(func.getExceptionDetails().getException().getDescription());
        }
        Object value = null;
        if (ObjectType.String == func.getResult().getType() && !returnType.equals(Void.TYPE)) {
            String json = String.valueOf(func.getResult().getValue());
            value = this.getThis().getJsonMapper().fromJsonResult(json, returnType);
        } else if (ObjectType.Undefined == func.getResult().getType()) {
            value = Void.TYPE;
        }
        this.getThis().logExit("callFunction", "function name = " + name + (arguments == null || arguments.length == 0 ? "" : ", arguments = (\"" + Arrays.stream(arguments).map(o -> String.valueOf(o)).collect(Collectors.joining("\", \"")) + "\")"), String.valueOf(value).replace("\n", "").replace("\r", ""));
        return (T)(!Void.TYPE.equals(value) ? value : null);
    }

    default public <T, U> CompletableFuture<T> callPromise(String name, Class<T> returnType, Object ... arguments) {
        CallArgument objArgument = new CallArgument();
        objArgument.setValue(name);
        CallFunctionOnResult funcObj = this.getThis().getCommand().getRuntime().callFunctionOn("function(functionName) { return functionName.split('.').reduce((o, i) => o[i], this); }", null, Arrays.asList(objArgument), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, this.getThis().getExecutionContextId(), null, null, null, null);
        if (funcObj.getExceptionDetails() != null && funcObj.getExceptionDetails().getException() != null) {
            this.getThis().releaseObject(funcObj.getExceptionDetails().getException().getObjectId());
            throw new CdpException(funcObj.getExceptionDetails().getException().getDescription());
        }
        if (ObjectType.Undefined == funcObj.getResult().getType()) {
            this.getThis().releaseObject(funcObj.getResult().getObjectId());
            throw new CdpException(String.format("Function [%s] is not defined", name));
        }
        StringJoiner argNames = new StringJoiner(", ");
        ArrayList<CallArgument> argsFunc = arguments != null ? new ArrayList<CallArgument>(arguments.length) : null;
        int i = 0;
        if (arguments != null && arguments.length > 0) {
            for (Object argument : arguments) {
                CallArgument ca = new CallArgument();
                argsFunc.add(ca);
                if (argument != null) {
                    if (this.getThis().isPrimitive(argument.getClass())) {
                        ca.setValue(argument);
                    } else {
                        ca.setUnserializableValue(this.getThis().getJsonMapper().toJson(argument));
                    }
                }
                argNames.add("arg" + i++);
            }
        }
        CompletableFuture<CallFunctionOnResult> future = this.getThis().getAsyncCommand().getRuntime().callFunctionOn(String.format("function(%s) { const result = this.apply(this, Array.prototype.slice.call(arguments)); if ( ! (result instanceof Promise) ) { throw Error('Expected promise but return value is not a promise type [' + (typeof result) + ']'); } else { return result; } }", argNames.toString()), funcObj.getResult().getObjectId(), argsFunc, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, null, null, null, null, null);
        CompletableFuture promise = new CompletableFuture();
        this.getThis().addCloseListener(() -> {
            if (!promise.isDone()) {
                promise.cancel(true);
            }
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        future.whenCompleteAsync((result, exception) -> {
            if (exception != null) {
                promise.completeExceptionally((Throwable)exception);
                return;
            }
            this.getThis().releaseObject(funcObj.getResult().getObjectId());
            this.getThis().releaseObject(result.getResult().getObjectId());
            if (result.getExceptionDetails() != null && result.getExceptionDetails().getException() != null) {
                this.getThis().releaseObject(result.getExceptionDetails().getException().getObjectId());
                String msg = result.getExceptionDetails().getException().getDescription();
                if (result.getResult().getValue() != null) {
                    msg = String.valueOf(result.getResult().getValue());
                } else if (msg == null) {
                    msg = result.getExceptionDetails().getText();
                }
                if (!promise.isDone()) {
                    promise.completeExceptionally(new JsPromiseException(msg));
                }
                return;
            }
            Object value = null;
            ObjectType rt = result.getResult().getType();
            if (ObjectType.Object == rt) {
                try {
                    value = this.getThis().getJsonMapper().fromObject(result.getResult().getValue(), returnType);
                }
                catch (Throwable t) {
                    promise.completeExceptionally(t);
                    return;
                }
            } else {
                value = ObjectType.Undefined == rt ? null : result.getResult().getValue();
            }
            if (!promise.isDone()) {
                this.getThis().logExit("callPromise", "function name = " + name + (arguments == null || arguments.length == 0 ? "" : ", arguments = (\"" + Arrays.stream(arguments).map(o -> String.valueOf(o)).collect(Collectors.joining("\", \"")) + "\")"), String.valueOf(value).replace("\n", "").replace("\r", ""));
                Object fValue = value;
                promise.completeAsync(() -> fValue);
            }
        });
        return promise;
    }

    default public <T> T getVariable(String name, Class<T> returnType) {
        CallArgument objArgument = new CallArgument();
        objArgument.setValue(name);
        CallFunctionOnResult obj = this.getThis().getCommand().getRuntime().callFunctionOn("function(functionName) { const result = functionName.split('.').reduce((o, i) => o[i], this); return typeof result === 'undefined' ? undefined : JSON.stringify({ result : result }); }", null, Arrays.asList(objArgument), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, this.getThis().getExecutionContextId(), null, null, null, null);
        if (obj.getExceptionDetails() != null && obj.getExceptionDetails().getException() != null) {
            this.getThis().releaseObject(obj.getExceptionDetails().getException().getObjectId());
            throw new CdpException(obj.getExceptionDetails().getException().getDescription());
        }
        if (ObjectType.Undefined == obj.getResult().getType()) {
            this.getThis().releaseObject(obj.getResult().getObjectId());
            throw new CdpException(String.format("Variable [%s] is not defined", name));
        }
        Object value = null;
        if (ObjectType.String == obj.getResult().getType() && !returnType.equals(Void.TYPE)) {
            String json = String.valueOf(obj.getResult().getValue());
            value = this.getThis().getJsonMapper().fromJsonResult(json, returnType);
        } else if (ObjectType.Undefined == obj.getResult().getType()) {
            value = Void.TYPE;
        }
        this.getThis().releaseObject(obj.getResult().getObjectId());
        return (T)value;
    }

    default public void setVariable(String name, Object newValue) {
        EvaluateResult windowResult = this.getThis().getCommand().getRuntime().evaluate("window");
        if (windowResult == null) {
            return;
        }
        if (windowResult.getExceptionDetails() != null && windowResult.getExceptionDetails().getException() != null) {
            this.getThis().releaseObject(windowResult.getExceptionDetails().getException().getObjectId());
            throw new CdpException(windowResult.getExceptionDetails().getException().getDescription());
        }
        CallArgument argVariableName = new CallArgument();
        argVariableName.setValue(name);
        CallArgument argVariableValue = new CallArgument();
        if (newValue != null) {
            if (this.getThis().isPrimitive(newValue.getClass())) {
                argVariableValue.setValue(newValue);
            } else {
                argVariableValue.setValue(this.getThis().getJsonMapper().toJson(newValue));
            }
        }
        CallFunctionOnResult obj = this.getThis().getCommand().getRuntime().callFunctionOn("function(is, value) { function index(obj, is, value) { if (typeof is == 'string') return index(obj, is.split('.'), value); else if (is.length === 1 && value !== undefined) return obj[is[0]] = value; else if (is.length === 0) return obj; else return index(obj[is[0]], is.slice(1), value); } index(window, is, value); }", windowResult.getResult().getObjectId(), Arrays.asList(argVariableName, argVariableValue), Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null);
        this.getThis().releaseObject(windowResult.getResult().getObjectId());
        if (obj.getExceptionDetails() != null && obj.getExceptionDetails().getException() != null) {
            this.getThis().releaseObject(obj.getExceptionDetails().getException().getObjectId());
            throw new CdpException(obj.getExceptionDetails().getException().getDescription());
        }
        this.getThis().releaseObject(obj.getResult().getObjectId());
    }

    public Session getThis();
}

