/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.exception.CdpReadInterruptionException;
import com.cdp4j.exception.CdpReadTimeoutException;
import com.cdp4j.exception.CommandException;
import com.cdp4j.serialization.ResponseParser;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.Context;
import com.cdp4j.session.DomainCommand;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class SemaphoreContext
implements Context {
    private Object data;
    private CommandException error;
    private final Semaphore semaphore = new Semaphore(0);
    private final DomainCommand domainCommand;
    private final CommandReturnType commandReturnType;
    private final ResponseParser responseParser;

    public SemaphoreContext(DomainCommand domainCommand, CommandReturnType commandReturnType, ResponseParser responseParser) {
        this.domainCommand = domainCommand;
        this.commandReturnType = commandReturnType;
        this.responseParser = responseParser;
    }

    @Override
    public void await(int timeout) {
        try {
            boolean acquired = this.semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            if (!acquired) {
                throw new CdpReadTimeoutException(timeout);
            }
        }
        catch (InterruptedException e) {
            throw new CdpReadInterruptionException(timeout);
        }
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setError(CommandException error) {
        this.error = error;
    }

    @Override
    public CommandException getError() {
        return this.error;
    }

    @Override
    public void release() {
        this.semaphore.release();
    }

    @Override
    public DomainCommand getDomainCommand() {
        return this.domainCommand;
    }

    @Override
    public CommandReturnType getCommandReturnType() {
        return this.commandReturnType;
    }

    @Override
    public CompletableFuture<Object> getPromise() {
        return null;
    }

    @Override
    public ResponseParser getResponseParser() {
        return this.responseParser;
    }
}

