/*
 * Decompiled with CFR 0.152.
 */
package com.cdp4j.session;

import com.cdp4j.exception.CdpReadInterruptionException;
import com.cdp4j.exception.CdpReadTimeoutException;
import com.cdp4j.exception.CommandException;
import com.cdp4j.serialization.ResponseParser;
import com.cdp4j.session.CommandReturnType;
import com.cdp4j.session.Context;
import com.cdp4j.session.DomainCommand;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.LockSupport;

class ThreadContext
implements Context {
    private Object data;
    private CommandException error;
    private final Thread thread = Thread.currentThread();
    private final DomainCommand domainCommand;
    private final CommandReturnType commandReturnType;
    private final long start;
    private final ResponseParser responseParser;

    public ThreadContext(DomainCommand domainCommand, CommandReturnType commandReturnType, ResponseParser responseParser) {
        this.domainCommand = domainCommand;
        this.commandReturnType = commandReturnType;
        this.responseParser = responseParser;
        this.start = System.currentTimeMillis();
    }

    @Override
    public void await(int timeout) {
        LockSupport.parkUntil(this.start + (long)timeout);
        if (this.data == null && this.error == null && System.currentTimeMillis() - this.start >= (long)timeout) {
            if (Thread.currentThread().isInterrupted()) {
                throw new CdpReadInterruptionException(timeout);
            }
            throw new CdpReadTimeoutException(timeout);
        }
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setError(CommandException error) {
        this.error = error;
    }

    @Override
    public CommandException getError() {
        return this.error;
    }

    @Override
    public void release() {
        LockSupport.unpark(this.thread);
    }

    @Override
    public DomainCommand getDomainCommand() {
        return this.domainCommand;
    }

    @Override
    public CommandReturnType getCommandReturnType() {
        return this.commandReturnType;
    }

    @Override
    public CompletableFuture<Object> getPromise() {
        return null;
    }

    @Override
    public ResponseParser getResponseParser() {
        return this.responseParser;
    }
}

