/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataAtSizeProvider;
import org.eclipse.swt.graphics.ImageDataLoader;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageGcDrawer;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.GtkDPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.StrictChecks;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.image.ImageColorTransformer;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public long mask;
    public long surface;
    int transparentPixel = -1;
    GC memGC;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;
    private ImageFileNameProvider imageFileNameProvider;
    private ImageDataProvider imageDataProvider;
    private ImageGcDrawer imageGcDrawer;
    private int styleFlag = 0;
    private int currentDeviceZoom = 100;
    private CachedImageAtSize cachedImageAtSize = new CachedImageAtSize();

    Image(Device device) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
    }

    public Image(Device device, int n, int n2) {
        super(device);
        Point point = new Point(n, n2);
        this.init(point.x, point.y);
        this.init();
    }

    public Image(Device device, Image image, int n) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        device = this.device;
        this.type = image.type;
        this.imageDataProvider = image.imageDataProvider;
        this.imageFileNameProvider = image.imageFileNameProvider;
        this.imageGcDrawer = image.imageGcDrawer;
        this.styleFlag = image.styleFlag | n;
        this.currentDeviceZoom = image.currentDeviceZoom;
        if (n != 1) {
            this.transparentPixel = image.transparentPixel;
        }
        long l = image.surface;
        this.width = image.width;
        this.height = image.height;
        int n2 = Cairo.cairo_surface_get_content((long)l) == 4096 ? 1 : 0;
        boolean bl = n2 == 0;
        int n3 = DPIUtil.pointToPixel(this.width, DPIUtil.getDeviceZoom());
        int n4 = DPIUtil.pointToPixel(this.height, DPIUtil.getDeviceZoom());
        this.surface = Cairo.cairo_image_surface_create((int)n2, (int)n3, (int)n4);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Cairo.cairo_surface_get_device_scale((long)l, (double[])dArray, (double[])dArray2);
        Cairo.cairo_surface_set_device_scale((long)this.surface, (double)dArray[0], (double)dArray2[0]);
        long l2 = Cairo.cairo_create((long)this.surface);
        if (l2 == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_set_operator((long)l2, (int)1);
        Cairo.cairo_set_source_surface((long)l2, (long)l, (double)0.0, (double)0.0);
        Cairo.cairo_paint((long)l2);
        Cairo.cairo_destroy((long)l2);
        if (n != 0) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = Cairo.cairo_image_surface_get_stride((long)this.surface);
            long l3 = Cairo.cairo_image_surface_get_data((long)this.surface);
            if (OS.BIG_ENDIAN) {
                n8 = 0;
                n7 = 1;
                n6 = 2;
                n5 = 3;
            } else {
                n8 = 3;
                n7 = 2;
                n6 = 1;
                n5 = 0;
            }
            switch (n) {
                case 1: {
                    byte[] byArray = new byte[n9];
                    for (int i = 0; i < n4; ++i) {
                        C.memmove((byte[])byArray, (long)(l3 + (long)(i * n9)), (long)n9);
                        int n10 = 0;
                        int n11 = 0;
                        while (n10 < n3) {
                            int n12 = byArray[n11 + n8] & 0xFF;
                            int n13 = byArray[n11 + n7] & 0xFF;
                            int n14 = byArray[n11 + n6] & 0xFF;
                            int n15 = byArray[n11 + n5] & 0xFF;
                            if (bl && n12 != 0) {
                                n13 = n13 * 255 / n12;
                                n14 = n14 * 255 / n12;
                                n15 = n15 * 255 / n12;
                            }
                            RGBA rGBA = ImageColorTransformer.DEFAULT_DISABLED_IMAGE_TRANSFORMER.adaptPixelValue(n13, n14, n15, n12);
                            if (bl) {
                                rGBA.rgb.red = rGBA.rgb.red * rGBA.alpha / 255;
                                rGBA.rgb.green = rGBA.rgb.green * rGBA.alpha / 255;
                                rGBA.rgb.blue = rGBA.rgb.blue * rGBA.alpha / 255;
                            }
                            byArray[n11 + n8] = (byte)rGBA.alpha;
                            byArray[n11 + n7] = (byte)rGBA.rgb.red;
                            byArray[n11 + n6] = (byte)rGBA.rgb.green;
                            byArray[n11 + n5] = (byte)rGBA.rgb.blue;
                            ++n10;
                            n11 += 4;
                        }
                        C.memmove((long)(l3 + (long)(i * n9)), (byte[])byArray, (long)n9);
                    }
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[n9];
                    for (int i = 0; i < n4; ++i) {
                        C.memmove((byte[])byArray, (long)(l3 + (long)(i * n9)), (long)n9);
                        int n16 = 0;
                        int n17 = 0;
                        while (n16 < n3) {
                            int n18 = byArray[n17 + n8] & 0xFF;
                            int n19 = byArray[n17 + n7] & 0xFF;
                            int n20 = byArray[n17 + n6] & 0xFF;
                            int n21 = byArray[n17 + n5] & 0xFF;
                            if (bl && n18 != 0) {
                                n19 = (n19 * 255 + n18 / 2) / n18;
                                n20 = (n20 * 255 + n18 / 2) / n18;
                                n21 = (n21 * 255 + n18 / 2) / n18;
                            }
                            int n22 = n19 + n19 + n20 + n20 + n20 + n20 + n20 + n21 >> 3;
                            if (bl) {
                                n22 = n22 * n18 + 128;
                                n22 = n22 + (n22 >> 8) >> 8;
                            }
                            byte by = (byte)n22;
                            byArray[n17 + n5] = by;
                            byArray[n17 + n6] = by;
                            byArray[n17 + n7] = by;
                            ++n16;
                            n17 += 4;
                        }
                        C.memmove((long)(l3 + (long)(i * n9)), (byte[])byArray, (long)n9);
                    }
                    break;
                }
            }
        }
        this.init();
    }

    @Deprecated(since="2025-06", forRemoval=true)
    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(rectangle.width, rectangle.height);
        this.init();
    }

    public Image(Device device, ImageData imageData) {
        this(device, GtkDPIUtil.pointToPixel((Device)device, (ImageData)imageData), DPIUtil.getDeviceZoom());
    }

    private Image(Device device, ImageData imageData, int n) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = n;
        this.init(imageData, n);
        this.init();
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        imageData = GtkDPIUtil.pointToPixel((Device)device, (ImageData)imageData);
        imageData2 = GtkDPIUtil.pointToPixel((Device)device, (ImageData)imageData2);
        imageData2 = ImageData.convertMask((ImageData)imageData2);
        ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
        imageData3.maskPad = imageData2.scanlinePad;
        imageData3.maskData = imageData2.data;
        this.init(imageData3);
        this.init();
    }

    public Image(Device device, InputStream inputStream) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        DPIUtil.ElementAtZoom elementAtZoom = ImageDataLoader.loadByZoom((InputStream)inputStream, (int)100, (int)this.currentDeviceZoom);
        ImageData imageData = DPIUtil.scaleImageData(device, elementAtZoom, this.currentDeviceZoom);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, String string) {
        super(device);
        if (string == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        DPIUtil.ElementAtZoom elementAtZoom = ImageDataLoader.loadByZoom((String)string, (int)100, (int)this.currentDeviceZoom);
        ImageData imageData = DPIUtil.scaleImageData(device, elementAtZoom, this.currentDeviceZoom);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        this.imageFileNameProvider = imageFileNameProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        this.initFromFileNameProvider(this.currentDeviceZoom);
        this.init();
    }

    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        this.imageDataProvider = imageDataProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        this.initFromImageDataProvider(this.currentDeviceZoom);
        this.init();
        StrictChecks.runIfStrictChecksEnabled(() -> DPIUtil.validateLinearScaling(imageDataProvider));
    }

    public Image(Device device, ImageGcDrawer imageGcDrawer, int n, int n2) {
        super(device);
        if (imageGcDrawer == null) {
            SWT.error(4);
        }
        this.imageGcDrawer = imageGcDrawer;
        this.currentDeviceZoom = 100;
        ImageData imageData = this.drawWithImageGcDrawer(n, n2, this.currentDeviceZoom);
        this.init(imageData, this.currentDeviceZoom);
        this.init();
    }

    public boolean internal_gtk_refreshImageForZoom() {
        return this.refreshImageForZoom();
    }

    boolean refreshImageForZoom() {
        int n;
        boolean bl = false;
        int n2 = DPIUtil.getDeviceZoom();
        if (this.imageFileNameProvider != null) {
            int n3 = n2;
            if (n3 != this.currentDeviceZoom) {
                this.destroy();
                this.initFromFileNameProvider(n3);
                this.init();
                bl = true;
                this.currentDeviceZoom = n3;
            }
        } else if (this.imageDataProvider != null) {
            int n4 = n2;
            if (n4 != this.currentDeviceZoom) {
                this.destroy();
                this.initFromImageDataProvider(n4);
                this.init();
                bl = true;
                this.currentDeviceZoom = n4;
            }
        } else if (this.imageGcDrawer != null && (n = n2) != this.currentDeviceZoom) {
            ImageData imageData = this.drawWithImageGcDrawer(this.width, this.height, n);
            this.destroy();
            this.init(imageData);
            this.init();
            bl = true;
            this.currentDeviceZoom = n;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initNative(String string) {
        block6: {
            try {
                byte[] byArray = Converter.javaStringToCString((String)string);
                long l = GDK.gdk_pixbuf_new_from_file((byte[])byArray, null);
                if (l == 0L) break block6;
                try {
                    this.createFromPixbuf(0, l);
                }
                finally {
                    if (l != 0L) {
                        OS.g_object_unref(l);
                    }
                }
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    private void initFromFileNameProvider(int n) {
        DPIUtil.ElementAtZoom<String> elementAtZoom = DPIUtil.validateAndGetImagePathAtZoom(this.imageFileNameProvider, n);
        if (elementAtZoom.zoom() == n) {
            this.initNative(elementAtZoom.element());
        }
        if (this.surface == 0L) {
            DPIUtil.ElementAtZoom elementAtZoom2 = ImageDataLoader.loadByZoom((String)elementAtZoom.element(), (int)elementAtZoom.zoom(), (int)n);
            ImageData imageData = (ImageData)elementAtZoom2.element();
            if (elementAtZoom2.zoom() != n) {
                imageData = DPIUtil.scaleImageData(this.device, elementAtZoom2, n);
            }
            this.init(imageData);
        }
    }

    private void initFromImageDataProvider(int n) {
        DPIUtil.ElementAtZoom<ImageData> elementAtZoom = DPIUtil.validateAndGetImageDataAtZoom(this.imageDataProvider, n);
        ImageData imageData = DPIUtil.scaleImageData(this.device, elementAtZoom.element(), n, elementAtZoom.zoom());
        this.init(imageData);
    }

    void createFromPixbuf(int n, long l) {
        this.type = n;
        int n2 = GDK.gdk_pixbuf_get_width((long)l);
        int n3 = GDK.gdk_pixbuf_get_height((long)l);
        double d = (float)DPIUtil.getDeviceZoom() / 100.0f;
        this.width = (int)Math.round((double)n2 / d);
        this.height = (int)Math.round((double)n3 / d);
        int n4 = GDK.gdk_pixbuf_get_rowstride((long)l);
        long l2 = GDK.gdk_pixbuf_get_pixels((long)l);
        boolean bl = GDK.gdk_pixbuf_get_has_alpha((long)l);
        int n5 = bl ? 0 : 1;
        this.surface = Cairo.cairo_image_surface_create((int)n5, (int)n2, (int)n3);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_surface_set_device_scale((long)this.surface, (double)d, (double)d);
        long l3 = Cairo.cairo_image_surface_get_data((long)this.surface);
        int n6 = Cairo.cairo_image_surface_get_stride((long)this.surface);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (OS.BIG_ENDIAN) {
            n7 = 0;
            n8 = 1;
            n9 = 2;
            n10 = 3;
        } else {
            n7 = 3;
            n8 = 2;
            n9 = 1;
            n10 = 0;
        }
        byte[] byArray = new byte[n4];
        if (bl) {
            for (int i = 0; i < n3; ++i) {
                C.memmove((byte[])byArray, (long)(l2 + (long)(i * n4)), (long)n4);
                int n11 = 0;
                int n12 = 0;
                while (n11 < n2) {
                    int n13 = byArray[n12 + 3] & 0xFF;
                    int n14 = (byArray[n12 + 0] & 0xFF) * n13 + 128;
                    n14 = n14 + (n14 >> 8) >> 8;
                    int n15 = (byArray[n12 + 1] & 0xFF) * n13 + 128;
                    n15 = n15 + (n15 >> 8) >> 8;
                    int n16 = (byArray[n12 + 2] & 0xFF) * n13 + 128;
                    n16 = n16 + (n16 >> 8) >> 8;
                    byArray[n12 + n7] = (byte)n13;
                    byArray[n12 + n8] = (byte)n14;
                    byArray[n12 + n9] = (byte)n15;
                    byArray[n12 + n10] = (byte)n16;
                    ++n11;
                    n12 += 4;
                }
                C.memmove((long)(l3 + (long)(i * n4)), (byte[])byArray, (long)n4);
            }
        } else {
            byte[] byArray2 = new byte[n6];
            for (int i = 0; i < n3; ++i) {
                C.memmove((byte[])byArray, (long)(l2 + (long)(i * n4)), (long)n4);
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                while (n17 < n2) {
                    int n20 = byArray[n18 + 0] & 0xFF;
                    int n21 = byArray[n18 + 1] & 0xFF;
                    int n22 = byArray[n18 + 2] & 0xFF;
                    byArray2[n19 + n8] = (byte)n20;
                    byArray2[n19 + n9] = (byte)n21;
                    byArray2[n19 + n10] = (byte)n22;
                    ++n17;
                    n18 += 3;
                    n19 += 4;
                }
                C.memmove((long)(l3 + (long)(i * n6)), (byte[])byArray2, (long)n6);
            }
        }
        Cairo.cairo_surface_mark_dirty((long)this.surface);
    }

    void createMask() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.width;
        int n9 = this.height;
        int n10 = Cairo.cairo_image_surface_get_stride((long)this.surface);
        long l = Cairo.cairo_image_surface_get_data((long)this.surface);
        if (OS.BIG_ENDIAN) {
            n7 = 0;
            n6 = 1;
            n5 = 2;
            n4 = 3;
            n3 = this.transparentPixel >> 24 & 0xFF;
            n2 = this.transparentPixel >> 16 & 0xFF;
            n = this.transparentPixel >> 8 & 0xFF;
        } else {
            n7 = 3;
            n6 = 2;
            n5 = 1;
            n4 = 0;
            n3 = this.transparentPixel >> 16 & 0xFF;
            n2 = this.transparentPixel >> 8 & 0xFF;
            n = this.transparentPixel >> 0 & 0xFF;
        }
        byte[] byArray = new byte[n10 * n9];
        C.memmove((byte[])byArray, (long)l, (long)byArray.length);
        int n11 = 0;
        for (int i = 0; i < n9; ++i) {
            int n12 = 0;
            while (n12 < n8) {
                int n13 = byArray[n11 + n7] & 0xFF;
                int n14 = byArray[n11 + n6] & 0xFF;
                int n15 = byArray[n11 + n5] & 0xFF;
                int n16 = byArray[n11 + n4] & 0xFF;
                if (n14 == n3 && n15 == n2 && n16 == n) {
                    n16 = 0;
                    n15 = 0;
                    n14 = 0;
                    n13 = 0;
                } else {
                    n13 = 255;
                }
                byArray[n11 + n7] = (byte)n13;
                byArray[n11 + n6] = (byte)n14;
                byArray[n11 + n5] = (byte)n15;
                byArray[n11 + n4] = (byte)n16;
                ++n12;
                n11 += 4;
            }
        }
        C.memmove((long)l, (byte[])byArray, (long)byArray.length);
    }

    void destroyMask() {
        if (this.mask == 0L) {
            return;
        }
        OS.g_object_unref(this.mask);
        this.mask = 0L;
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.mask != 0L) {
            OS.g_object_unref(this.mask);
        }
        if (this.surface != 0L) {
            Cairo.cairo_surface_destroy((long)this.surface);
        }
        this.mask = 0L;
        this.surface = 0L;
        this.memGC = null;
        this.cachedImageAtSize.destroy();
    }

    void executeOnImageAtSize(Consumer<Image> consumer, int n, int n2) {
        Optional<Image> optional = this.cachedImageAtSize.refresh(n, n2);
        consumer.accept(optional.orElse(this));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)((Object)object);
        if (this.device != image.device || this.transparentPixel != image.transparentPixel) {
            return false;
        }
        if (this.imageDataProvider != null && image.imageDataProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageDataProvider.equals(image.imageDataProvider);
        }
        if (this.imageFileNameProvider != null && image.imageFileNameProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageFileNameProvider.equals(image.imageFileNameProvider);
        }
        if (this.imageGcDrawer != null && image.imageGcDrawer != null) {
            return this.styleFlag == image.styleFlag && this.imageGcDrawer.equals(image.imageGcDrawer) && this.width == image.width && this.height == image.height;
        }
        return this.surface == image.surface;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getBoundsInPixels();
    }

    @Deprecated(since="2025-09", forRemoval=true)
    public Rectangle getBoundsInPixels() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getImageData(100);
    }

    @Deprecated(since="2025-09", forRemoval=true)
    public ImageData getImageDataAtCurrentZoom() {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        long l = ImageList.convertSurface((Image)this);
        int n5 = Cairo.cairo_image_surface_get_format((long)l);
        int n6 = Cairo.cairo_image_surface_get_width((long)l);
        int n7 = Cairo.cairo_image_surface_get_height((long)l);
        int n8 = Cairo.cairo_image_surface_get_stride((long)l);
        long l2 = Cairo.cairo_image_surface_get_data((long)l);
        boolean bl2 = bl = n5 == 0;
        if (OS.BIG_ENDIAN) {
            n4 = 0;
            n3 = 1;
            n2 = 2;
            n = 3;
        } else {
            n4 = 3;
            n3 = 2;
            n2 = 1;
            n = 0;
        }
        byte[] byArray = new byte[n8 * n7];
        C.memmove((byte[])byArray, (long)l2, (long)byArray.length);
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n6, n7, 32, paletteData, 4, byArray);
        if (bl) {
            imageData.alphaData = new byte[n6 * n7];
            byte[] byArray2 = imageData.alphaData;
            int n9 = 0;
            int n10 = 0;
            for (int i = 0; i < n7; ++i) {
                int n11 = 0;
                while (n11 < n6) {
                    int n12 = byArray[n9 + n4] & 0xFF;
                    int n13 = byArray[n9 + n3] & 0xFF;
                    int n14 = byArray[n9 + n2] & 0xFF;
                    int n15 = byArray[n9 + n] & 0xFF;
                    byArray[n9 + 0] = 0;
                    byArray2[n10++] = (byte)n12;
                    if (n12 != 0) {
                        byArray[n9 + 1] = (byte)((n13 * 255 + n12 / 2) / n12);
                        byArray[n9 + 2] = (byte)((n14 * 255 + n12 / 2) / n12);
                        byArray[n9 + 3] = (byte)((n15 * 255 + n12 / 2) / n12);
                    }
                    ++n11;
                    n9 += 4;
                }
            }
        } else {
            int n16 = 0;
            for (int i = 0; i < n7; ++i) {
                int n17 = 0;
                while (n17 < n6) {
                    byte by = byArray[n16 + n3];
                    byte by2 = byArray[n16 + n2];
                    byte by3 = byArray[n16 + n];
                    byArray[n16 + 0] = 0;
                    byArray[n16 + 1] = by;
                    byArray[n16 + 2] = by2;
                    byArray[n16 + 3] = by3;
                    ++n17;
                    n16 += 4;
                }
            }
        }
        Cairo.cairo_surface_destroy((long)l);
        return imageData;
    }

    public ImageData getImageData(int n) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n == this.currentDeviceZoom) {
            return this.getImageDataAtCurrentZoom();
        }
        if (this.imageDataProvider != null) {
            DPIUtil.ElementAtZoom<ImageData> elementAtZoom = DPIUtil.validateAndGetImageDataAtZoom(this.imageDataProvider, n);
            return DPIUtil.scaleImageData(this.device, elementAtZoom.element(), n, elementAtZoom.zoom());
        }
        if (this.imageFileNameProvider != null) {
            DPIUtil.ElementAtZoom<String> elementAtZoom = DPIUtil.validateAndGetImagePathAtZoom(this.imageFileNameProvider, n);
            return DPIUtil.scaleImageData(this.device, new ImageData(elementAtZoom.element()), n, elementAtZoom.zoom());
        }
        if (this.imageGcDrawer != null) {
            return this.drawWithImageGcDrawer(this.width, this.height, n);
        }
        return DPIUtil.scaleImageData(this.device, this.getImageDataAtCurrentZoom(), n, this.currentDeviceZoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageData drawWithImageGcDrawer(int n, int n2, int n3) {
        Image image;
        ImageData imageData;
        int n4 = this.imageGcDrawer.getGcStyle();
        if ((n4 & 0x40000000) != 0) {
            imageData = new ImageData(n, n2, 24, new PaletteData(255, 65280, 0xFF0000));
            imageData.alphaData = new byte[n * n2];
            image = new Image(this.device, imageData, n3);
        } else {
            image = new Image(this.device, n, n2);
        }
        imageData = new GC((Drawable)image, n4);
        try {
            this.imageGcDrawer.drawOn((GC)imageData, n, n2);
            ImageData imageData2 = image.getImageData(n3);
            this.imageGcDrawer.postProcess(imageData2);
            ImageData imageData3 = imageData2;
            return imageData3;
        }
        finally {
            imageData.dispose();
            image.dispose();
        }
    }

    public static Image gtk_new(Device device, int n, long l, long l2) {
        Image image = new Image(device);
        image.type = n;
        image.surface = l;
        image.mask = l2;
        return image;
    }

    public static Image gtk_new_from_pixbuf(Device device, int n, long l) {
        Image image = new Image(device);
        image.createFromPixbuf(n, l);
        image.type = n;
        return image;
    }

    public int hashCode() {
        if (this.imageDataProvider != null) {
            return this.imageDataProvider.hashCode();
        }
        if (this.imageFileNameProvider != null) {
            return this.imageFileNameProvider.hashCode();
        }
        if (this.imageGcDrawer != null) {
            return Objects.hash(this.imageGcDrawer, this.width, this.height);
        }
        return (int)this.surface;
    }

    void init(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.surface = GTK.GTK4 ? Cairo.cairo_image_surface_create((int)1, (int)n, (int)n2) : GDK.gdk_window_create_similar_surface((long)GDK.gdk_get_default_root_window(), (int)4096, (int)n, (int)n2);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        this.currentDeviceZoom = 100;
        Cairo.cairo_surface_set_device_scale((long)this.surface, (double)1.0, (double)1.0);
        long l = Cairo.cairo_create((long)this.surface);
        if (l == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_set_source_rgb((long)l, (double)1.0, (double)1.0, (double)1.0);
        Cairo.cairo_rectangle((long)l, (double)0.0, (double)0.0, (double)n, (double)n2);
        Cairo.cairo_fill((long)l);
        Cairo.cairo_destroy((long)l);
        this.width = n;
        this.height = n2;
    }

    void init(ImageData imageData) {
        this.init(imageData, DPIUtil.getDeviceZoom());
    }

    private void init(ImageData imageData, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (imageData == null) {
            SWT.error(4);
        }
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        int n8 = imageData.width;
        int n9 = imageData.height;
        double d = (float)n / 100.0f;
        this.width = (int)Math.round((double)n8 / d);
        this.height = (int)Math.round((double)n9 / d);
        boolean bl = imageData.transparentPixel != -1 || imageData.alpha != -1 || imageData.maskData != null || imageData.alphaData != null;
        int n10 = bl ? 0 : 1;
        this.surface = Cairo.cairo_image_surface_create((int)n10, (int)n8, (int)n9);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_surface_set_device_scale((long)this.surface, (double)d, (double)d);
        int n11 = Cairo.cairo_image_surface_get_stride((long)this.surface);
        long l = Cairo.cairo_image_surface_get_data((long)this.surface);
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 32;
        if (OS.BIG_ENDIAN) {
            n12 = 0;
            n13 = 1;
            n14 = 2;
            n15 = 3;
            n7 = 65280;
            n6 = 0xFF0000;
            n5 = -16777216;
            n4 = 1;
        } else {
            n12 = 3;
            n13 = 2;
            n14 = 1;
            n15 = 0;
            n7 = 0xFF0000;
            n6 = 65280;
            n5 = 255;
            n4 = 0;
        }
        byte[] byArray = imageData.data;
        if (!paletteData.isDirect || imageData.depth != n16 || n11 != imageData.bytesPerLine || paletteData.redMask != n7 || paletteData.greenMask != n6 || paletteData.blueMask != n5 || n4 != imageData.getByteOrder()) {
            byArray = new byte[n11 * n9];
            if (paletteData.isDirect) {
                ImageData.blit((byte[])imageData.data, (int)imageData.depth, (int)imageData.bytesPerLine, (int)imageData.getByteOrder(), (int)n8, (int)n9, (int)paletteData.redMask, (int)paletteData.greenMask, (int)paletteData.blueMask, (byte[])byArray, (int)n16, (int)n11, (int)n4, (int)n8, (int)n9, (int)n7, (int)n6, (int)n5, (boolean)false, (boolean)false);
            } else {
                RGB[] rGBArray = paletteData.getRGBs();
                n3 = rGBArray.length;
                byte[] byArray2 = new byte[n3];
                byte[] byArray3 = new byte[n3];
                byte[] byArray4 = new byte[n3];
                for (n2 = 0; n2 < rGBArray.length; ++n2) {
                    RGB rGB = rGBArray[n2];
                    if (rGB == null) continue;
                    byArray2[n2] = (byte)rGB.red;
                    byArray3[n2] = (byte)rGB.green;
                    byArray4[n2] = (byte)rGB.blue;
                }
                ImageData.blit((int)n8, (int)n9, (byte[])imageData.data, (int)imageData.depth, (int)imageData.bytesPerLine, (int)imageData.getByteOrder(), (byte[])byArray2, (byte[])byArray3, (byte[])byArray4, (byte[])byArray, (int)n16, (int)n11, (int)n4, (int)n7, (int)n6, (int)n5);
            }
        }
        boolean bl2 = imageData.getTransparencyType() == 2;
        int n17 = this.type = bl2 ? 1 : 0;
        if (bl2 || imageData.transparentPixel != -1) {
            if (imageData.transparentPixel != -1) {
                RGB rGB = null;
                if (paletteData.isDirect) {
                    rGB = paletteData.getRGB(imageData.transparentPixel);
                } else if (imageData.transparentPixel < paletteData.colors.length) {
                    rGB = paletteData.getRGB(imageData.transparentPixel);
                }
                if (rGB != null) {
                    this.transparentPixel = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                }
            }
            ImageData imageData2 = imageData.getTransparencyMask();
            int n18 = 0;
            for (int i = 0; i < n9; ++i) {
                int n19 = 0;
                while (n19 < n8) {
                    n2 = imageData2.getPixel(n19, i) == 0 ? 0 : 255;
                    int n20 = (byArray[n18 + n13] & 0xFF) * n2 + 128;
                    n20 = n20 + (n20 >> 8) >> 8;
                    int n21 = (byArray[n18 + n14] & 0xFF) * n2 + 128;
                    n21 = n21 + (n21 >> 8) >> 8;
                    int n22 = (byArray[n18 + n15] & 0xFF) * n2 + 128;
                    n22 = n22 + (n22 >> 8) >> 8;
                    byArray[n18 + n12] = (byte)n2;
                    byArray[n18 + n13] = (byte)n20;
                    byArray[n18 + n14] = (byte)n21;
                    byArray[n18 + n15] = (byte)n22;
                    ++n19;
                    n18 += 4;
                }
            }
        } else if (imageData.alpha != -1) {
            n3 = imageData.alpha;
            int n23 = 0;
            for (int i = 0; i < n9; ++i) {
                int n24 = 0;
                while (n24 < n8) {
                    n2 = (byArray[n23 + n13] & 0xFF) * n3 + 128;
                    n2 = n2 + (n2 >> 8) >> 8;
                    int n25 = (byArray[n23 + n14] & 0xFF) * n3 + 128;
                    n25 = n25 + (n25 >> 8) >> 8;
                    int n26 = (byArray[n23 + n15] & 0xFF) * n3 + 128;
                    n26 = n26 + (n26 >> 8) >> 8;
                    byArray[n23 + n12] = (byte)n3;
                    byArray[n23 + n13] = (byte)n2;
                    byArray[n23 + n14] = (byte)n25;
                    byArray[n23 + n15] = (byte)n26;
                    ++n24;
                    n23 += 4;
                }
            }
        } else if (imageData.alphaData != null) {
            byte[] byArray5 = imageData.alphaData;
            int n27 = 0;
            for (int i = 0; i < n9; ++i) {
                int n28 = 0;
                while (n28 < n8) {
                    n2 = byArray5[i * n8 + n28] & 0xFF;
                    int n29 = (byArray[n27 + n13] & 0xFF) * n2 + 128;
                    n29 = n29 + (n29 >> 8) >> 8;
                    int n30 = (byArray[n27 + n14] & 0xFF) * n2 + 128;
                    n30 = n30 + (n30 >> 8) >> 8;
                    int n31 = (byArray[n27 + n15] & 0xFF) * n2 + 128;
                    n31 = n31 + (n31 >> 8) >> 8;
                    byArray[n27 + n12] = (byte)n2;
                    byArray[n27 + n13] = (byte)n29;
                    byArray[n27 + n14] = (byte)n30;
                    byArray[n27 + n15] = (byte)n31;
                    ++n28;
                    n27 += 4;
                }
            }
        }
        C.memmove((long)l, (byte[])byArray, (long)(n11 * n9));
        Cairo.cairo_surface_mark_dirty((long)this.surface);
    }

    public long internal_new_GC(GCData gCData) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long l = Cairo.cairo_create((long)this.surface);
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= 0x2000000;
            } else if ((gCData.style & 0x4000000) != 0) {
                gCData.style |= 0x8000000;
            }
            gCData.device = this.device;
            gCData.foregroundRGBA = Device.COLOR_BLACK.handle;
            gCData.backgroundRGBA = Device.COLOR_WHITE.handle;
            gCData.font = this.device.systemFont;
            gCData.image = this;
        }
        return l;
    }

    public void internal_dispose_GC(long l, GCData gCData) {
        Cairo.cairo_destroy((long)l);
    }

    public boolean isDisposed() {
        return this.surface == 0L;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        if (this.imageFileNameProvider != null) {
            return "Image {" + this.imageFileNameProvider.getImagePath(100) + "}";
        }
        return "Image {" + this.surface + "}";
    }

    public static void drawAtSize(GC gC, ImageData imageData, int n, int n2) {
        StrictChecks.runWithStrictChecksDisabled(() -> {
            Image image = new Image(gC.device, n -> imageData);
            gC.drawImage(image, 0, 0, imageData.width, imageData.height, 0, 0, n, n2);
            image.dispose();
        });
    }

    private class CachedImageAtSize {
        private Image image;

        private CachedImageAtSize() {
        }

        public void destroy() {
            if (this.image != null) {
                this.image.dispose();
                this.image = null;
            }
        }

        private Optional<Image> refresh(int n, int n2) {
            int n3;
            int n4 = DPIUtil.pointToPixel(n, DPIUtil.getDeviceZoom());
            if (this.isReusable(n4, n3 = DPIUtil.pointToPixel(n2, DPIUtil.getDeviceZoom()))) {
                return Optional.of(this.image);
            }
            this.destroy();
            Optional<Image> optional = this.loadImageAtSize(n4, n3);
            this.image = optional.orElse(null);
            return optional;
        }

        private boolean isReusable(int n, int n2) {
            return this.image != null && this.image.height == n2 && this.image.width == n;
        }

        private Optional<Image> loadImageAtSize(int n, int n2) {
            Optional<ImageData> optional = this.loadImageDataAtExactSize(n, n2);
            if (optional.isEmpty()) {
                return Optional.empty();
            }
            Image image = new Image(Image.this.device, optional.get(), DPIUtil.getDeviceZoom());
            if (Image.this.styleFlag != 0) {
                Image image2 = new Image(Image.this.device, image, Image.this.styleFlag);
                image.dispose();
                image = image2;
            }
            return Optional.of(image);
        }

        private Optional<ImageData> loadImageDataAtExactSize(int n, int n2) {
            String string;
            ImageDataProvider imageDataProvider = Image.this.imageDataProvider;
            if (imageDataProvider instanceof ImageDataAtSizeProvider) {
                ImageDataAtSizeProvider imageDataAtSizeProvider = (ImageDataAtSizeProvider)imageDataProvider;
                if ((imageDataProvider = imageDataAtSizeProvider.getImageData(n, n2)) == null) {
                    SWT.error(5, null, " ImageDataAtSizeProvider returned null for width=" + n + ", height=" + n2);
                }
                return Optional.of(imageDataProvider);
            }
            if (Image.this.imageFileNameProvider != null && ImageDataLoader.isDynamicallySizable((String)(string = DPIUtil.validateAndGetImagePathAtZoom(Image.this.imageFileNameProvider, 100).element()))) {
                imageDataProvider = ImageDataLoader.loadBySize((String)string, (int)n, (int)n2);
                return Optional.of(imageDataProvider);
            }
            return Optional.empty();
        }
    }
}

