/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.ImageGcDrawer;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;
    private static int nativeDeviceZoom = 100;
    private static final AutoScaleMethod AUTO_SCALE_METHOD_SETTING;
    private static AutoScaleMethod autoScaleMethod;
    private static String autoScaleValue;
    private static final Set<String> ALLOWED_AUTOSCALE_VALUES_FOR_UPDATE_ON_RUNTIME;
    static final String SWT_AUTOSCALE_UPDATE_ON_RUNTIME = "swt.autoScale.updateOnRuntime";
    private static final String SWT_AUTOSCALE = "swt.autoScale";
    private static final String SWT_AUTOSCALE_METHOD = "swt.autoScale.method";
    private static UseSmoothScalingProvider useSmoothScalingByDefaultProvider;

    static String getAutoScaleValue() {
        return autoScaleValue;
    }

    static void setAutoScaleValue(String string) {
        autoScaleValue = string;
    }

    public static boolean isSetupCompatibleToMonitorSpecificScaling() {
        if (DPIUtil.getAutoScaleValue() == null) {
            return false;
        }
        if (ALLOWED_AUTOSCALE_VALUES_FOR_UPDATE_ON_RUNTIME.contains(DPIUtil.getAutoScaleValue().toLowerCase())) {
            return true;
        }
        try {
            Integer.parseInt(DPIUtil.getAutoScaleValue());
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isMonitorSpecificScalingActive() {
        boolean bl = Boolean.getBoolean(SWT_AUTOSCALE_UPDATE_ON_RUNTIME);
        return bl;
    }

    public static int pixelToPoint(int n, int n2) {
        if (n2 == 100 || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor(n2);
        return Math.round((float)n / f);
    }

    public static float pixelToPoint(float f, int n) {
        if (n == 100 || f == -1.0f) {
            return f;
        }
        float f2 = DPIUtil.getScalingFactor(n);
        return f / f2;
    }

    public static ImageData scaleImageData(Device device, ImageData imageData, int n, int n2) {
        if (imageData == null || n == n2 || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f = (float)n / (float)n2;
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    public static ImageData scaleImageData(Device device, ElementAtZoom<ImageData> elementAtZoom, int n) {
        return DPIUtil.scaleImageData(device, elementAtZoom.element(), n, elementAtZoom.zoom());
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, float f) {
        int n = imageData.width;
        int n2 = imageData.height;
        int n3 = Math.round((float)n * f);
        int n4 = Math.round((float)n2 * f);
        return DPIUtil.scaleImage(device, imageData, Image::drawAtSize, n3, n4);
    }

    private static ImageData scaleImage(Device device, final ImageData imageData, final ImageDrawFunction imageDrawFunction, int n, int n2) {
        boolean bl;
        int n3 = 100;
        boolean bl2 = bl = DPIUtil.isSmoothScalingEnabled() && imageData.getTransparencyType() != 2;
        if (bl) {
            ImageGcDrawer imageGcDrawer = new ImageGcDrawer(){

                public void drawOn(GC gC, int n, int n2) {
                    gC.setAntialias(1);
                    imageDrawFunction.draw(gC, imageData, n, n2);
                }

                public int getGcStyle() {
                    return 0x40000000;
                }
            };
            Image image = new Image(device, imageGcDrawer, n, n2);
            ImageData imageData2 = image.getImageData(n3);
            image.dispose();
            return imageData2;
        }
        return imageData.scaledTo(n, n2);
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int n, int n2) {
        return DPIUtil.scaleImage(device, imageData, Image::drawAtSize, n, n2);
    }

    public static boolean isSmoothScalingEnabled() {
        return autoScaleMethod == AutoScaleMethod.SMOOTH;
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int n) {
        if (deviceZoom == n || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float f = (float)deviceZoom / (float)n;
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    public static float getScalingFactor(int n) {
        return DPIUtil.getScalingFactor(n, 100);
    }

    public static float getScalingFactor(int n, int n2) {
        if (n <= 0) {
            n = deviceZoom;
        }
        return (float)n / (float)n2;
    }

    public static int mapDPIToZoom(int n) {
        double d = (double)n * 100.0 / 96.0;
        int n2 = (int)Math.round(d);
        return n2;
    }

    public static int mapZoomToDPI(int n) {
        double d = (double)n / 100.0 * 96.0;
        int n2 = (int)Math.round(d);
        return n2;
    }

    public static void validateLinearScaling(ImageDataProvider imageDataProvider) {
        ImageData imageData = imageDataProvider.getImageData(100);
        ImageData imageData2 = imageDataProvider.getImageData(200);
        if (imageData2 == null) {
            return;
        }
        if (imageData2.width != 2 * imageData.width || imageData2.height != 2 * imageData.height) {
            System.err.println(String.format("***WARNING: ImageData should be linearly scaled across zooms but size is (%d, %d) at 100%% and (%d, %d) at 200%%.", imageData.width, imageData.height, imageData2.width, imageData2.height));
            new Error().printStackTrace(System.err);
        }
    }

    public static int pointToPixel(int n, int n2) {
        if (n2 == 100 || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor(n2);
        return Math.round((float)n * f);
    }

    public static ElementAtZoom<ImageData> validateAndGetImageDataAtZoom(ImageDataProvider imageDataProvider, int n2) {
        ElementAtZoom<ImageData> elementAtZoom;
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        if ((elementAtZoom = DPIUtil.getElementAtZoom(n -> imageDataProvider.getImageData(n.intValue()), n2)) == null) {
            SWT.error(5, null, ": ImageDataProvider [" + String.valueOf(imageDataProvider) + "] returns null ImageData at 100% zoom.");
        }
        return elementAtZoom;
    }

    public static ElementAtZoom<String> validateAndGetImagePathAtZoom(ImageFileNameProvider imageFileNameProvider, int n2) {
        ElementAtZoom<String> elementAtZoom;
        if (imageFileNameProvider == null) {
            SWT.error(4);
        }
        if ((elementAtZoom = DPIUtil.getElementAtZoom(n -> imageFileNameProvider.getImagePath(n.intValue()), n2)) == null) {
            SWT.error(5, null, ": ImageFileNameProvider [" + String.valueOf(imageFileNameProvider) + "] returns null filename at 100% zoom.");
        }
        return elementAtZoom;
    }

    private static <T> ElementAtZoom<T> getElementAtZoom(Function<Integer, T> function, int n) {
        T t;
        T t2 = function.apply(n);
        if (t2 != null) {
            return new ElementAtZoom<T>(t2, n);
        }
        if (n > 100 && n <= 150 && (t = function.apply(150)) != null) {
            return new ElementAtZoom<T>(t, 150);
        }
        if (n > 100 && (t = function.apply(200)) != null) {
            return new ElementAtZoom<T>(t, 200);
        }
        if (n != 100 && (t = function.apply(100)) != null) {
            return new ElementAtZoom<T>(t, 100);
        }
        return null;
    }

    public static int getNativeDeviceZoom() {
        return nativeDeviceZoom;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int n) {
        boolean bl;
        int n2;
        nativeDeviceZoom = n;
        deviceZoom = n2 = DPIUtil.getZoomForAutoscaleProperty(n);
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(n2));
        boolean bl2 = bl = SWT.getPlatform().equals("gtk") && n2 == 100;
        if (!bl && AUTO_SCALE_METHOD_SETTING == AutoScaleMethod.AUTO) {
            autoScaleMethod = useSmoothScalingByDefaultProvider.shouldUseSmoothScaling() ? AutoScaleMethod.SMOOTH : AutoScaleMethod.NEAREST;
        }
    }

    static void setUseSmoothScalingByDefaultProvider(UseSmoothScalingProvider useSmoothScalingProvider) {
        useSmoothScalingByDefaultProvider = useSmoothScalingProvider;
    }

    public static int getZoomForAutoscaleProperty(int n) {
        return DPIUtil.getZoomForAutoscaleProperty(n, autoScaleValue);
    }

    private static int getZoomForAutoscaleProperty(int n, String string) {
        int n2 = 0;
        if (string != null) {
            if ("false".equalsIgnoreCase(string)) {
                n2 = 100;
            } else if ("half".equalsIgnoreCase(string)) {
                n2 = (int)Math.rint((double)n / 50.0) * 50;
            } else if ("quarter".equalsIgnoreCase(string)) {
                n2 = Math.round((float)n / 25.0f) * 25;
            } else if ("exact".equalsIgnoreCase(string)) {
                n2 = n;
            } else {
                try {
                    int n3 = Integer.parseInt(string);
                    n2 = Math.max(Math.min(n3, 1600), 25);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (n2 == 0) {
            n2 = Math.max((n + 25) / 100 * 100, 100);
        }
        return n2;
    }

    public static void runWithAutoScaleValue(String string, Runnable runnable) {
        String string2 = autoScaleValue;
        autoScaleValue = string;
        deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        try {
            runnable.run();
        }
        finally {
            autoScaleValue = string2;
            deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        }
    }

    static {
        ALLOWED_AUTOSCALE_VALUES_FOR_UPDATE_ON_RUNTIME = Set.of("quarter", "exact", "false");
        autoScaleValue = System.getProperty(SWT_AUTOSCALE, "false");
        String string = System.getProperty(SWT_AUTOSCALE_METHOD);
        AUTO_SCALE_METHOD_SETTING = AutoScaleMethod.forString(string).orElse(AutoScaleMethod.AUTO);
        autoScaleMethod = AUTO_SCALE_METHOD_SETTING != AutoScaleMethod.AUTO ? AUTO_SCALE_METHOD_SETTING : AutoScaleMethod.NEAREST;
        useSmoothScalingByDefaultProvider = () -> false;
    }

    public record ElementAtZoom<T>(T element, int zoom) {
        public ElementAtZoom {
            if (t == null) {
                SWT.error(4);
            }
            if (n <= 0) {
                SWT.error(5);
            }
        }
    }

    @FunctionalInterface
    private static interface ImageDrawFunction {
        public void draw(GC var1, ImageData var2, int var3, int var4);
    }

    private static enum AutoScaleMethod {
        AUTO,
        NEAREST,
        SMOOTH;


        public static Optional<AutoScaleMethod> forString(String string) {
            for (AutoScaleMethod autoScaleMethod : AutoScaleMethod.values()) {
                if (!autoScaleMethod.name().equalsIgnoreCase(string)) continue;
                return Optional.of(autoScaleMethod);
            }
            return Optional.empty();
        }
    }

    @FunctionalInterface
    static interface UseSmoothScalingProvider {
        public boolean shouldUseSmoothScaling();
    }
}

