/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import java.util.Optional;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.AsyncReadyCallback;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    long handle;
    static final char SEPARATOR = File.separatorChar;
    static final char EXTENSION_SEPARATOR = ';';
    static final char FILE_EXTENSION_SEPARATOR = '.';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    String computeResultChooserDialog(long l) {
        long l2;
        long l3;
        this.fullPath = null;
        if ((this.style & 2) != 0) {
            l3 = 0L;
            l3 = GTK.GTK4 ? (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? l : GTK4.gtk_file_chooser_get_files((long)this.handle)) : (this.uriMode ? GTK3.gtk_file_chooser_get_uris((long)this.handle) : GTK3.gtk_file_chooser_get_filenames((long)this.handle));
            int n = GTK.GTK4 ? OS.g_list_model_get_n_items(l3) : OS.g_slist_length(l3);
            this.fileNames = new String[n];
            var6_8 = l3;
            var8_9 = 0;
            for (int i = 0; i < n; ++i) {
                long l4 = GTK.GTK4 ? OS.g_list_model_get_item(l3, i) : OS.g_slist_data(var6_8);
                long l5 = 0L;
                if (this.uriMode) {
                    l5 = GTK.GTK4 ? OS.g_file_get_uri(l4) : l4;
                } else {
                    if (GTK.GTK4) {
                        l4 = OS.g_file_get_path(l4);
                    }
                    if ((l5 = OS.g_filename_to_utf8(l4, -1L, null, null, null)) == 0L) {
                        l5 = OS.g_filename_display_name(l4);
                    }
                }
                if (l4 != l5) {
                    OS.g_free(l4);
                }
                if (l5 != 0L) {
                    long[] lArray = new long[1];
                    long l6 = OS.g_utf8_to_utf16(l5, -1L, null, lArray, null);
                    OS.g_free(l5);
                    if (l6 != 0L) {
                        int n2 = (int)lArray[0];
                        char[] cArray = new char[n2];
                        C.memmove((char[])cArray, (long)l6, (long)(n2 * 2));
                        OS.g_free(l6);
                        this.fullPath = new String(cArray);
                        this.fileNames[var8_9++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                if (GTK.GTK4) continue;
                var6_8 = OS.g_slist_next(var6_8);
            }
            if (var8_9 != 0 && var8_9 != n) {
                String[] stringArray = new String[var8_9];
                System.arraycopy(this.fileNames, 0, stringArray, 0, var8_9);
                this.fileNames = stringArray;
            }
            if (GTK.GTK4) {
                OS.g_object_unref(l3);
            } else {
                OS.g_slist_free(l3);
            }
        } else {
            l3 = 0L;
            if (this.uriMode) {
                if (GTK.GTK4) {
                    if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                        l = GTK4.gtk_file_chooser_get_file((long)this.handle);
                    }
                    l3 = OS.g_file_get_uri(l);
                } else {
                    l3 = GTK3.gtk_file_chooser_get_uri((long)this.handle);
                }
            } else {
                long l7;
                if (GTK.GTK4) {
                    if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                        l = GTK4.gtk_file_chooser_get_file((long)this.handle);
                    }
                    l7 = OS.g_file_get_path(l);
                } else {
                    l7 = GTK3.gtk_file_chooser_get_filename((long)this.handle);
                }
                if (l7 != 0L) {
                    l3 = OS.g_filename_to_utf8(l7, -1L, null, null, null);
                    if (l3 == 0L) {
                        l3 = OS.g_filename_display_name(l7);
                    }
                    if (l7 != l3) {
                        OS.g_free(l7);
                    }
                }
            }
            if (l3 != 0L) {
                long[] lArray = new long[1];
                var6_8 = OS.g_utf8_to_utf16(l3, -1L, null, lArray, null);
                OS.g_free(l3);
                if (var6_8 != 0L) {
                    var8_9 = (int)lArray[0];
                    char[] cArray = new char[var8_9];
                    C.memmove((char[])cArray, (long)var6_8, (long)(var8_9 * 2));
                    OS.g_free(var6_8);
                    this.fullPath = new String(cArray);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        l3 = GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_file_dialog_get_default_filter((long)this.handle) : GTK.gtk_file_chooser_get_filter((long)this.handle);
        if (l3 != 0L && (l2 = GTK.gtk_file_filter_get_name((long)l3)) != 0L) {
            int n = C.strlen((long)l2);
            byte[] byArray = new byte[n];
            C.memmove((byte[])byArray, (long)l2, (long)n);
            String string = new String(Converter.mbcsToWcs((byte[])byArray));
            for (int i = 0; i < this.filterExtensions.length; ++i) {
                if (this.filterNames.length > 0) {
                    if (!this.filterNames[i].equals(string)) continue;
                    this.filterIndex = i;
                    break;
                }
                if (!this.filterExtensions[i].equals(string)) continue;
                this.filterIndex = i;
                break;
            }
        }
        if (this.fullPath != null) {
            int n = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(n + 1);
            this.filterPath = this.fullPath.substring(0, n);
        }
        return this.fullPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        try {
            return this.openDialog().orElse(null);
        }
        catch (SWTException sWTException) {
            if (sWTException.code == 51) {
                return null;
            }
            throw sWTException;
        }
    }

    public Optional<String> openDialog() {
        if ("true".equals(System.getProperty("qftest.swt.testing"))) {
            return Optional.ofNullable(this.openChooserDialog());
        }
        return this.openNativeChooserDialog();
    }

    Optional<String> openNativeChooserDialog() {
        Object object;
        int n;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        int n2 = (this.style & 0x2000) != 0 ? 1 : 0;
        final long l = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_file_dialog_new() : GTK.gtk_file_chooser_native_new((byte[])byArray, (long)l, (int)n2, null, null);
        if (this.handle == 0L) {
            this.error(2);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            GTK4.gtk_file_dialog_set_title((long)this.handle, (byte[])byArray);
        }
        if (this.uriMode && !GTK.GTK4) {
            GTK3.gtk_file_chooser_set_local_only((long)this.handle, (boolean)false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        this._qfGetDisplay().runDialogShownHooks(this, this.handle);
        int n3 = 0;
        long l2 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n3 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l2 = OS.g_signal_add_emission_hook(n3, 0, display.emissionProc, this.handle, 0L);
        }
        long l3 = 0L;
        if (GTK.GTK4) {
            if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                l3 = (this.style & 2) != 0 ? SyncDialogUtil.run((Display)display, (AsyncReadyCallback)new AsyncReadyCallback(){

                    public void async(long l2) {
                        GTK4.gtk_file_dialog_open_multiple((long)FileDialog.this.handle, (long)l, (long)0L, (long)l2, (long)0L);
                    }

                    public long await(long l2) {
                        return GTK4.gtk_file_dialog_open_multiple_finish((long)FileDialog.this.handle, (long)l2, null);
                    }
                }) : ((this.style & 0x2000) != 0 ? SyncDialogUtil.run((Display)display, (AsyncReadyCallback)new AsyncReadyCallback(){

                    public void async(long l2) {
                        GTK4.gtk_file_dialog_save((long)FileDialog.this.handle, (long)l, (long)0L, (long)l2, (long)0L);
                    }

                    public long await(long l2) {
                        return GTK4.gtk_file_dialog_save_finish((long)FileDialog.this.handle, (long)l2, null);
                    }
                }) : SyncDialogUtil.run((Display)display, (AsyncReadyCallback)new AsyncReadyCallback(){

                    public void async(long l2) {
                        GTK4.gtk_file_dialog_open((long)FileDialog.this.handle, (long)l, (long)0L, (long)l2, (long)0L);
                    }

                    public long await(long l2) {
                        return GTK4.gtk_file_dialog_open_finish((long)FileDialog.this.handle, (long)l2, null);
                    }
                }));
                n = l3 != 0L ? -3 : -6;
            } else {
                n = SyncDialogUtil.run((Display)display, (long)this.handle, (boolean)true);
            }
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK3.gtk_native_dialog_run((long)this.handle);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n3, l2);
        }
        Optional<Object> optional = Optional.empty();
        if (n == -3) {
            optional = Optional.ofNullable(this.computeResultChooserDialog(l3));
        }
        if ((object = this._qfGetDisplay().runDialogClosedHooks(this, optional.orElse(null))) instanceof String || object == null) {
            optional = Optional.ofNullable((String)object);
        }
        display.removeIdleProc();
        OS.g_object_unref(this.handle);
        if (optional.isPresent() || n == -6) {
            return optional;
        }
        throw new SWTException(51);
    }

    String openChooserDialog() {
        Object object;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        int n = (this.style & 0x2000) != 0 ? 1 : 0;
        long l = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = display.getDismissalAlignment() == 131072 ? GTK.gtk_file_chooser_dialog_new((byte[])byArray, (long)l, (int)n, (byte[])GTK.GTK_NAMED_LABEL_CANCEL, (int)-6, (byte[])GTK.GTK_NAMED_LABEL_OK, (int)-5, (long)0L) : GTK.gtk_file_chooser_dialog_new((byte[])byArray, (long)l, (int)n, (byte[])GTK.GTK_NAMED_LABEL_OK, (int)-5, (byte[])GTK.GTK_NAMED_LABEL_CANCEL, (int)-6, (long)0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        GTK.gtk_window_set_modal((long)this.handle, (boolean)true);
        long l2 = GTK.gtk_window_get_group((long)0L);
        GTK.gtk_window_group_add_window((long)l2, (long)this.handle);
        long l3 = GTK3.gtk_window_get_icon_list((long)l);
        if (l3 != 0L) {
            GTK3.gtk_window_set_icon_list((long)this.handle, (long)l3);
            OS.g_list_free(l3);
        }
        if (this.uriMode) {
            GTK3.gtk_file_chooser_set_local_only((long)this.handle, (boolean)false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String string = null;
        this._qfGetDisplay().runDialogShownHooks(this, this.handle);
        Dialog dialog = null;
        if (GTK.gtk_window_get_modal((long)this.handle)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n2 = 0;
        long l4 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l4 = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, this.handle, 0L);
        }
        display.externalEventLoop = true;
        display.sendPreExternalEventDispatchEvent();
        int n3 = GTK3.gtk_dialog_run((long)this.handle);
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
        display.externalEventLoop = false;
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l4);
        }
        if (GTK.gtk_window_get_modal((long)this.handle)) {
            display.setModalDialog(dialog);
        }
        if (n3 == -5) {
            long l5 = 0L;
            string = this.computeResultChooserDialog(l5);
        }
        if ((object = this._qfGetDisplay().runDialogClosedHooks(this, string)) instanceof String || object == null) {
            string = (String)object;
        }
        display.removeIdleProc();
        GTK3.gtk_widget_destroy((long)this.handle);
        return string;
    }

    void presetChooserDialog() {
        int n;
        if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0) && (this.style & 0x2002) == 2) {
            GTK.gtk_file_chooser_set_select_multiple((long)this.handle, (boolean)true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            if (this.fileName.equals("")) {
                this.fileName = "Untitled";
            }
            if (this.filterPath.length() > 0) {
                if (this.uriMode) {
                    var1_1 = Converter.wcsToMbcs((String)this.filterPath, (boolean)true);
                    if (GTK.GTK4) {
                        var2_3 = OS.g_file_new_for_uri((byte[])var1_1);
                        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                            GTK4.gtk_file_dialog_set_initial_folder((long)this.handle, (long)var2_3);
                        } else {
                            GTK4.gtk_file_chooser_set_current_folder((long)this.handle, (long)var2_3, (long)0L);
                        }
                        OS.g_object_unref(var2_3);
                    } else {
                        GTK3.gtk_file_chooser_set_current_folder_uri((long)this.handle, (byte[])var1_1);
                    }
                } else {
                    var1_1 = Converter.wcsToMbcs((String)(SEPARATOR + this.filterPath), (boolean)true);
                    var2_3 = OS.realpath((byte[])var1_1, null);
                    if (var2_3 != 0L) {
                        if (GTK.GTK4) {
                            long l = OS.g_file_new_for_path((byte[])var1_1);
                            if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                                GTK4.gtk_file_dialog_set_initial_folder((long)this.handle, (long)l);
                            } else {
                                GTK4.gtk_file_chooser_set_current_folder((long)this.handle, (long)l, (long)0L);
                            }
                            OS.g_object_unref(l);
                        } else {
                            GTK3.gtk_file_chooser_set_current_folder((long)this.handle, (long)var2_3);
                        }
                        OS.g_free(var2_3);
                    }
                }
            }
            if (this.fileName.length() > 0) {
                var1_1 = new StringBuilder();
                ((StringBuilder)var1_1).append(this.fileName);
                if (this.fileName.lastIndexOf(46) == -1 && this.filterExtensions.length != 0) {
                    String string = null;
                    string = this.filterIndex == -1 ? this.filterExtensions[0] : this.filterExtensions[this.filterIndex];
                    String string2 = null;
                    int n2 = string.indexOf(59);
                    string2 = n2 == -1 ? string.trim() : string.substring(0, n2).trim();
                    String string3 = string2.substring(n = string2.lastIndexOf(46));
                    if (!this.isGlobPattern(string3)) {
                        ((StringBuilder)var1_1).append(string3);
                    }
                }
                byte[] byArray = Converter.wcsToMbcs((String)((StringBuilder)var1_1).toString(), (boolean)true);
                if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                    GTK4.gtk_file_dialog_set_initial_name((long)this.handle, (byte[])byArray);
                } else {
                    GTK.gtk_file_chooser_set_current_name((long)this.handle, (byte[])byArray);
                }
            }
        } else {
            var1_1 = new StringBuilder();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    ((StringBuilder)var1_1).append(SEPARATOR);
                }
                ((StringBuilder)var1_1).append(this.filterPath);
                ((StringBuilder)var1_1).append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                ((StringBuilder)var1_1).append(this.fileName);
            }
            byte[] byArray = Converter.wcsToMbcs((String)((StringBuilder)var1_1).toString(), (boolean)true);
            if (GTK.GTK4) {
                long l;
                if (this.uriMode) {
                    l = OS.g_file_new_for_uri(byArray);
                    if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                        GTK4.gtk_file_dialog_set_initial_file((long)this.handle, (long)l);
                    } else {
                        GTK4.gtk_file_chooser_set_file((long)this.handle, (long)l, (long)0L);
                    }
                } else {
                    l = OS.g_file_new_for_path(byArray);
                    if (this.fileName.length() > 0) {
                        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                            GTK4.gtk_file_dialog_set_initial_file((long)this.handle, (long)l);
                        } else {
                            GTK4.gtk_file_chooser_set_file((long)this.handle, (long)l, (long)0L);
                        }
                    }
                }
                OS.g_object_unref(l);
            } else if (this.uriMode) {
                GTK3.gtk_file_chooser_set_uri((long)this.handle, (byte[])byArray);
            } else {
                long l = OS.realpath(byArray, null);
                if (l != 0L) {
                    if (this.fileName.length() > 0) {
                        GTK3.gtk_file_chooser_set_filename((long)this.handle, (long)l);
                    } else {
                        GTK3.gtk_file_chooser_set_current_folder((long)this.handle, (long)l);
                    }
                    OS.g_free(l);
                }
            }
        }
        if ((this.style & 0x2000) != 0 && !GTK.GTK4) {
            GTK3.gtk_file_chooser_set_do_overwrite_confirmation((long)this.handle, (boolean)this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        long l = 0L;
        long l2 = 0L;
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            l2 = OS.g_list_store_new(GTK.GTK_TYPE_FILE_FILTER());
        }
        for (n = 0; n < this.filterExtensions.length; ++n) {
            byte[] byArray;
            String string;
            if (this.filterExtensions[n] == null) continue;
            long l3 = GTK.gtk_file_filter_new();
            if (this.filterNames.length > n && this.filterNames[n] != null) {
                var8_17 = Converter.wcsToMbcs((String)this.filterNames[n], (boolean)true);
                GTK.gtk_file_filter_set_name((long)l3, (byte[])var8_17);
            } else {
                var8_17 = Converter.wcsToMbcs((String)this.filterExtensions[n], (boolean)true);
                GTK.gtk_file_filter_set_name((long)l3, (byte[])var8_17);
            }
            int n3 = 0;
            int n4 = this.filterExtensions[n].indexOf(59);
            while (n4 != -1) {
                string = this.filterExtensions[n].substring(n3, n4);
                byArray = Converter.wcsToMbcs((String)string, (boolean)true);
                GTK.gtk_file_filter_add_pattern((long)l3, (byte[])byArray);
                n3 = n4 + 1;
                n4 = this.filterExtensions[n].indexOf(59, n3);
            }
            string = this.filterExtensions[n].substring(n3);
            byArray = Converter.wcsToMbcs((String)string, (boolean)true);
            GTK.gtk_file_filter_add_pattern((long)l3, (byte[])byArray);
            if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                OS.g_list_store_append(l2, l3);
            } else {
                GTK.gtk_file_chooser_add_filter((long)this.handle, (long)l3);
            }
            if (n != this.filterIndex) continue;
            l = l3;
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            GTK4.gtk_file_dialog_set_filters((long)this.handle, (long)l2);
            OS.g_object_unref(l2);
        }
        if (l != 0L) {
            if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                GTK4.gtk_file_dialog_set_default_filter((long)this.handle, (long)l);
            } else {
                GTK.gtk_file_chooser_set_filter((long)this.handle, (long)l);
            }
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    private boolean isGlobPattern(String string) {
        return string.contains("*") || string.contains("?") || string.contains("[") && string.contains("]");
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String ... stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String ... stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    void setURIMode(boolean bl) {
        this.uriMode = bl;
    }
}

