/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.AsyncReadyCallback;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return false;
    }

    @Deprecated
    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        Object[] objectArray;
        Object[] objectArray2;
        boolean bl;
        int n;
        long l;
        byte[] byArray = Converter.javaStringToCString((String)this.title);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        final long l2 = GTK.GTK_VERSION >= OS.VERSION(4, 10, 0) ? GTK4.gtk_font_dialog_new() : GTK.gtk_font_chooser_dialog_new((byte[])byArray, (long)0L);
        if (l2 == 0L) {
            this.error(2);
        }
        if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
            GTK4.gtk_font_dialog_set_modal((long)l2, (boolean)true);
            GTK4.gtk_font_dialog_set_title((long)l2, (byte[])byArray);
        } else {
            long l3;
            if (this.parent != null) {
                l3 = this.parent.topHandle();
                GTK.gtk_window_set_transient_for((long)l2, (long)l3);
            }
            l3 = GTK.gtk_window_get_group((long)0L);
            GTK.gtk_window_group_add_window((long)l3, (long)l2);
            GTK.gtk_window_set_modal((long)l2, (boolean)true);
        }
        display.addIdleProc();
        Dialog dialog = display.getModalDialog();
        display.setModalDialog(this);
        if (this.fontData != null && GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
            Font font = new Font((Device)display, this.fontData);
            l = OS.pango_font_description_to_string(font.handle);
            n = C.strlen((long)l);
            byte[] byArray2 = new byte[n + 1];
            C.memmove((byte[])byArray2, (long)l, (long)n);
            font.dispose();
            OS.g_free(l);
            GTK.gtk_font_chooser_set_font((long)l2, (byte[])byArray2);
        }
        display.runDialogShownHooks(this, l2);
        int n2 = 0;
        l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, l2, 0L);
        }
        long l4 = 0L;
        if (GTK.GTK4) {
            if (GTK.GTK_VERSION >= OS.VERSION(4, 10, 0)) {
                final long l5 = this.parent != null ? this.parent.topHandle() : 0L;
                final Font font = this.fontData != null ? new Font((Device)display, this.fontData) : null;
                l4 = SyncDialogUtil.run((Display)display, (AsyncReadyCallback)new AsyncReadyCallback(){

                    public void async(long l) {
                        GTK4.gtk_font_dialog_choose_font((long)l2, (long)l5, (long)(font != null ? font.handle : 0L), (long)0L, (long)l, (long)0L);
                    }

                    public long await(long l) {
                        return GTK4.gtk_font_dialog_choose_font_finish((long)l2, (long)l, null);
                    }
                });
                if (font != null) {
                    font.dispose();
                }
                n = l4 != 0L ? -5 : -6;
            } else {
                n = SyncDialogUtil.run((Display)display, (long)l2, (boolean)false);
            }
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK3.gtk_dialog_run((long)l2);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l);
        }
        display.setModalDialog(dialog);
        boolean bl2 = bl = n == -5;
        if (bl) {
            if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                long l6 = GTK.gtk_font_chooser_get_font((long)l2);
                int n3 = C.strlen((long)l6);
                byte[] byArray3 = new byte[n3 + 1];
                C.memmove((byte[])byArray3, (long)l6, (long)n3);
                OS.g_free(l6);
                l4 = OS.pango_font_description_from_string(byArray3);
            }
            objectArray2 = Font.gtk_new((Device)display, (long)l4);
            this.fontData = objectArray2.getFontData()[0];
            OS.pango_font_description_free(l4);
        } else {
            this.fontData = null;
        }
        if (bl) {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = this.fontData;
            objectArray = objectArray3;
            objectArray3[1] = null;
        } else {
            objectArray = null;
        }
        objectArray2 = (Object[])display.runDialogClosedHooks(this, objectArray);
        if (objectArray2 != null) {
            this.fontData = (FontData)objectArray2[0];
            this.rgb = (RGB)objectArray2[1];
            bl = true;
        }
        display.removeIdleProc();
        if (GTK.GTK4) {
            if (GTK.GTK_VERSION < OS.VERSION(4, 10, 0)) {
                GTK4.gtk_window_destroy((long)l2);
            }
        } else {
            GTK3.gtk_widget_destroy((long)l2);
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean bl) {
    }

    @Deprecated
    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

