/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.EventListener;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.Tracker");
    Composite parent;
    Cursor cursor;
    long lastCursor;
    long window;
    long overlay;
    long surface;
    boolean tracking;
    boolean cancelled;
    boolean grabbed;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    int oldX;
    int oldY;
    long provider;
    Rectangle cachedCombinedDisplayResolution = Display.getDefault().getBounds();
    Rectangle cachedUnion = new Rectangle(0, 0, 0, 0);
    Boolean cachedBackgroundIsOpaque;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n) {
        super((Widget)composite, Tracker.checkStyle(n));
        this.parent = composite;
    }

    public Tracker(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.addTypedListener((EventListener)controlListener, 11, 10);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.addTypedListener((EventListener)keyListener, 2, 1);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = this.bounds.x + this.bounds.width / 2;
        int n2 = this.bounds.y;
        Point point = this.display.mapInPixels((Control)this.parent, null, n, n2);
        this.display.setCursorLocation(point);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        if (GTK.GTK4) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            this.display.getPointerPosition(dArray, dArray2);
            nArray[0] = (int)dArray[0];
            nArray2[0] = (int)dArray2[0];
        } else {
            this.display.getWindowPointerPosition(this.window, nArray, nArray2, nArray3);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n2 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        Point point = this.display.mapInPixels((Control)this.parent, null, n, n2);
        this.display.setCursorLocation(point);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        if (GTK.GTK4) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            this.display.getPointerPosition(dArray, dArray2);
            nArray[0] = (int)dArray[0];
            nArray2[0] = (int)dArray2[0];
        } else {
            this.display.getWindowPointerPosition(this.window, nArray, nArray2, nArray3);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    static int checkStyle(int n) {
        if ((n & 0x24480) == 0) {
            n |= 0x24480;
        }
        return n;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n = this.rectangles[0].x;
        int n2 = this.rectangles[0].y;
        int n3 = this.rectangles[0].x + this.rectangles[0].width;
        int n4 = this.rectangles[0].y + this.rectangles[0].height;
        for (int i = 1; i < this.rectangles.length; ++i) {
            int n5;
            int n6;
            if (this.rectangles[i].x < n) {
                n = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < n2) {
                n2 = this.rectangles[i].y;
            }
            if ((n6 = this.rectangles[i].x + this.rectangles[i].width) > n3) {
                n3 = n6;
            }
            if ((n5 = this.rectangles[i].y + this.rectangles[i].height) <= n4) continue;
            n4 = n5;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            for (int i = 0; i < rectangleArray.length; ++i) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (this.bounds.width != 0) {
                    n = (rectangleArray[i].x - this.bounds.x) * 100 / this.bounds.width;
                    n3 = rectangleArray[i].width * 100 / this.bounds.width;
                } else {
                    n3 = 100;
                }
                if (this.bounds.height != 0) {
                    n2 = (rectangleArray[i].y - this.bounds.y) * 100 / this.bounds.height;
                    n4 = rectangleArray[i].height * 100 / this.bounds.height;
                } else {
                    n4 = 100;
                }
                rectangleArray2[i] = new Rectangle(n, n2, n3, n4);
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(Rectangle[] rectangleArray) {
        long l = 0L;
        if (GTK.GTK4) {
            if (this.parent != null) {
                l = this.gtk_widget_get_surface(this.parent.handle);
            }
        } else {
            l = GDK.gdk_get_default_root_window();
        }
        if (this.parent != null) {
            long l2 = this.parent.paintHandle();
            long l3 = l = GTK.GTK4 ? this.gtk_widget_get_surface(l2) : this.gtk_widget_get_window(l2);
        }
        if (l == 0L) {
            return;
        }
        if (this.overlay == 0L) {
            return;
        }
        GTK3.gtk_widget_shape_combine_region((long)this.overlay, (long)0L);
        boolean bl = true;
        this.cachedUnion.x = rectangleArray[0].x;
        this.cachedUnion.y = rectangleArray[0].y;
        this.cachedUnion.width = rectangleArray[0].width;
        this.cachedUnion.height = rectangleArray[0].height;
        if (rectangleArray.length > 1) {
            for (int i = 1; i < rectangleArray.length; ++i) {
                this.cachedUnion.add(rectangleArray[i]);
            }
        }
        if (this.parent != null) {
            this.cachedUnion = this.display.mapInPixels((Control)this.parent, null, this.cachedUnion);
        }
        if (!this.cachedCombinedDisplayResolution.intersects(this.cachedUnion)) {
            bl = false;
        }
        long l4 = Cairo.cairo_region_create();
        cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
        if (bl) {
            for (int i = 0; i < rectangleArray.length; ++i) {
                Rectangle rectangle = this.parent != null ? this.display.mapInPixels((Control)this.parent, null, rectangleArray[i]) : rectangleArray[i];
                cairo_rectangle_int_t2.x = rectangle.x;
                cairo_rectangle_int_t2.y = rectangle.y;
                cairo_rectangle_int_t2.width = rectangle.width + 1;
                cairo_rectangle_int_t2.height = 1;
                Cairo.cairo_region_union_rectangle((long)l4, (cairo_rectangle_int_t)cairo_rectangle_int_t2);
                cairo_rectangle_int_t2.width = 1;
                cairo_rectangle_int_t2.height = rectangle.height + 1;
                Cairo.cairo_region_union_rectangle((long)l4, (cairo_rectangle_int_t)cairo_rectangle_int_t2);
                cairo_rectangle_int_t2.x = rectangle.x + rectangle.width;
                Cairo.cairo_region_union_rectangle((long)l4, (cairo_rectangle_int_t)cairo_rectangle_int_t2);
                cairo_rectangle_int_t2.x = rectangle.x;
                cairo_rectangle_int_t2.y = rectangle.y + rectangle.height;
                cairo_rectangle_int_t2.width = rectangle.width + 1;
                cairo_rectangle_int_t2.height = 1;
                Cairo.cairo_region_union_rectangle((long)l4, (cairo_rectangle_int_t)cairo_rectangle_int_t2);
            }
            this.setTrackerBackground(true);
        } else {
            cairo_rectangle_int_t2.x = 0;
            cairo_rectangle_int_t2.y = 0;
            cairo_rectangle_int_t2.height = 1;
            cairo_rectangle_int_t2.width = 1;
            Cairo.cairo_region_union_rectangle((long)l4, (cairo_rectangle_int_t)cairo_rectangle_int_t2);
            this.setTrackerBackground(false);
        }
        GTK3.gtk_widget_shape_combine_region((long)this.overlay, (long)l4);
        Cairo.cairo_region_destroy((long)l4);
        if (GTK.GTK4) {
            long l5 = GTK4.gtk_native_get_surface((long)GTK4.gtk_widget_get_native((long)this.overlay));
            GDK.gdk_surface_hide((long)l5);
        } else {
            long l6 = GTK3.gtk_widget_get_window((long)this.overlay);
            GDK.gdk_window_hide((long)l6);
            GDK.gdk_window_show((long)l6);
        }
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i = 0; i < this.rectangles.length; ++i) {
            Rectangle rectangle = this.rectangles[i];
            rectangleArray[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    boolean grab() {
        long l = this.cursor != null ? this.cursor.handle : 0L;
        int n = this.gdk_pointer_grab(GTK.GTK4 ? this.surface : this.window, 0, false, 516, 0L, l, 0);
        return n == 0;
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        Control.mouseDown = false;
        return this.gtk_mouse(GTK.GTK4 ? 6 : 7, l, l2);
    }

    @Override
    long gtk3_key_press_event(long l, long l2) {
        long l3 = super.gtk3_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GDK.gdk_event_get_state((long)l2, (int[])nArray);
        GDK.gdk_event_get_keyval((long)l2, (int[])nArray2);
        int n = (nArray[0] & 4) != 0 ? 1 : 9;
        int n2 = 0;
        int n3 = 0;
        switch (nArray2[0]) {
            case 65307: {
                this.cancelled = true;
            }
            case 65293: {
                this.tracking = false;
                break;
            }
            case 65361: {
                n2 = -n;
                break;
            }
            case 65363: {
                n2 = n;
                break;
            }
            case 65362: {
                n3 = -n;
                break;
            }
            case 65364: {
                n3 = n;
            }
        }
        if (n2 != 0 || n3 != 0) {
            Rectangle rectangle;
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i = 0; i < this.rectangles.length; ++i) {
                rectangle = this.rectangles[i];
                rectangleArray2[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Event event = new Event();
            rectangle = new Rectangle(this.oldX + n2, this.oldY + n3, 0, 0);
            event.setBounds(rectangle);
            if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
                event.x = this.parent.getClientWidth() - event.width - event.x;
            }
            if ((this.style & 0x10) != 0) {
                Point point;
                this.resizeRectangles(n2, n3);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n4 = this.rectangles.length;
                    if (n4 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n4; ++i) {
                            if (this.rectangles[i].equals((Object)rectangleArray2[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(this.rectangles);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    this.oldX = point.x;
                    this.oldY = point.y;
                }
            } else {
                Point point;
                this.moveRectangles(n2, n3);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n5 = this.rectangles.length;
                    if (n5 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n5; ++i) {
                            if (this.rectangles[i].equals((Object)rectangleArray2[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(rectangleArray2);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
                if ((point = this.adjustMoveCursor()) != null) {
                    this.oldX = point.x;
                    this.oldY = point.y;
                }
            }
        }
        return l3;
    }

    @Override
    long gtk_motion_notify_event(long l, long l2) {
        long l3;
        long l4 = l3 = this.cursor != null ? this.cursor.handle : 0L;
        if (l3 != this.lastCursor) {
            this.ungrab();
            this.grabbed = this.grab();
            this.lastCursor = l3;
        }
        return this.gtk_mouse(GTK.GTK4 ? 4 : 3, l, l2);
    }

    long gtk_mouse(int n, long l, long l2) {
        Object[] objectArray;
        Object[] objectArray2;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            objectArray2 = new double[1];
            objectArray = new double[1];
            this.display.getPointerPosition((double[])objectArray2, (double[])objectArray);
            nArray[0] = (int)objectArray2[0];
            nArray2[0] = (int)objectArray[0];
        } else {
            this.display.getWindowPointerPosition(this.window, nArray, nArray2, null);
        }
        if (this.oldX != nArray[0] || this.oldY != nArray2[0]) {
            Rectangle rectangle;
            objectArray2 = this.rectangles;
            objectArray = new Rectangle[this.rectangles.length];
            for (int i = 0; i < this.rectangles.length; ++i) {
                rectangle = this.rectangles[i];
                objectArray[i] = (double)new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Event event = new Event();
            if (this.parent == null) {
                rectangle = new Rectangle(nArray[0], nArray2[0], 0, 0);
                event.setBounds(rectangle);
            } else {
                rectangle = this.display.mapInPixels((Control)this.parent, null, nArray[0], nArray2[0]);
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 0, 0);
                event.setBounds(rectangle2);
            }
            if ((this.style & 0x10) != 0) {
                Point point;
                this.resizeRectangles(nArray[0] - this.oldX, nArray2[0] - this.oldY);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean bl = false;
                if (this.rectangles != objectArray2) {
                    int n2 = this.rectangles.length;
                    if (n2 != objectArray.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            if (this.rectangles[i].equals((Object)objectArray[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(this.rectangles);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    nArray[0] = point.x;
                    nArray2[0] = point.y;
                }
            } else {
                this.moveRectangles(nArray[0] - this.oldX, nArray2[0] - this.oldY);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean bl = false;
                if (this.rectangles != objectArray2) {
                    int n3 = this.rectangles.length;
                    if (n3 != objectArray.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n3; ++i) {
                            if (this.rectangles[i].equals((Object)objectArray[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(this.rectangles);
                }
            }
            this.oldX = nArray[0];
            this.oldY = nArray2[0];
        }
        this.tracking = (n = Control.fixGdkEventTypeValues(n)) != 7;
        return 0L;
    }

    void moveRectangles(int n, int n2) {
        if (this.bounds == null) {
            return;
        }
        if (n < 0 && (this.style & 0x4000) == 0) {
            n = 0;
        }
        if (n > 0 && (this.style & 0x20000) == 0) {
            n = 0;
        }
        if (n2 < 0 && (this.style & 0x80) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x400) == 0) {
            n2 = 0;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
            n *= -1;
        }
        this.bounds.x += n;
        this.bounds.y += n2;
        for (int i = 0; i < this.rectangles.length; ++i) {
            this.rectangles[i].x += n;
            this.rectangles[i].y += n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        if (Tracker.logger.level >= 7) {
            logger.dumpStack(7, "open()", "");
        }
        this.checkWidget();
        if (!GTK.GTK4) {
            this.window = GDK.gdk_get_default_root_window();
        }
        if (this.parent != null) {
            this.window = this.gtk_widget_get_window(this.parent.paintHandle());
        }
        if (this.window == 0L) {
            return false;
        }
        this.cancelled = false;
        this.tracking = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            int n;
            boolean bl;
            int n2;
            boolean bl2;
            exception.printStackTrace(printWriter);
            printWriter.close();
            String string = byteArrayOutputStream.toString();
            boolean bl3 = bl2 = string.indexOf("org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager.startDrag") > 0 || string.indexOf("org.eclipse.ui.internal.dnd.DragUtil.performDrag") > 0;
            if (Tracker.logger.level >= 9) {
                logger.build("open()").add("insideDnD: ").add(bl2).log(9);
            }
            if (bl2) {
                this.display.runDNDTrackerHooks(true, false);
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            if (GTK.GTK4) {
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                this.display.getPointerPosition(dArray, dArray2);
                nArray[0] = (int)dArray[0];
                nArray2[0] = (int)dArray2[0];
            } else {
                this.display.getWindowPointerPosition(this.window, nArray, nArray2, nArray3);
            }
            int n3 = this.style & 0x480;
            if (n3 == 128 || n3 == 1024) {
                this.cursorOrientation |= n3;
            }
            if ((n2 = this.style & 0x24000) == 16384 || n2 == 131072) {
                this.cursorOrientation |= n2;
            }
            boolean bl4 = bl = (nArray3[0] & (n = 1792)) != 0;
            if (!bl) {
                Point point = null;
                point = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
                if (point != null) {
                    nArray[0] = point.x;
                    nArray2[0] = point.y;
                }
            }
            this.oldX = nArray[0];
            this.oldY = nArray2[0];
            this.grabbed = this.grab();
            this.lastCursor = this.cursor != null ? this.cursor.handle : 0L;
            this.cachedCombinedDisplayResolution = Display.getDefault().getBounds();
            this.overlay = GTK3.gtk_window_new((int)1);
            GTK3.gtk_window_set_skip_taskbar_hint((long)this.overlay, (boolean)true);
            GTK.gtk_window_set_title((long)this.overlay, (byte[])new byte[1]);
            if (this.parent != null) {
                GTK.gtk_window_set_transient_for((long)this.overlay, (long)this.parent.topHandle());
            }
            GTK.gtk_widget_realize((long)this.overlay);
            if (!GTK.GTK4) {
                long l = GTK3.gtk_widget_get_window((long)this.overlay);
                GDK.gdk_window_set_override_redirect((long)l, (boolean)true);
            }
            this.setTrackerBackground(true);
            Rectangle rectangle = this.display.getBoundsInPixels();
            GTK3.gtk_window_move((long)this.overlay, (int)rectangle.x, (int)rectangle.y);
            GTK3.gtk_window_resize((long)this.overlay, (int)rectangle.width, (int)rectangle.height);
            this.gtk_widget_show(this.overlay);
            Display display = this.display;
            Tracker tracker = display.tracker;
            display.tracker = this;
            try {
                while (this.tracking) {
                    if (this.parent != null && this.parent.isDisposed()) {
                        break;
                    }
                    display.runSkin();
                    display.runDeferredLayouts();
                    display.sendPreExternalEventDispatchEvent();
                    if (GTK.GTK4) {
                        OS.g_main_context_iteration(0L, true);
                    } else {
                        GTK3.gtk_main_iteration_do((boolean)true);
                    }
                    display.sendPostExternalEventDispatchEvent();
                    display.runAsyncMessages(false);
                }
            }
            finally {
                display.tracker = tracker;
            }
            this.ungrab();
            if (this.overlay != 0L) {
                GTK3.gtk_widget_destroy((long)this.overlay);
                this.overlay = 0L;
            }
            this.window = 0L;
            if (bl2) {
                display.runDNDTrackerHooks(false, this.cancelled);
            }
            return !this.cancelled;
        }
    }

    private void setTrackerBackground(boolean bl) {
        String string;
        if (this.cachedBackgroundIsOpaque == null || this.cachedBackgroundIsOpaque != bl) {
            this.cachedBackgroundIsOpaque = bl;
        } else if (bl == this.cachedBackgroundIsOpaque) {
            return;
        }
        if (bl) {
            GTK.gtk_widget_set_opacity((long)this.overlay, (double)1.0);
            string = "window {background-color: rgb(0,0,0);}";
        } else {
            GTK.gtk_widget_set_opacity((long)this.overlay, (double)0.0);
            string = "window {  border-top-color: transparent;border-left-color: transparent;border-right-color: transparent;border-bottom-color: transparent;}";
        }
        long l = GTK.gtk_widget_get_style_context((long)this.overlay);
        if (this.provider == 0L) {
            this.provider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider((long)l, (long)this.provider, (int)600);
            OS.g_object_unref(this.provider);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data((long)this.provider, (byte[])Converter.wcsToMbcs((String)string, (boolean)true), (long)-1L);
        } else {
            GTK3.gtk_css_provider_load_from_data((long)this.provider, (byte[])Converter.wcsToMbcs((String)string, (boolean)true), (long)-1L, null);
            GTK3.gtk_style_context_invalidate((long)l);
        }
        long l2 = Cairo.cairo_region_create();
        if (!GTK.GTK4) {
            GTK3.gtk_widget_shape_combine_region((long)this.overlay, (long)l2);
            GTK3.gtk_widget_input_shape_combine_region((long)this.overlay, (long)l2);
        }
        Cairo.cairo_region_destroy((long)l2);
    }

    boolean processEvent(long l) {
        int n = GDK.gdk_event_get_event_type((long)l);
        n = Control.fixGdkEventTypeValues(n);
        long l2 = GTK3.gtk_get_event_widget((long)l);
        switch (n) {
            case 3: {
                this.gtk_motion_notify_event(l2, l);
                break;
            }
            case 7: {
                this.gtk_button_release_event(l2, l);
                break;
            }
            case 8: {
                this.gtk3_key_press_event(l2, l);
                break;
            }
            case 9: {
                this.gtk3_key_release_event(l2, l);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                this.update();
                GTK3.gtk_main_do_event((long)l);
                break;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, (EventListener)controlListener);
        this.eventTable.unhook(10, (EventListener)controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, (EventListener)keyListener);
        this.eventTable.unhook(1, (EventListener)keyListener);
    }

    void resizeRectangles(int n, int n2) {
        Rectangle rectangle;
        int n3;
        if (this.bounds == null) {
            return;
        }
        if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
            n *= -1;
        }
        if (n < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (n > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (n2 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (n2 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    for (n3 = 0; n3 < this.proportions.length; ++n3) {
                        rectangle = this.proportions[n3];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                for (n3 = 0; n3 < this.proportions.length; ++n3) {
                    rectangle = this.proportions[n3];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n2 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n2 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    for (n3 = 0; n3 < this.proportions.length; ++n3) {
                        rectangle = this.proportions[n3];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n2) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n2 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                for (n3 = 0; n3 < this.proportions.length; ++n3) {
                    rectangle = this.proportions[n3];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n;
            this.bounds.width -= n;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n2;
            this.bounds.height -= n2;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n2;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i = 0; i < this.rectangles.length; ++i) {
            Rectangle rectangle2 = this.proportions[i];
            rectangleArray[i] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
        }
        this.rectangles = rectangleArray;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.cursor = cursor;
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        int n = rectangleArray.length;
        this.rectangles = new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle = rectangleArray[i];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl) {
        this.checkWidget();
        this.stippled = bl;
    }

    void ungrab() {
        if (this.grabbed) {
            this.gdk_pointer_ungrab(this.window, 0);
        }
    }

    void update() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
    }
}

