/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qflog;

import de.qfs.apps.qflog.logview.LogView;
import de.qfs.lib.command.CommandDistributor;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.log.Logger;
import de.qfs.lib.option.IntegerOption;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.MapResourceBundle;
import java.io.File;
import java.util.Hashtable;
import java.util.MissingResourceException;
import javax.swing.UIManager;

public class App {
    private static final Logger logger = new Logger("de.qfs.apps.qflog.App");
    private static App theApp = new App();
    private OptionSet options;
    private MapResourceBundle resources;
    private CommandDistributor cd = new CommandDistributor();
    private File configFile;
    private String serverName;
    private String serverHost;
    private Hashtable args;

    private App() {
        if (App.logger.level >= 7) {
            logger.log(7, "App()", "");
        }
        this.reloadResources();
        this.initOptions();
    }

    public static App instance() {
        if (App.logger.level >= 7) {
            logger.log(7, "instance()", "");
        }
        return theApp;
    }

    public static final MapResourceBundle getResources() {
        if (App.logger.level >= 7) {
            logger.log(7, "getResources()", "");
        }
        return App.instance()._getResources();
    }

    public static CommandDistributor getCommandDistributor() {
        return App.instance()._getCommandDistributor();
    }

    public static OptionSet getOptions() {
        return App.instance()._getOptions();
    }

    private final MapResourceBundle _getResources() {
        return this.resources;
    }

    private final CommandDistributor _getCommandDistributor() {
        return this.cd;
    }

    private final OptionSet _getOptions() {
        return this.options;
    }

    public void reloadResources() {
        block3: {
            if (App.logger.level >= 7) {
                logger.log(7, "reloadResources()", "");
            }
            try {
                this.resources = new MapResourceBundle();
                this.resources.setResolvingClass(this.getClass());
                this.resources.fetchProperties("/de/qfs/lib/resources/properties/qflib", MapResourceBundle.class);
                this.resources.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/logview", LogView.class);
                this.resources.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/loglevelview", LogView.class);
                this.resources.fetchProperties("/de/qfs/apps/qflog/logview/resources/properties/logtableview", LogView.class);
                this.resources.fetchProperties("/de/qfs/apps/qflog/resources/properties/logserver", this.getClass());
            }
            catch (MissingResourceException missingResourceException) {
                if (App.logger.level < 1) break block3;
                logger.log("reloadResources()", missingResourceException);
            }
        }
    }

    public final File getConfigFile() {
        return this.configFile;
    }

    public final void setConfigFile(File file) {
        this.configFile = file;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final void setServerName(String string) {
        this.serverName = string;
    }

    public final String getServerHost() {
        return this.serverHost;
    }

    public final void setServerHost(String string) {
        this.serverHost = string;
    }

    public final Hashtable getArgs() {
        return this.args;
    }

    public final void setArgs(Hashtable hashtable) {
        if (App.logger.level >= 7) {
            logger.log(7, "setArgs(Hashtable)", (String)(App.logger.level < 8 ? "" : "args: " + String.valueOf(hashtable)));
        }
        this.args = hashtable;
    }

    private void initOptions() {
        this.options = new OptionSet("LogServer Options");
        this.options.add(new IntegerOption("maxClients", 4));
        this.options.add(new IntegerOption("maxNamedClients", 4));
        this.options.add(new IntegerOption("maxDeadClients", 4));
        this.options.add(new IntegerOption("maxDeadNamedClients", 3));
        this.options.add(new StringOption("lookAndFeel", UIManager.getSystemLookAndFeelClassName()));
        Configuration.instance().register(this.options);
    }
}

